/*
 * lp.h
 *
 * General routines for lpr routines
 *
 * by Eric Brown
 *    28 Oct '92
 */

#ifndef _LP_H_
#define _LP_H_

#define DEFAULT_PRINTER		"lp"
#define PRINTER_PORT		515
#define MAX_PRIV_PORT		1023
#define BIND_RETRIES		30

/* LPD request codes */
#define LPD_CHECK_QUEUE             '\001'
#define LPD_PRINT_JOB               '\002'
#define LPD_DISPLAY_SHORT_QUEUE     '\003'
#define LPD_DISPLAY_LONG_QUEUE      '\004'
#define LPD_REMOVE_JOB              '\005'
#define LPD_END_TRANSFER            '\000'
#define LPD_ABORT                   '\001'
#define LPD_RECEIVE_CONTROL_FILE    '\002'
#define LPD_RECEIVE_DATA_FILE       '\003'

/* LPD return codes */
#define LPD_OK                  '\0'
#define LPD_ERROR               '\1'
#define LPD_NO_SPOOL_SPACE      '\2'

char *lp_printcap_server_lookup(char *printer);
int  lp_tcp_startup();
void lp_tcp_shutdown();
int  lp_tcp_open(char *server);
void lp_randomize();

#endif /*_LP_H_*/

