/*
 * lpr.c - Windows NT lpr
 *
 * by Eric W. Brown
 *    27 October '92
 */
#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <winsock.h>
#include "lp.h"

#define ARGS_LEN 512
#define DEFAULT_INTERVAL 5

int usage()
{
	fprintf(stderr, "Usage: lpq [-Pprinter] [-Sserver] [-l] [+[n]]\n");
	exit(1);
	return 0;
} /* usage() */

void main(int argc, char **argv)
{
	int 	sockfd = 0;
	char	*printer = NULL;
	char	*server = NULL;
	char	args[ARGS_LEN + 1] = "";
	int		args_len = 0;
	char	request[ARGS_LEN + 128];
	char	request_code = LPD_DISPLAY_SHORT_QUEUE;
	int		interval = 0;
	char	buf[133];
	int		len;
	
	/*
	 * Get environment variables
	 */
	server = getenv("SERVER");
	printer = getenv("PRINTER");
	if (!printer) 
		printer = DEFAULT_PRINTER;
	
	/*
	 * Parse command line
	 */
#define NEXT_ARG()  (argc--, argv++, argc ? *argv : (char *)(usage(), NULL))
#define ARG_ARG()   (strlen(*argv) == 2 ? NEXT_ARG() : (*argv) + 2)
	while (argc > 1) {
		NEXT_ARG();
		if (*argv[0] == '-' || *argv[0] == '/') {
			switch(argv[0][1]) {
			case 'P':
				printer = ARG_ARG();
				break;
			case 'S':
				server = ARG_ARG();
				break;
			case 'l':
				request_code = LPD_DISPLAY_LONG_QUEUE;
				break;
			default:
				fprintf(stderr, "lpq: %s: Invalid option\n", *argv);
				usage();
			} /* switch */
		}
		else if (*argv[0] == '+') {
			if (argv[0][1] != 0)
				sscanf(argv[0] + 1, "%d", &interval);
			if (interval <= 0)
				interval = DEFAULT_INTERVAL;
			fprintf(stderr, "lpq: The '+' option is not supported at this time.\n");
		}
		else {
			args_len += strlen(*argv) + 1;
			if (args_len > ARGS_LEN) {
				fprintf(stderr, "lpq: Command line too long!\n");
				exit(1);
			} /* if */
			strcat(args, " ");
			strcat(args, *argv);
		} /* else */
	} /* while argc */
		
	
	/*
	 * Do a lookup in the printcap file if necessary
	 */
	if (!server)
		if (!(server = lp_printcap_server_lookup(printer))) {
			fprintf(stderr, "No server, %s, and no printer, %s, in printcap file!\n", 
					server, printer);
			usage();
		} /* if */
	
	
	/*
	 * Initialize tcp
	 */
	if (lp_tcp_startup()) {
		fprintf(stderr, "lpq: Couldn't initalize tcp/ip\n");
		exit(1);
	} /* if */
	
	
	/*
	 * Open socket
	 */
	if ((sockfd = lp_tcp_open(server)) < 0) {
		lp_tcp_shutdown();
		fprintf(stderr, "lpq: Couldn't open connection to %s\n", server);
		exit(1);
	} /* if */
	
	
	/*
	 * Build request
	 */
	sprintf(request, "%c%s%s\n", request_code, printer, args);


	/*
	 * Send request
	 */
	if (send(sockfd, request, strlen(request), 0) != (int)strlen(request)) {
		closesocket(sockfd);
		lp_tcp_shutdown();
		fprintf(stderr, "lpq: Error making request\n");
		exit(1);
	} /* if */
	
	
	/*
	 * Print output
	 */
	while(1) {
		memset((void *)buf, 0, 133);
		len = recv(sockfd, buf, 132, 0);
		if (len <= 0)
			break;
		printf("%s", buf);
	} /* while */
	
	
	/*
	 * Clean up
	 */
	closesocket(sockfd);
	lp_tcp_shutdown();
	exit(0);
} /* main() */


