/*============================================================================
  Hello - Windows Programmer's Journal Volume 1 Number 3

  File      : Hello.C

  Prototype : 

  Call      : 

  Library   : 

  Example   : 

  7 February 1993 - dlcampbell
  1993 Dave Campbell WynApse

  from:
       Hello.C
	By Pete Davis and Mike Wallace
	Windows Programmer's Journal
	Volume 1 Number 2
----------------------------------------------------------------------------*/
#include <windows.h>
#include "hello.h"

char   szAppName[] = "Hello";
HANDLE hInst;
HWND   hWndMain;
int    InitSettings;

/*----------------------------------------------------------------------------
  Function Prototypes
----------------------------------------------------------------------------*/
BOOL FAR PASCAL HelloDlgProc(HWND, WORD, WORD, LONG);
long FAR PASCAL WndProc(HWND, unsigned, WORD, LONG);
BOOL            InitInstance(HANDLE);

/* The main procedure. This is called by Windows when your program is run. */
/* hInstance is the handle for the current instance of the program         */
/* hPrevInst is the handle for the last instance of the program to run     */
/* CmdLine is a pointer to a string of whatever command line params came in*/
/* nCmd is the specifies the applications appearance.                      */

int FAR PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInst, LPSTR CmdLine,
                                                                     int nCmd)
{
MSG   msg;								/* Message */
HWND  hWnd;                   	/* Our Window Handle */
HMENU hMenu;

if (!hPrevInst)                         /* If no instance already exists, */
   {
	if (!InitInstance(hInstance))   	/* try initializing instance */
		return FALSE;                     /* No dice, it failed */
	}

hInst = hInstance;
	
hWndMain = CreateWindow(szAppName,              /* Window Class */
			      			"Hello World Program",  /* Window caption */
						      WS_OVERLAPPEDWINDOW,    /* Overlapped style */
						      CW_USEDEFAULT,          /* Use defaults for the */
						      CW_USEDEFAULT,          /* X & Y Positions and  */
						      CW_USEDEFAULT,          /* X & Y sizes */
						      CW_USEDEFAULT,          
						      NULL,                   /* Parent Window */
						      NULL,
						      hInstance,              /* Instance */
						      NULL);                  /* Creation Params */

if (hWndMain == NULL)
   return 0;

hMenu = GetSystemMenu(hWndMain, FALSE);
AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);
AppendMenu(hMenu, MF_STRING,    IDM_SETUP, "Setup...");

ShowWindow(hWndMain, nCmd);
UpdateWindow(hWndMain);
	
while (GetMessage(&msg, NULL, 0, 0))
   {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
   }
	
return msg.wParam;
}                                       /* int FAR PASCAL WinMain */

BOOL InitInstance (HANDLE hInstance)
{
WNDCLASS wc;                            /* Window class structure */

wc.lpszMenuName  = NULL;
wc.lpszClassName = szAppName;
wc.hbrBackground = GetStockObject(WHITE_BRUSH);  /* White bkgrnd */
wc.hInstance     = hInstance;
wc.style         = CS_VREDRAW | CS_HREDRAW;
wc.lpfnWndProc   = WndProc;          	/* Name of proc to handle window */
wc.hCursor       = LoadCursor(NULL, IDC_ARROW);  /* Arrow Cursor */
wc.hIcon         = LoadIcon(NULL, IDI_APPLICATION);  /* Generic Icon */
wc.cbClsExtra    = 0;            	/* no extras */
wc.cbWndExtra    = 0;            	/* No Extras */

return (RegisterClass(&wc)); /* Let's register that class */
}                                       /* BOOL InitInstance */

/* This is our main windows procedure. It receives messages in message, then,
depending on what the message is, we react accordingly
*/

long FAR PASCAL WndProc(HWND hWnd, unsigned message, WORD wParam, LONG lParam)
{
HDC            hdc;
PAINTSTRUCT    ps;
RECT           rect;
static FARPROC lpfnHelloDlgProc;

switch (message)
   {
   case WM_CREATE :
      InitSettings = GetPrivateProfileInt("Hello", "Setup", 1, "Hello.ini");
      InitSettings = InitSettings ? IDM_HELLO : IDM_GOODBYE;
      hdc = GetDC(hWnd);
         InvalidateRect(hWnd, NULL, TRUE);
      ReleaseDC(hWnd, hdc);

/*----------------------------------------------------------------------------
  fall through to WM_PAINT...
----------------------------------------------------------------------------*/
   case WM_PAINT :
      hdc = BeginPaint(hWnd,&ps);        /* returns pointer to hdc */
      GetClientRect(hWnd, &rect);
/*
  -1 tells the DrawText function to calculate length of string based on
  NULL-termination
*/
      DrawText(hdc, (InitSettings == IDM_HELLO) ? "Hello Windows!" : "Goodbye Windows!", -1,
                                   &rect, DT_SINGLELINE|DT_CENTER|DT_VCENTER);
      EndPaint(hWnd,&ps);
      return 0;

   case WM_SYSCOMMAND :
      switch (wParam)
         {
         case IDM_SETUP :
            lpfnHelloDlgProc = MakeProcInstance(HelloDlgProc, hInst);
            DialogBox(hInst, "Hello", hWnd, lpfnHelloDlgProc);
            FreeProcInstance(lpfnHelloDlgProc);
            return 0;
         }

      break;

  case WM_DESTROY :
      PostQuitMessage(0);
      return 0;
   }
return DefWindowProc(hWnd, message, wParam, lParam);
}                                       /* long FAR PASCAL WndProc */

/*============================================================================
  HelloDlgProc -- 

  File      : Test.C

  Prototype : BOOL FAR PASCAL HelloDlgProc(HWND, WORD, WORD, LONG);

  Call      : HelloDlgProc(hDlg, message, wParam, lParam);

  Library   : 

  19 January 1993 - dlcampbell
  (c) 1993 WynApse
----------------------------------------------------------------------------*/
BOOL FAR PASCAL HelloDlgProc (HWND hDlg, WORD message, WORD wParam,
                                                                  LONG lParam)
{
switch (message)
   {
   case WM_INITDIALOG :
      CheckRadioButton(hDlg, IDM_HELLO, IDM_GOODBYE, InitSettings);
      return TRUE;

   case WM_COMMAND :
      switch (wParam)
         {
         case IDM_HELLO : 
			   WritePrivateProfileString("Hello", "Setup", "1", "Hello.ini");
            InitSettings = wParam;
            break;

         case IDM_GOODBYE : 
			   WritePrivateProfileString("Hello", "Setup", "0", "Hello.ini");
            InitSettings = wParam;
            break;

         case IDOK :
            EndDialog(hDlg, wParam);
            return TRUE;

         }
      break;

   }
return FALSE;
}                                       /* HelloDlgProc */
