program samplapp;
{$R samplapp.RES}

uses WObjects, WinTypes, WinProcs, Strings, WinDos, Owndraw;

type
  TMyApp = object(TApplication)
    procedure InitInstance; virtual;
    procedure InitMainWindow; virtual;
  end;

  TAboutDialog = object (TOwnerDialog)
    constructor Init (AParent : PWindowsObject; AName : PChar);
    procedure Ok (var Msg : TMessage); virtual id_First+1;
    procedure Cancel (var Msg : TMessage); virtual id_First+2;
  end;

  PMyWindow = ^TMyWindow;
  TMyWindow = object(TWindow)
    constructor Init (ATitle : PChar);
    procedure SetupWindow ; virtual;
    function GetClassName : PChar; virtual;
    procedure GetWindowClass (var AWndClass : TWndClass); virtual;
    Procedure AboutChoice (var Msg : TMessage); virtual cm_First + 100;
    Procedure ExitChoice (var Msg : TMessage); virtual cm_First + 102;
    destructor Done; virtual;
  end;

constructor TAboutDialog.Init (AParent : PWindowsObject; AName : PChar);
begin
  TOwnerDialog.Init (AParent, AName);
  NewButton (1, True);  { Ok Button ID is default button }
  NewButton (2, False); { Cancel Button ID is not default button }
end;

procedure TAboutDialog.Ok (var Msg : TMessage);
begin
  MessageBox (HWindow, 'Ok Button pressed.', 'Button Pushed!', mb_IconInformation or mb_Ok);
  TOwnerDialog.Ok (Msg);  { Call parent Ok Button method }
end;

procedure TAboutDialog.Cancel (var Msg : TMessage);
begin
  MessageBox (HWindow, 'Cancel Button pressed.', 'Button Pushed!', mb_IconInformation or mb_Ok);
  TOwnerDialog.Cancel (Msg);
end;

{-------TMyWindow.Init}
constructor TMyWindow.Init(ATitle : PChar);
begin
  TWindow.Init(Nil, ATitle);
  with Attr do
    begin
      Style := ws_OverlappedWindow;
      Menu := LoadMenu(hInstance, 'MAINMENU');
    end;
end;

{-------TMyWindow.SetupWindow;}
procedure TMyWindow.SetupWindow;
begin
  TWindow.SetupWindow;
end;

{-------TMyWindow.GetClassName}
function TMyWindow.GetClassName : PChar;
begin
  GetClassName := 'SAMPLAPP';
end;

{-------TMyWindow.GetWindowClass}
procedure TMyWindow.GetWindowClass(var AWndClass : TWndClass);
begin
  TWindow.GetWindowClass(AWndClass);
  with AWndClass do
    begin
      hCursor := LoadCursor(0, PChar(idc_Arrow));
      hIcon := LoadIcon(0, PChar(idi_Application));
      Style := cs_Vredraw or cs_Hredraw;
    end;
end;

Procedure TMyWindow.AboutChoice (var Msg : TMessage);
var Dialog : TAboutDialog;

begin
  Dialog.Init (@Self, 'ABOUT');
  Dialog.Execute;
  Dialog.Done;
end;

Procedure TMyWindow.ExitChoice(var Msg : TMessage);
begin
  PostQuitMessage (0);
end;

{------TMyWindow.Done}
destructor TMyWindow.Done;
begin
  TWindow.Done;
end;

{------TMyApp.InitMainWindow}
procedure TMyApp.InitMainWindow;
begin
  MainWindow := New(PMyWindow, Init('Owner Draw Buttons Demo'));
end;

{------TMyApp.InitInstance}
procedure TMyApp.InitInstance;
begin
  TApplication.InitInstance;
  hAccTable := 0;
end;

var
  App : TMyApp;
begin
  App.Init('MyWindow');
  App.Run;
  App.Done;
end.
