# makefile for rodsapp application

# compile option flags
# /c 		compile without linking
# /AM		medium model
# /Gsw		s: remove stack probes
#		w: generates entry/exit code for Windows
# /W3		warning level 3
# /Zp		pack data structures
# /I		look for include files
# /nologo	don't display compiler logo
# /Fo		give object files the name of the current targets name

TMPDRIVE=c:\tmp

WLIB=libw mlibcew 
IMPLIBS=test

OBJ=rodsapp.obj winmain.obj wndproc.obj

CFLAGS=cl /c /AM /D LINT_ARGS /Gws /W3 /Zip /Od /nologo

# Update the executable file if necessary, and if so, add the resource back in.
# The /NOE must be included when linking with Windows libraries.

rodsapp.exe: $(OBJ) rodsapp.res rodsapp.def
        del $(TMPDRIVE)lk.res
        echo $(OBJ)>>$(TMPDRIVE)lk.res
        echo rodsapp.exe/align:16>>$(TMPDRIVE)lk.res
        echo rodsapp.map/map/NOD/CO/LI>>$(TMPDRIVE)lk.res
        echo $(WLIB) $(IMPLIBS)>>$(TMPDRIVE)lk.res
        echo rodsapp.def>>$(TMPDRIVE)lk.res
        link  @$(TMPDRIVE)lk.res
        rc rodsapp.res

# Update the object file if necessary

rodsapp.obj: rodsapp.c rodsapp.h
        $(CC) $(CFLAGS) -NT Initialization_code rodsapp.c

winmain.obj: winmain.c rodsapp.h
        $(CC) $(CFLAGS)  -NT Resident_code winmain.c

wndproc.obj: wndproc.c rodsapp.h testlib.h
        $(CC) $(CFLAGS)  -NT Resident_code wndproc.c

# Update the resource if necessary
rodsapp.res: rodsapp.rc rodsapp.h
        rc -r rodsapp.rc

