/*	NetBIOS.h 
 *	based on the Win32 specification
 *
 *	Note: must include <windows.h> before this file
 */

#define UCHAR	BYTE	/* Win32 calls this UCHAR */
#define PUCHAR	LPBYTE	/*       and PUCHAR       */

typedef struct _NCB		/* NetBIOS control block */
{
	UCHAR	ncb_command;		/* command code */
	UCHAR	ncb_retcode;		/* return code */
	UCHAR	ncb_lsn;			/* local session number */
	UCHAR	ncb_num;			/* number of our network name */
	PUCHAR	ncb_buffer;			/* address of our message buffer */
	UCHAR	ncb_callname[16];	/* blank-padded name of remote */
	UCHAR	ncb_name[16];		/* our blank-padded netname */
	UCHAR	ncb_rto;			/* rcv timeout/retry count */
	UCHAR	ncb_sto;			/* send timeout/retry count */
#ifdef WIN32
	void	(*ncb_post) (struct _NCB *); /* post routine address */
#else
	FARPROC	ncb_post;
#endif
	UCHAR	ncb_lana_num;		/* lana (adapter) number 0=1st, etc */
	UCHAR	ncb_cmd_cplt;		/* 0xff => command pending */
	UCHAR	ncb_reserve[10];	/* reserved, used by BIOS */
#ifdef WIN32
	UCHAR	ncb_event;			/* HANDLE to WIN32 event set to */
#endif							/* signalled state when ASYNCH completes */ 
}	NCB, FAR *PNCB;

UCHAR PASCAL FAR NetBIOS (PNCB Ncb);	/* our function prototype */
