#include "windows.h"
#include "winnet.h"

WORD NetCaps[11];

char *Net_Type[] = { "None","MSNet","LanMan","NetWare","Vines","10NET",
					"Locus","Sun PC NFS","LANStep","9TILES","Lantastic",
					"AS400"};

/* Get Network Capabilities for use later */
static void PASCAL NetGetCapability()
{
	WORD	i;
	for (i = 1; i <= 11; i++)
		if ( i != 4)
			NetCaps[i] = WNetGetCaps(i);
}

/*	NetCapsDlgProc(HWND, unsigned, WORD, LONG)
 *
 *	Processes messages for "NetCaps" dialog box
 *	Messages:
 *		WM_INITDIALOG - initialize dialog box
 *		WM_COMMAND    - Input received
 *	No initialization is needed for this particular dialog box, but TRUE
 *	must be returned to Windows.
 *
 *	Wait for user to click on "Ok" button, then close the dialog box.
 */
BOOL FAR PASCAL NetCapsDlgProc(HWND hDlg, unsigned message, WORD wParam,
							    LONG lParam)
{
    WORD nIndex;

    switch (message) {

	case WM_INITDIALOG:		   /* message: initialize dialog box */

		NetGetCapability();		/* get Network Capabilities */

	   /* query net version number (SPEC_VERSION) == NetCaps[1] */
	    wsprintf((LPSTR) szBuffer, "%u.%u",  HIBYTE(NetCaps[1],LOBYTE(NetCaps[3]) );
	    SendDlgItemMessage(hDlg, IDD_DRVVER, WM_SETTEXT, NULL, (LONG)(LPSTR) szBuffer);

	   /* query for Username support (USER) == NetCaps[4] */
	    if (NetCaps[4] & 1 )
			lstrcpy(szBuffer, "Supported");
	    else 
			lstrcpy(szBuffer, "Unsupported");
	    SendDlgItemMessage(hDlg, IDD_USER, WM_SETTEXT, NULL, (LONG)(LPSTR) szBuffer);

	   /* query connection support mask (CONNECTION) == NetCaps[6] */
		if ( NetCaps[6]) {
		    if (NetCaps[6] & 0x0001) {	/* AddConnection */ 
				lstrcpy(szBuffer, "Add");
				SendDlgItemMessage(hDlg, IDD_CONNECTIONS, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
		    if (NetCaps[6] & 0x0002) {	/* CancelConnection */ 
				lstrcpy(szBuffer, "Cancel");
				SendDlgItemMessage(hDlg, IDD_CONNECTIONS, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
		    if (NetCaps[6] & 0x0004) {	/* GetConnection */ 
				lstrcpy(szBuffer, "Get");
				SendDlgItemMessage(hDlg, IDD_CONNECTIONS, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
		    if (NetCaps[6] & 0x0008) {	/* AutoConnection */ 
				lstrcpy(szBuffer, "AutoCon");
				SendDlgItemMessage(hDlg, IDD_CONNECTIONS, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
		    if (NetCaps[6] & 0x0010) {	/* BrowseDialog for connections */ 
				lstrcpy(szBuffer, "Browse");
				SendDlgItemMessage(hDlg, IDD_CONNECTIONS, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
		    if (NetCaps[6] & 0x0020) {	/* RestoreConnection */ 
				lstrcpy(szBuffer, "Restore");
				SendDlgItemMessage(hDlg, IDD_CONNECTIONS, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
		}
		else {
			lstrcpy(szBuffer, "Not Supported");
			SendDlgItemMessage(hDlg, IDD_CONNECTIONS, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
	    }

	   /* query printing support (PRINTING) == NetCaps[7] */
		if ( NetCaps[7] ) {
			if (NetCaps[7] & 0x0002) {
				lstrcpy(szBuffer, "Open Job");
				SendDlgItemMessage(hDlg, IDD_PRINTING, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
			if (NetCaps[7] & 0x0004) {
				lstrcpy(szBuffer, "Close Job");
				SendDlgItemMessage(hDlg, IDD_PRINTING, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
			if (NetCaps[7] & 0x0010) {
				lstrcpy(szBuffer, "Hold Job");
				SendDlgItemMessage(hDlg, IDD_PRINTING, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
			if (NetCaps[7] & 0x0020) {
				lstrcpy(szBuffer, "Release Job");
				SendDlgItemMessage(hDlg, IDD_PRINTING, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
			if (NetCaps[7] & 0x0040) {
				lstrcpy(szBuffer, "Cancel Job");
				SendDlgItemMessage(hDlg, IDD_PRINTING, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
			if (NetCaps[7] & 0x0080) {
				lstrcpy(szBuffer, "Set Job Copies");
				SendDlgItemMessage(hDlg, IDD_PRINTING, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
			if (NetCaps[7] & 0x0100) {
				lstrcpy(szBuffer, "Watch Queue");
				SendDlgItemMessage(hDlg, IDD_PRINTING, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
			if (NetCaps[7] & 0x0200) {
				lstrcpy(szBuffer, "UnWatch Queue");
				SendDlgItemMessage(hDlg, IDD_PRINTING, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
			if (NetCaps[7] & 0x0400) {
				lstrcpy(szBuffer, "Lock Queue Data");
				SendDlgItemMessage(hDlg, IDD_PRINTING, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
			if (NetCaps[7] & 0x0800) {
				lstrcpy(szBuffer, "Unlock Queue Data");
				SendDlgItemMessage(hDlg, IDD_PRINTING, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
			if (NetCaps[7] & 0x1000) {
				lstrcpy(szBuffer, "Change Message");
				SendDlgItemMessage(hDlg, IDD_PRINTING, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
			if (NetCaps[7] & 0x2000) {
				lstrcpy(szBuffer, "Abort Job");
				SendDlgItemMessage(hDlg, IDD_PRINTING, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
			if (NetCaps[7] & 0x8000) {
				lstrcpy(szBuffer, "Write Job");
				SendDlgItemMessage(hDlg, IDD_PRINTING, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
	    }
		else {
			lstrcpy(szBuffer, "Not supported");
			SendDlgItemMessage(hDlg, IDD_PRINTING, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
	    }

	   /* query dialog support (DIALOG) == NetCaps[8] */
		if ( NetCaps[8] ) {		/* which dialog boxes are supported */
		{
			if (NetCaps[8] & 0x0001) {
				lstrcpy(szBuffer, "Device Mode");
				SendDlgItemMessage(hDlg, IDD_DIALOG, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
			if (NetCaps[8] & 0x0002) {
				lstrcpy(szBuffer, "Browse Dialog");
				SendDlgItemMessage(hDlg, IDD_DIALOG, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
			if (NetCaps[8] & 0x0004) {
				lstrcpy(szBuffer, "Connect Dialog");
				SendDlgItemMessage(hDlg, IDD_DIALOG, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
			if (NetCaps[8] & 0x0008) {
				lstrcpy(szBuffer, "Disconnect Dialog");
				SendDlgItemMessage(hDlg, IDD_DIALOG, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
			if (NetCaps[8] & 0x0010) {
				lstrcpy(szBuffer, "View Queue Dialog");
				SendDlgItemMessage(hDlg, IDD_DIALOG, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
			if (NetCaps[8] & 0x0020) {
				lstrcpy(szBuffer, "Property Dialog");
				SendDlgItemMessage(hDlg, IDD_DIALOG, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
			if (NetCaps[8] & 0x0040) {
				lstrcpy(szBuffer, "Connection Dialog");
				SendDlgItemMessage(hDlg, IDD_DIALOG, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
		}
		else {
			lstrcpy(szBuffer, "Not supported\n");
			SendDlgItemMessage(hDlg, IDD_DIALOG, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
	    }

#define IDD_ADMIN	IDD_CONNECTIONS
	   /* query administrative support (ADMIN) = NetCaps[9] */
		if ( NetCaps[9] ) {
			if ( NetCaps[9] & 0x0001 ) {
				lstrcpy(szBuffer, "Get Directory Type");
				SendDlgItemMessage(hDlg, IDD_ADMIN, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
			if ( NetCaps[9] & 0x0002 ) {
				lstrcpy(szBuffer, "Dir Notify");
				SendDlgItemMessage(hDlg, IDD_ADMIN, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
			if ( NetCaps[9] & 0x0004 ) {
				lstrcpy(szBuffer, "Long Names");
				SendDlgItemMessage(hDlg, IDD_ADMIN, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
		    }
	    }
		else {
			lstrcpy(szBuffer, " ADMIN Not supported\n");
			SendDlgItemMessage(hDlg, IDD_DIALOG, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
	    }

	   /* query print manager support (PRINTMGREXT) == NetCaps[11] */
	    if ( NetCaps[11] ) {
			wsprintf((LPSTR) szBuffer, "Print Manager %u.%u", HIBYTE(NetCaps[11]), LOBYTE(NetCaps[11]));
			SendDlgItemMessage(hDlg, IDD_PRINTING, LB_ADDSTRING, NULL, (LONG)(LPSTR) szBuffer);
	    }

	    return (TRUE);
	    break;

	case WM_COMMAND:		      /* message: received a command */
	    if (wParam == IDOK) {	      /* "OK" box selected?	     */
		EndDialog(hDlg, TRUE);	      /* Exits the dialog box	     */
		return (TRUE);
	    }
	    break;
    }
    return (FALSE);			      /* Didn't process a message    */
}
