(* ----------------------------------------------------------- *(
**  COMMON.PAS -- Windows 3.1 common dialogs demonstration     **
** ----------------------------------------------------------- **
**  This program demonstrates how to use the nine common       **
**  dialogs in Windows 3.1 with Turbo Pascal for Windows. The  **
**  program requires TPW 1.0 (patched for Windows 3.1) or you  **
**  can use TPW 1.5. The program DOES NOT COMPILE with the     **
**  original unpatched TPW 1.0.                                **
** ----------------------------------------------------------- **
**       Copyright (c) 1992 by Tom Swan. Use as you wish       **
)* ----------------------------------------------------------- *)

program Common;

{$R common.res}

uses WObjects, WinTypes, WinProcs, Strings, Win31, CommDlg;

{$I common.inc}

const

  em_BadVersion = -100;

type

  TColorArray = array[0 .. 15] of TColorRef;

  TCommApp = object(TApplication)
    procedure Error(ErrorCode: Integer); virtual;
    procedure InitInstance; virtual;
    procedure InitMainWindow; virtual;
  end;

  PCommWin = ^TCommWin;
  TCommWin = object(TWindow)
  {- Color dialog data members }
    Color: TColorRef;  { Selected color }
    AColors: TColorArray;  { Custom color array }
  {- Font dialog data member }
    Font: TLogFont;  { Logical font }
  {- File dialog data members }
    Filename: array[0 .. 255] of Char;  { Current file name }    
FilterStr: array[0 .. 80] of Char;  { File filter list }    
FilterIndex: Integer;  { Number of filter for dlg list box }   {-
Find and replace dialog data members }
    HFindDLG: HWND;
    FindStr: array[0 .. 40] of Char;
    ReplaceStr: array[0 .. 40] of Char;
    FR: TFindReplace;
  {- Constructor }
    constructor Init(AParent: PWindowsObject; ATitle: PChar);   {-
Inherited methods }
    function GetClassName: PChar; virtual;
    procedure GetWindowClass(var AWndClass: TWndClass); virtual;  
{- Message-response methods (menu commands) }
    procedure CMFileExit(var Msg: TMessage);
      virtual cm_First + cm_FileExit;
    procedure CMDialogsColor(var Msg: TMessage);
      virtual cm_First + cm_DialogsColor;
    procedure CMDialogsFont(var Msg: TMessage);
      virtual cm_First + cm_DialogsFont;
    procedure CMDialogsOpen(var Msg: TMessage);
      virtual cm_First + cm_DialogsOpen;
    procedure CMDialogsSaveAs(var Msg: TMessage);
      virtual cm_First + cm_DialogsSaveAs;
    procedure CMDialogsPrint(var Msg: TMessage);
      virtual cm_First + cm_DialogsPrint;
    procedure CMDialogsFind(var Msg: TMessage);
      virtual cm_First + cm_DialogsFind;
    procedure CMDialogsReplace(var Msg: TMessage);
      virtual cm_First + cm_DialogsReplace;
    procedure CMHelpAbout(var Msg: TMessage);
      virtual cm_First + cm_HelpAbout;
  end;

{ TCommApp }

{- Respond to startup errors }
procedure TCommApp.Error(ErrorCode: Integer);
begin
  if Status = em_BadVersion then
    MessageBox(0, 'Requires Windows 3.1 or later',
      'Version Error', mb_ApplModal or mb_IconStop or mb_Ok)   else
    TApplication.Error(ErrorCode);
end;

{- Detect Windows version number. Halt if < 3.1. }
procedure TCommApp.InitInstance;
var
  Version: LongInt;
  MajorRev, MinorRev: Byte;
  Okay: Boolean;
begin
  Version := GetVersion;
  MajorRev := LOBYTE(LOWORD(Version));
  MinorRev := HIBYTE(LOWORD(Version));
  if (MajorRev < 3) then Okay := false else
  if (MajorRev = 3) then Okay := (MinorRev >= 1) else
  if (MajorRev > 3) then Okay := true;  { I hope! }
  if Okay then
    TApplication.InitInstance
  else
    Status := em_BadVersion;
end;

{- Initialize the application's window }
procedure TCommApp.InitMainWindow;
begin
  MainWindow := New(PCommWin, Init(nil, 'Common Dialogs')); end;

{ TCommWin }

{- Initialize the application's window object }
constructor TCommWin.Init(AParent: PWindowsObject; ATitle:PChar);
var
  I: Integer;
begin
  TWindow.Init(AParent, ATitle);
  with Attr do
  begin
    Menu := LoadMenu(HInstance, PChar(id_Menu));
    X := GetSystemMetrics(sm_CXScreen) div 8;
    Y := GetSystemMetrics(sm_CYScreen) div 8;
    H := Y * 6;
    W := X * 6;
  end;
{- Initialize color dialog data members }
  Color := RGB(0, 0, 0);  { Initial color }
  for I := 0 to 15 do     { Set custom colors to white }
    AColors[I] := RGB(255, 255, 255);
{- Initialize logical font data members }
  FillChar(Font, sizeof(Font), #0);
{- Initialize file name and list-box filters (wild cards) }  
Filename[0] := #0;
  if LoadString(HInstance, str_FileFilters, FilterStr,
                Sizeof(FilterStr)) = 0 then
    FilterStr[0] := #0
  else
    for I := 0 to StrLen(FilterStr) do
      if FilterStr[I] = '|' then
        FilterStr[I] := #0;
  FilterIndex := 1;
{- Initialize find and replace data members }
  HFindDlg := 0;
  FindStr[0] := #0;
  ReplaceStr[0] := #0;
end;

{- Return unique name for modified window class }
function TCommWin.GetClassName: PChar;
begin
  GetClassName := 'TCommWin';
end;

{- Modify window class to use custom icon }
procedure TCommWin.GetWindowClass(var AWndClass: TWndClass); begin
  TWindow.GetWindowClass(AWndClass);
  AWndClass.HIcon := LoadIcon(HInstance, PChar(id_Icon));
end;
{- Exit program by closing the main window }
procedure TCommWin.CMFileExit(var Msg: TMessage);
begin
  CloseWindow;
end;

{- DIALOG #1: Common color dialog }
procedure TCommWin.CMDialogsColor(var Msg: TMessage);
var
  CC: TChooseColor;
  TempColors: TColorArray;
begin
  FillChar(CC, Sizeof(CC), #0);
  TempColors := AColors;  { Copy current color array }
  with CC do
  begin
    lStructSize := Sizeof(TChooseColor);
    hwndOwner := HWindow;
    Flags := cc_RGBInit or cc_FullOpen;
    rgbResult := Color;
    lpCustColors := @TempColors;
  end;
  if (ChooseColor(CC)) then with CC do
  begin
    Color := rgbResult;  { Use this color to draw }
    AColors := TempColors;  { Save custom color array }
  end;
end;

{- DIALOG #2: Common font-selection dialog }
procedure TCommWin.CMDialogsFont(var Msg: TMessage);
var
  CF: TChooseFont;
  TempFont: TLogFont;
begin
  FillChar(CF, Sizeof(CF), #0);
  TempFont := Font;  { Copy current font }
  with CF do
  begin
    lStructSize := SizeOf(TChooseFont);
    HWndOwner := HWindow;
    Flags := cf_InitToLogFontStruct or cf_Both or cf_Effects;    
lpLogFont := @TempFont;
    rgbColors := Color;  { Selected by Color dialog }
  end;
  if ChooseFont(CF) then with CF do
  begin
    Font := lpLogFont^;  { Use this font for text }
  end;
end;

{- DIALOG #3: Common file-open dialog }
procedure TCommWin.CMDialogsOpen(var Msg: TMessage);
var
  FN: TOpenFilename;
  Tempname: array[0 .. 255] of Char;
begin
  FillChar(FN, Sizeof(FN), #0);
  StrCopy(Tempname, Filename);  { Copy current file name }
  with FN do
  begin
    lStructSize := SizeOf(TOpenFilename);
    hWndOwner := HWindow;
    Flags := ofn_PathMustExist or ofn_FileMustExist;
    lpstrFile := Tempname;  { Address current file name }
    nMaxFile := Sizeof(Filename);
    lpstrFilter := FilterStr;  { Address file filters }
    nFilterIndex := FilterIndex;  { Filter for list box }
  end;
  if GetOpenFileName(FN) then with FN do
  begin
    StrCopy(Filename, lpstrFile);  { Save selected file name }    
FilterIndex := nFilterIndex;  { Save selected filter # }   end;
end;

{- DIALOG #4: Common file-save-as dialog }
procedure TCommWin.CMDialogsSaveAs(var Msg: TMessage);
var
  FN: TOpenFilename;
  Tempname: array[0 .. 255] of Char;
begin
  FillChar(FN, Sizeof(FN), #0);
  StrCopy(Tempname, Filename);  { Copy current file name }
  with FN do
  begin
    lStructSize := SizeOf(TOpenFilename);
    hWndOwner := HWindow;
    Flags := ofn_OverwritePrompt;
    lpstrFile := Tempname;  { Address current file name }
    nMaxFile := Sizeof(Filename);
    lpstrFilter := FilterStr;  { Address file filters }
    nFilterIndex := FilterIndex;  { Filter for list box }
  end;
  if GetSaveFileName(FN) then with FN do
  begin
    StrCopy(Filename, lpstrFile);  { Save selected file name }    
FilterIndex := nFilterIndex;  { Save selected filter # }   end;
end;

{- DIALOGS #5-7: Common printer, setup, and options dialogs }
procedure TCommWin.CMDialogsPrint(var Msg: TMessage);
var
  PD: TPrintDlg;
begin
  FillChar(PD, Sizeof(PD), #0);
  with PD do
  begin
    lStructSize := Sizeof(TPrintDlg);
    hWndOwner := HWindow;
    Flags := pd_ReturnDC;  { pd_PrintSetup for setup dlg }
  end;
  if PrintDlg(PD) then
  begin
  {- ... Print using PD.hDC device context. }
    DeleteDC(PD.hDC);
    if PD.hDevMode <> 0 then
      GlobalFree(PD.hDevMode);
    if PD.hDevNames <> 0 then
      GlobalFree(PD.hDevNames);
  end;
end;

{- DIALOG #8: Common find-text dialog }
procedure TCommWin.CMDialogsFind(var Msg: TMessage);
begin
  if HFindDLG <> 0 then
  begin
    SendMessage(HFindDLG, wm_Close, 0, 0);
    HFindDLG := 0;
  end;
  FillChar(FR, Sizeof(FR), #0);
  with FR do
  begin
    lStructSize := Sizeof(TFindReplace);
    hwndOwner := HWindow;
    lpstrFindWhat := FindStr;
    wFindWhatLen := Sizeof(FindStr);
  end;
  HFindDLG := FindText(FR)
end;

{- DIALOG #9: Common replace-text dialog }
procedure TCommWin.CMDialogsReplace(var Msg: TMessage);
begin
  if HFindDLG <> 0 then
  begin
    SendMessage(HFindDLG, wm_Close, 0, 0);
    HFindDLG := 0;
  end;
  FillChar(FR, Sizeof(FR), #0);
  with FR do
  begin
    lStructSize := Sizeof(FR);
    hwndOwner := HWindow;
    lpstrFindWhat := FindStr;
    wFindWhatLen := Sizeof(FindStr);
    lpstrReplaceWith := ReplaceStr;
    wReplaceWithLen := Sizeof(ReplaceStr);
  end;
  HFindDLG := ReplaceText(FR);
end;

{- Display this program's about-box dialog }
procedure TCommWin.CMHelpAbout(var Msg: TMessage);
var
  Dialog: TDialog;
begin
  Dialog.Init(@Self, PChar(id_About));
  Dialog.Execute;
  Dialog.Done;
end;

var
  CommApp: TCommApp;
begin
  CommApp.Init('Common');
  CommApp.Run;
  CommApp.Done
end.


