;
; HANDLER.ASM
;

    .xlist
    ?PLM=1
    ?WIN=1
    include cmacros.inc
    include toolhelp.inc
    .list


;; External data.
externFP <Throw>                ;From Kernel
externFP <TerminateApp>         ;From ToolHelp

externW  <_fTrapGPFault>
externFP <_pCB>

createSeg HANDLER_TEXT, HANDLER_TEXT, BYTE, PUBLIC, CODE
sBegin    HANDLER_TEXT
assumes   CS,HANDLER_TEXT
assumes   DS,_DATA


;
; FaultHandler
;
; Purpose:
;  Interrupt handling function called from ToolHelp when it detects
;  an interrupt.  If the error was caused by our application AND we
;  want to trap it, then we use Throw to return control to the function.
;  If we do not want the fault, then we just pass it to the next interrupt
;  handler.
;

cProc   FaultHandler, <PUBLIC,FAR>
cBegin  nogen

        mov     ds,ax               ;Make sure we can reference our data.

        ;If we do not want to process interrupts, get out ASAP.
        mov     ax,_fTrapGPFault    ;Do we want to process interrupts?
        or      ax,ax
        jnz     FHContinue          ;Yes, continue.

FHExit:
        retf                        ;Pass the interrupt to the next handler.

FHContinue:
        mov     ax,bp               ;Load the interrupt number without
        mov     bp,sp               ;changing the BP register and without
        mov     bx,[bp+06]          ;using the stack with a push an pop.
        mov     bp,ax

        ;Leave if there was a fatal stack fault.
        test    bx,08000h           ;Check high bit
        jnz     FHExit

        ;Check for a GP fault.
        cmp     bx,13
        jne     FHExit

        ;We GP Faulted, return to the faulting function.
        ccall   Throw,<_pCB, 1>

cEnd    nogen
sEnd    HANDLER_TEXT
        END
