{$S-,R-}
Library TStrings;
uses WinTypes, Strings;

type
  PString = ^TString;
  TString =
    record
      sString : PChar;
      sGetString : function(sSelf : PString) : PChar;
      sDone : procedure (sSelf : PString);
    end;

function TStringsGetString(sSelf : PString) : PChar; Export;
begin
  TStringsGetString := sSelf^.sString;
end;

procedure TStringsDone(sSelf : PString); Export;
begin
  with sSelf^ do
    FreeMem(sString, StrLen(sString) + 1);
end;

function TStringInit(AString : PChar; var sSelf : TString) : Bool; Export;
  {-Initialize an instance of a TString.}
begin
  with sSelf do begin
    GetMem(sString, StrLen(AString) + 1); {get memory for our string}
    StrCopy(sString, AString);            {init the sString field}
    sGetString := TStringsGetString;      {set the "virtual methods"}
    sDone := TStringsDone;
    TStringInit := sString <> Nil; {return TRUE if GetMem succeeded}
  end;
end;

Exports
  TStringInit                index 1,
  TStringsGetString          index 2,
  TStringsDone               index 3;

begin
end.
