//===========================================================
// FIND - A text search utility for Windows
// Copyright (C) 1993 Douglas Boling
//===========================================================
// Returns no. of elements
#define dim(x) (sizeof(x) / sizeof(x[0]))   
#define DATABUFFSIZE			32768
#define OUTSIZE 				128
#define SZFULLSIZE			128
#define SZNAMESIZE			13

#define ERR_START				1000
#define ERR_OUTOFLBSPACE	1000
#define ERR_OUTOFMEM    	1001
#define FILLCHAR  			0x2d

//-----------------------------------------------------------
// Include files
//-----------------------------------------------------------
#include "windows.h"
#include "wfext.h"

#include "stdlib.h"
#include "string.h"
#include "direct.h"
#include "dos.h"

#include "find.h"

// File Manager Extension functions
LONG DoFMExtLoad (HWND, UINT, LONG);
LONG DoFMExtInitMenu (HWND, UINT, LONG);

// Prototypes for the File Manager menu extensions
LONG DoFMExtFindText (HWND, UINT, LONG);
LONG DoFMExtFindFile (HWND, UINT, LONG);
LONG DoFMExtAbout (HWND, UINT, LONG);

// Entry Dialog box functions
LONG DoInitDialogEntry (HWND, UINT, UINT, LONG);
LONG DoCommandEntry (HWND, UINT, UINT, LONG);
LONG DoSizeEntry (HWND, UINT, UINT, LONG);

LONG DoEntryCtlFind (HWND, UINT, HWND, UINT);
LONG DoEntryCtlConfig (HWND, UINT, HWND, UINT);
LONG DoEntryCtlExit (HWND, UINT, HWND, UINT);

// Utility function prototpes
BOOL MyYield (void);

INT InitDLL(HANDLE);
UINT FindText (HWND, char *);

//------------------------------------------------------------
// Message dispatch table for FMExtensionProc
//------------------------------------------------------------
struct decodeFMEXT FMExtMessages[] = {
	FMEVENT_LOAD, DoFMExtLoad,
	FMEVENT_INITMENU, DoFMExtInitMenu,
	IDM_FIND, DoFMExtFindText,
	IDM_FFIND, DoFMExtFindFile,
	IDM_ABOUT, DoFMExtAbout,
};
//------------------------------------------------------------
// Message dispatch tables for EntryDlgProc
//------------------------------------------------------------
struct decodeUINT EntryMessages[] = {
	WM_INITDIALOG, DoInitDialogEntry,
	WM_COMMAND, DoCommandEntry,
	WM_SIZE, DoSizeEntry,
};
struct decodeCMD EntryCtlItems[] = {
	IDD_FIND, DoEntryCtlFind,
	IDD_CONFIG, DoEntryCtlConfig,
	IDCANCEL, DoEntryCtlExit
};

//-----------------------------------------------------------
// Global data
//-----------------------------------------------------------
UINT	wFMMenuDelta;
HWND	hwndFMgr;

HANDLE	hInst;
char szAppName[] = "Find";
char szIconName[] = "Find";
char szTitleText[] = "Find Window";
char szProfileName[] = "winfile.ini";
char szProSec[] = "Text Search Information";  
char szMenuName[40];

BOOL	bChkCase, bRecurse;
INT	sIncFlags;
BOOL	bSearching = FALSE;
char	szFileSpec[128];
char	szSrchText[128];
char	szOutText[OUTSIZE];
PBYTE	pbDataBuff;
LONG	lTotalFiles, lTotalHits, lHitFiles;
UINT	usMaxLen, wSrchMenuID;

HANDLE	hDataBuff;
OFSTRUCT	of;
FMS_GETDRIVEINFO	fmsgdi;
FMS_GETFILESEL		fmsgfs;
//============================================================
// DLL External Entry points and support routines
//============================================================
//============================================================
// LibMain -- Entry point called during DLL init
//============================================================
INT CALLBACK LibMain (HANDLE hInstance, WORD wDataSeg, 
                      WORD wHeapSize, LPSTR lpszCmdLine) {
	hInst = hInstance;

	if (InitDLL (hInst))
		return 0;
	else
		return 1;
}
//============================================================
// WEP - DLL termination routine
//============================================================
INT CALLBACK WEP (int nParameter) {
   
	TermInstance(hInst, 0);
	return 1;
}
//============================================================
// FMExtensionProc - Entry point called by File Manager
//============================================================
DWORD CALLBACK FMExtensionProc (HWND hWnd, WORD wMsg, 
                                LONG lParam) {
	INT i;
	//
	// Search message list to see if we need to handle this
	// message.  If in list, call procedure.
	//
	hwndFMgr = hWnd;
	for(i = 0; i < dim(FMExtMessages); i++) {
		if(wMsg == FMExtMessages[i].Code)
			return (*FMExtMessages[i].Fxn)(hWnd, wMsg, lParam);
	}
	return 0;
}
//============================================================
// AboutDlgProc - About dialog box dialog procedure
//============================================================
BOOL CALLBACK AboutDlgProc (HWND hWnd, UINT wMsg, UINT wParam, 
                            LONG lParam) {
                              
	if((wMsg == WM_COMMAND) && ((wParam == IDOK) || 
	                            (wParam == IDCANCEL))) {
		EndDialog(hWnd, 0);
		return TRUE;
	} 
	return FALSE;
}
//============================================================
// EntryDlgProc - Entry dialog box dialog procedure
//============================================================
BOOL CALLBACK EntryDlgProc(HWND hWnd, UINT wMsg, UINT wParam, 
                           LONG lParam) {
	INT i;
	//
	// Search message list to see if we need to handle this
	// message.  If in list, call procedure.
	//
	for(i = 0; i < dim(EntryMessages); i++) {
		if(wMsg == EntryMessages[i].Code)
			return (BOOL) (*EntryMessages[i].Fxn)(hWnd, wMsg, 
			                                wParam, lParam);
	}
	return FALSE;
}
//============================================================
// ConfigDlgProc - About dialog box dialog procedure
//============================================================
BOOL CALLBACK ConfigDlgProc (HWND hWnd, UINT wMsg, UINT wParam, 
                            LONG lParam) {
	switch (wMsg) {
	   case WM_INITDIALOG:
			CheckDlgButton (hWnd, IDD_INCHIDDEN, 
			                sIncFlags & _A_HIDDEN);
			CheckDlgButton (hWnd, IDD_INCRDONLY, 
			                sIncFlags & _A_RDONLY);
			CheckDlgButton (hWnd, IDD_INCSYSTEM, 
			                sIncFlags & _A_SYSTEM);
			CheckDlgButton (hWnd, IDD_INCARC, 
		   	             sIncFlags & _A_ARCH);
			break;
		case WM_COMMAND:
			if (wParam == IDOK) {	
				sIncFlags = 0;
				if (IsDlgButtonChecked (hWnd, IDD_INCHIDDEN) == 1)
					sIncFlags |= _A_HIDDEN;
				if (IsDlgButtonChecked (hWnd, IDD_INCRDONLY) == 1)
					sIncFlags |= _A_RDONLY;
				if (IsDlgButtonChecked (hWnd, IDD_INCSYSTEM) == 1)
					sIncFlags |= _A_SYSTEM;
				if (IsDlgButtonChecked (hWnd, IDD_INCARC) == 1)
					sIncFlags |= _A_ARCH;
				EndDialog(hWnd, 0);
				return TRUE;
			}
			if (wParam == IDCANCEL) {	
				EndDialog(hWnd, 0);
				return TRUE;
			}
	}		
	return FALSE;
}
//-----------------------------------------------------------
// Local routines for app setup and termination
//-----------------------------------------------------------
//-----------------------------------------------------------
// InitDLL - Global initialization code for this application.
//-----------------------------------------------------------
INT InitDLL(HANDLE hInstance) {

	//Get data from last invocation
	bRecurse = GetPrivateProfileInt (szProSec, PRO_CHKDIRS, FALSE,
	                                 szProfileName);
	bChkCase = GetPrivateProfileInt (szProSec, PRO_CASE, FALSE,
	                                 szProfileName);
	sIncFlags = GetPrivateProfileInt (szProSec, PRO_INC, _A_SYSTEM |
	                                  _A_HIDDEN | _A_RDONLY | _A_ARCH,
	                                  szProfileName);
	GetPrivateProfileString (szProSec, PRO_MENUNAME, "Fi&nd", szMenuName,
	                      sizeof (szMenuName), szProfileName);
	szSrchText[0] = '\0';	                                  
	return 0;
}
//------------------------------------------------------------
// TermInstance - Instance termination code for this app.
//------------------------------------------------------------
INT TermInstance(HANDLE hinstance, int sDefRC) {

	MyWritePrivateProfileInt (szProSec, PRO_CHKDIRS, 
	                          bRecurse, 10, szProfileName);
	MyWritePrivateProfileInt (szProSec, PRO_INC, 
	                          sIncFlags, 10, szProfileName);
	MyWritePrivateProfileInt (szProSec, PRO_CASE, 
	                          bChkCase, 10, szProfileName);
	WritePrivateProfileString (szProSec, PRO_MENUNAME, szMenuName,
	                           szProfileName);

	return sDefRC;
}
//============================================================
// Message handling procedures for FMExtensionProc
//============================================================
//------------------------------------------------------------
// DoFMExtLoad - Notification that the extension is being
// loaded by the File Manager. 
//------------------------------------------------------------
LONG DoFMExtLoad (HWND hWnd, UINT wMsg, LONG lParam) {
   HMENU	hMenu;

	//Get Menu delta constant   
   wFMMenuDelta = ((LPFMS_LOAD) lParam)->wMenuDelta;
	//
	// Init the remainder of the FMS_LOAD structure   
	//
   ((LPFMS_LOAD) lParam)->dwSize = sizeof (FMS_LOAD);
   lstrcpy (((LPFMS_LOAD) lParam)->szMenuName, szMenuName);
   hMenu = LoadMenu (hInst, "FindMenu");	
   ((LPFMS_LOAD) lParam)->hMenu = hMenu;
	//
	// NOTE! Returning the menu handle is required even though
	// this is NOT what the documentation on the FMEVENT_LOAD
	// message says.
	//
   return hMenu;
}
//------------------------------------------------------------
// DoFMExtInitMenu - Notification that the user has selected
// the extension menu.
//------------------------------------------------------------
LONG DoFMExtInitMenu (HWND hWnd, UINT wMsg, LONG lParam) {
   INT	i, sCnt;
   BOOL	bFound = FALSE;
   HMENU	hMenu;

	// Get 'File' Menu
	hMenu = GetMenu (hWnd);
	sCnt = GetMenuItemCount (hMenu);
	for (i = 0; i < sCnt; i++) {
	   GetMenuString (hMenu, i, szFileSpec, sizeof (szFileSpec),
	                  MF_BYPOSITION);
	   if (strcmp (szFileSpec, "&File") == 0) {
		   hMenu = GetSubMenu (GetMenu (hWnd), i);
	      bFound = TRUE;
	      break;
	   }
	}
	// Get Search menu
	if (bFound) {
		sCnt = GetMenuItemCount (hMenu);
		for (i = 0; i < sCnt; i++) {
		   GetMenuString (hMenu, i, szFileSpec, sizeof (szFileSpec),
	   	               MF_BYPOSITION);
	   	if (strcmp (szFileSpec, "Searc&h...") == 0) {
				wSrchMenuID = GetMenuItemID (hMenu, i);
		      bFound = TRUE;
		      break;
	   	}
		}
	}	
	hMenu = HIWORD (lParam);
	if (bFound) {
	   EnableMenuItem (hMenu, IDM_FFIND + LOWORD (lParam), 
   	                MF_BYCOMMAND | MF_ENABLED);
	} else   
	   EnableMenuItem (hMenu, IDM_FFIND + LOWORD (lParam), 
	                   MF_BYCOMMAND | MF_GRAYED);
	return 0;
}
//------------------------------------------------------------
// DoFMExtFindText - Routine for handling user selecting
// FIND TEXT addition to the File Manager menu.
//------------------------------------------------------------
LONG DoFMExtFindText (HWND hWnd, UINT wMsg, LONG lParam) {

	MyDisplayDialog(hInst, "EntryBox", hWnd, 
	                (WNDPROC) EntryDlgProc, 0L);
	return 0;
}
//------------------------------------------------------------
// DoFMExtFindFile - Routine for handling user selecting
// FIND FILE addition to the File Manager menu.
//------------------------------------------------------------
LONG DoFMExtFindFile (HWND hWnd, UINT wMsg, LONG lParam) {
   PostMessage (hWnd, WM_COMMAND, wSrchMenuID, 0);
	return 0;
}
//------------------------------------------------------------
// DoFMExtAbout - Routine for handling user selecting
// ABOUT extension addition to the File Manager menu.
//------------------------------------------------------------
LONG DoFMExtAbout (HWND hWnd, UINT wMsg, LONG lParam) {

	MyDisplayDialog(hInst, "AboutBox", hWnd, 
	                (WNDPROC) AboutDlgProc, 0L);
	return 0;
}
//============================================================
// Message handling procedures for EntryDialog
//============================================================
//------------------------------------------------------------
// DoInitDlgEntry - process WM_INITDIALOG message for Entry
// dialog box.
//------------------------------------------------------------ 
LONG DoInitDialogEntry (HWND hWnd, UINT wMsg, UINT wParam, 
                     LONG lParam) {
	UINT	i;
	HICON	hIcon;

	hIcon = LoadIcon (hInst, "FindIcon");
	if (hIcon)
	  	SetClassWord (hWnd, GCW_HICON, hIcon);
	
	SendDlgItemMessage (hWnd, IDD_SRCHTEXT, EM_LIMITTEXT,
	                    sizeof (szSrchText), 0L);
	SendDlgItemMessage (hWnd, IDD_FILESPEC, EM_LIMITTEXT,
	                    sizeof (szFileSpec), 0L);
	i = 40;
	SendDlgItemMessage (hWnd, IDD_OUTLIST, LB_SETTABSTOPS, 1, 
	                    (LPARAM)(LPINT)&i);
	SetDlgItemText (hWnd, IDD_SRCHTEXT, szSrchText);	                    

	i = (UINT) SendMessage (hwndFMgr, FM_GETSELCOUNT, 0, 0);
	if (i) {
	   while (i > 0) {
	      i--;
			SendMessage (hwndFMgr, FM_GETFILESEL, i,
			             (LONG)(LPFMS_GETFILESEL) &fmsgfs);
			SendDlgItemMessage (hWnd, IDD_FILESPEC, CB_ADDSTRING, 
			                    0, (LONG)(LPSTR) fmsgfs.szName);
	   }
	} else {
		SendMessage (hwndFMgr, FM_GETDRIVEINFO, 0, 
		             (LONG)(LPFMS_GETDRIVEINFO) &fmsgdi);
		SendDlgItemMessage (hWnd, IDD_FILESPEC, CB_ADDSTRING, 
		                    0, (LONG)(LPSTR) fmsgdi.szPath);
	}   
	SendDlgItemMessage (hWnd, IDD_FILESPEC, CB_SETCURSEL, 
	                    0, 0);
	GetDlgItemText (hWnd, IDD_FILESPEC, szFileSpec,
	                sizeof (szFileSpec));

	CheckDlgButton (hWnd, IDD_NOCHKCASE, !bChkCase);
	CheckDlgButton (hWnd, IDD_RECURSE, bRecurse);
	return TRUE;
}   
//------------------------------------------------------------
// DoCtlFindEntry - process IDD_FIND control for Entry
// dialog box.
//------------------------------------------------------------ 
LONG DoEntryCtlFind (HWND hWnd, UINT idItem, HWND hwndCtl, 
                     UINT wNotifyCode) {
   UINT	i, rc = 0;
	//
	// If we are running, stop the search and exit
	//
	if (bSearching) {
	   bSearching = FALSE;
	   return TRUE;
	}
	//
	// Get the state of the Recursion and case checkboxes
	//
	if (IsDlgButtonChecked (hWnd, IDD_RECURSE) == 0) 
		bChkCase = FALSE;
	else
		bRecurse = TRUE;
	if (IsDlgButtonChecked (hWnd, IDD_NOCHKCASE) == 0)
		bChkCase = TRUE;
	else
		bChkCase = FALSE;
	//
	// See if user changed the file spec recieved from 
	// FM, if so, throw out the old stuff and only use
	// the user's file spec.
	//
	GetDlgItemText (hWnd, IDD_FILESPEC, szSrchText,
	                sizeof (szSrchText));
	if (SendDlgItemMessage (hWnd, IDD_FILESPEC, CB_FINDSTRING, 
	                    -1, (LONG) (LPSTR) szSrchText) == CB_ERR) {              
		SendDlgItemMessage (hWnd, IDD_FILESPEC, 
		                    CB_RESETCONTENT, 0, 0L);
		SendDlgItemMessage (hWnd, IDD_FILESPEC, CB_ADDSTRING, 
		                    0, (LONG)(LPSTR) szSrchText);
		SendDlgItemMessage (hWnd, IDD_FILESPEC, CB_SETCURSEL, 
		                    0, 0);
	}
	//
	// Reset counters, clear the outbox and set the focus there.
	//	
	lTotalFiles = 0;
	lTotalHits = 0;
	lHitFiles = 0;
	usMaxLen = 0;
	SendDlgItemMessage (hWnd, IDD_OUTLIST, LB_RESETCONTENT, 
	                    0, 0L);
	SetFocus (GetDlgItem (hWnd, IDD_OUTLIST));
	//
	// Get the search string. Test for null string
	//
	GetDlgItemText (hWnd, IDD_SRCHTEXT, szSrchText, 
	                sizeof (szSrchText));
	if (strlen (szSrchText) == 0) {
		SetWindowText (hWnd, "Please enter search text");
		SetFocus (GetDlgItem (hWnd, IDD_SRCHTEXT));
		return TRUE;
	}
	hDataBuff = LocalAlloc (LHND, (UINT) DATABUFFSIZE);
	if (hDataBuff == 0) {
		bSearching = FALSE;
	   return TRUE;
	}
   pbDataBuff = LocalLock (hDataBuff);
	SetDlgItemText (hWnd, IDD_FIND, "&Stop");
	SetWindowText (hWnd, "Searching...");
	bSearching = TRUE;
	//
	// Get the file spec strings from the combo box
	// and search on each one.
	//	                
	i = (UINT) SendDlgItemMessage (hWnd, IDD_FILESPEC, 
	                               CB_GETCOUNT, 0, 0);
	while (i > 0 && rc == 0) {
		i--;
		SendDlgItemMessage (hWnd, IDD_FILESPEC, CB_GETLBTEXT,
		                    i, (LONG)(LPSTR) szFileSpec);
		rc = FindText (hWnd, szFileSpec); 
	}
	bSearching = FALSE;
	SetDlgItemText (hWnd, IDD_FIND, "&Find");
	LocalUnlock (hDataBuff);
	LocalFree (hDataBuff);
	//
	// Display search results
	//
	if (IsIconic (hWnd)) {
	   ShowWindow (hWnd, SW_SHOWNOACTIVATE);
	   MessageBeep (0);
	}   
	ltoa (lTotalFiles, szFileSpec, 10);
	strcat (szFileSpec, " files searched. ");
	switch (rc) {
		case ERR_OUTOFLBSPACE:
			strcat (szFileSpec, 
			         "Search terminated. Out of output space");
			break;

		case ERR_OUTOFMEM:
			strcat (szFileSpec, 
			        "Search terminated. Directory structure too deep");
			break;

		default:
			if (lTotalHits) {
				ltoa (lTotalHits, &szFileSpec[strlen (szFileSpec)], 10);
				strcat (szFileSpec, " matches found in ");
				ltoa (lHitFiles, &szFileSpec[strlen (szFileSpec)], 10);
				strcat (szFileSpec, " files");
			} else 		
				strcat (szFileSpec, "No matches found.");
			break;
	}
	SetWindowText (hWnd, szFileSpec);
	return TRUE;
}
//------------------------------------------------------------
// DoEntryCtlConfig - process IDD_CONFIG control for Entry
// dialog box.
//------------------------------------------------------------ 
LONG DoEntryCtlConfig (HWND hWnd, UINT idItem, HWND hwndCtl, 
                      UINT wNotifyCode) {
	MyDisplayDialog(hInst, "ConfigBox", hWnd, 
	                (WNDPROC) ConfigDlgProc, 0L);
	return 0;
}

//------------------------------------------------------------
// DoEntryCtlExit - process IDCANCEL control for Entry
// dialog box.
//------------------------------------------------------------ 
LONG DoEntryCtlExit (HWND hWnd, UINT idItem, HWND hwndCtl, 
                     UINT wNotifyCode) {
   bSearching = FALSE;
	GetDlgItemText (hWnd, IDD_SRCHTEXT, szSrchText, 
	                sizeof (szSrchText));
	EndDialog(hWnd, 0);
	return TRUE;
}
//------------------------------------------------------------
// DoSizeEntry - process WM_SIZE message for Entry dialog
//------------------------------------------------------------ 
LONG DoSizeEntry (HWND hWnd, UINT wMsg, UINT wParam, LONG lParam) {
   
	if (wParam == SIZE_MINIMIZED)
		ShowWindow (hwndFMgr, SW_HIDE);
	else if (wParam == SIZE_RESTORED)
		ShowWindow (hwndFMgr, SW_SHOWNA);
	return FALSE;
}

//------------------------------------------------------------
// DoCommandEntry - process WM_COMMAND message for Entry dialog
// by decoding the control IDs with the CtlItems[] array, 
// then Searching the corresponding function to process the command.
//------------------------------------------------------------ 
LONG DoCommandEntry (HWND hWnd, UINT wMsg, UINT wParam, LONG lParam) {
	INT	i;
	UINT	idItem, wNotifyCode;
	HWND	hwndCtl;

	idItem = (UINT) wParam;                      // Parse Parameters
	hwndCtl = (HWND) LOWORD(lParam);
	wNotifyCode = (UINT) HIWORD(lParam);
	//
	// Call routine to handle control message
	//
	for(i = 0; i < dim(EntryCtlItems); i++) {
		if(idItem == EntryCtlItems[i].Code)
			return (*EntryCtlItems[i].Fxn)(hWnd, idItem, 
			                             hwndCtl, wNotifyCode);
	}
	return FALSE;
}

//============================================================
// General helper routines
//============================================================
//------------------------------------------------------------
// MyDisplayDialog - Display a dialog box
//------------------------------------------------------------ 
INT MyDisplayDialog (HINSTANCE hInstance, LPCSTR szDlgName,
                     HWND hWnd, WNDPROC lpDialogProc, 
                     LPARAM lParam) {
    WNDPROC lpDlgProcInst;
    INT		rc;

    lpDlgProcInst = MakeProcInstance(lpDialogProc, hInst);
    rc = DialogBoxParam (hInstance, szDlgName, hWnd, 
                         lpDlgProcInst, lParam);
    FreeProcInstance(lpDlgProcInst);
    return rc;                              
}
//------------------------------------------------------------
// MyYield - Yields control to other programs, but returns
// if Windows is idle.
//------------------------------------------------------------
BOOL MyYield (void) {
   MSG	msg;
   BOOL	bCont;
   
   bCont = TRUE;
	while (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE)) {
	   if (msg.message == WM_QUIT)
	      bCont = FALSE;
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return bCont;
}
//------------------------------------------------------------
// MyWritePrivateProfileInt - Writes an integer to the profile
//------------------------------------------------------------
BOOL MyWritePrivateProfileInt (char *szSec, char *szEntry, 
                               int Num, int Base, char *szProfile) {
	static char	szStr[33];
	                           
	itoa (Num, szStr, Base);
	return WritePrivateProfileString (szSec, szEntry, szStr, 
	                                  szProfile);
}
//============================================================  
// Program specific procedures
//============================================================
UINT DisplayLine (HWND hWnd, char *szFilename, LONG lLineCnt, 
                  UINT usMatchLen, char *pszFoundPtr, 
                  char *pszLineStart, BOOL bBinary, UINT usBytesRead) {
   INT	i, j, sLen;
   char	*pszEnd;
   char	ch;

	lTotalHits++;   
	strcpy (szOutText, szFilename);
	if (bBinary) 
		strcat (szOutText, " \tOffset: ?");
	else
		strcat (szOutText, " \tLine: ?");

	ltoa (lLineCnt, strrchr (szOutText, '?'), 10);
	strcat (szOutText, "  \t");
	j = min (sizeof (szOutText) - strlen (szOutText),
	         (UINT) pbDataBuff + usBytesRead - (UINT) pszLineStart);
	if (pszLineStart + j < pszFoundPtr)
	   pszLineStart = pszFoundPtr - j + usMatchLen;

	if (j > 0) {
		if (bBinary)
			for (i = 0; i < j; i++)
			   if (*(pszLineStart+i) < ' ')
	   		   *(pszLineStart+i) = (char) FILLCHAR;
	   		
	   ch = *(pszLineStart + j);
	   *(pszLineStart + j) = 0;
		pszEnd = strchr (pszLineStart, 0x0d);
		if (pszEnd != 0)
			*pszEnd = '\0';
		sLen = strlen (szOutText);
		strncpy (szOutText+sLen, pszLineStart, j);
		szOutText[sLen+j] = '\0';
		if (pszEnd != 0)		                   
			*pszEnd = 0x0d;
	   *(pszLineStart + j) = ch;
	}
	if (SendDlgItemMessage (hWnd, IDD_OUTLIST, LB_ADDSTRING, 0, 
         (LPARAM) (LPSTR)szOutText) == LB_ERRSPACE)
		return ERR_OUTOFLBSPACE;
	else
		return 0;
}
//------------------------------------------------------------
// Searchfile - Searches a file for text.
//------------------------------------------------------------
UINT SearchFile (HWND hWnd, char *szFilename) {
   HANDLE	hSrc;
   UINT		i, rc = 0, usBytesRead, usLen, usOutLen;
   char 		*pszLineStart;
   char		*pszDataPtr;
   LONG		lOffset = 0, lLineCnt = 1;
   BOOL		bFound = FALSE, bBinary = FALSE;
   
	usLen = strlen (szSrchText);
	hSrc = OpenFile (szFilename, &of, OF_READ);
	if (hSrc != -1) {
		strcpy (szOutText, "Searching ");
		strcat (szOutText, szFilename);
		SetWindowText (hWnd, szOutText);
      lTotalFiles++;
	   do {
			usBytesRead = _lread (hSrc, (LPBYTE) pbDataBuff, 
			                      (UINT) DATABUFFSIZE);
			if (usBytesRead < usLen) break;
			pszDataPtr = (char *)pbDataBuff;
	   	pszLineStart = pszDataPtr;
			if (bChkCase) {
				for (i = 0; (i <= usBytesRead - usLen) && (rc == 0); i++) {
				      if (strncmp (pszDataPtr, szSrchText, usLen) == 0) {
				         if (bBinary) {
				            lLineCnt = lOffset + pszDataPtr - pbDataBuff;
				            pszLineStart = max (pszDataPtr-16, pbDataBuff);
				         }   
			   	      rc = DisplayLine (hWnd, szFilename, lLineCnt, 
			   	                        usLen, pszDataPtr, 
		   		                        pszLineStart, bBinary,
		   		                        usBytesRead);
							bFound = TRUE;
						}	
				   if ((*pszDataPtr == 0x0a) || (*pszDataPtr == 0x0d)) {
				   	lLineCnt++;
				   	pszLineStart = pszDataPtr+1;
			   	} else if ((*pszDataPtr != '\t') && ((BYTE)*pszDataPtr < ' ')) 
				      bBinary = TRUE;				      
					pszDataPtr++;
				}	
			} else {
				for (i = 0; (i <= usBytesRead - usLen) && (rc == 0); i++) {
					   if (strnicmp (pszDataPtr, szSrchText, usLen) == 0) {
				         if (bBinary) {
				            lLineCnt = lOffset + pszDataPtr - pbDataBuff;
				            pszLineStart = max (pszDataPtr-16, pbDataBuff);
				         }   
				   		rc = DisplayLine (hWnd, szFilename, lLineCnt, 
				   		                  usLen, pszDataPtr, 
				   		                  pszLineStart, bBinary,
		   		                        usBytesRead);

							bFound = TRUE;
						}	
				   if ((*pszDataPtr == 0x0a) || (*pszDataPtr == 0x0d)) {
				   	pszLineStart = pszDataPtr+1;
				   	if (*pszDataPtr == 0x0d) lLineCnt++;
			   	} else if ((*pszDataPtr != '\t') && ((BYTE)*pszDataPtr < ' ')) 
				      bBinary = TRUE;				      
					pszDataPtr++;
				}	
			}
			_llseek (hSrc, -(LONG)(usLen-1), 1);
			lOffset = lOffset + usBytesRead - usLen - 1;
			usMaxLen = max (usMaxLen, usOutLen);		
		   MyYield ();										//Yield to other apps
		} while (usBytesRead == DATABUFFSIZE && rc == 0 && bSearching);
		_lclose (hSrc);		
	}
	if (bFound)
      lHitFiles++;
   return rc;
}   
//------------------------------------------------------------
// FindText - Searches for text in a list of files.
//------------------------------------------------------------
UINT FindText (HWND hWnd, char *szPath) {
   FIND_T	*pfs;
	INT	rc;
	char	*pszEoP;
	char	*pszName;
	char	*pszFull;
	UINT	usLen;

	if (!bChkCase)
	   strupr (szSrchText);
   strupr (szPath);
	pszName = (char *) LocalAlloc (LPTR, SZNAMESIZE + SZFULLSIZE + 
	                                     sizeof (FIND_T));
	if (pszName == 0) {
		bSearching = FALSE;
	   return ERR_OUTOFMEM;
	}
	pszFull = pszName + SZNAMESIZE;
   pfs = (FIND_T *) ((PBYTE)pszFull + SZFULLSIZE);
	_fullpath (pszFull, szPath, SZFULLSIZE);

	usLen = strlen (pszFull);
	rc = chdir (pszFull);
	if (rc == 0) {
	   if (pszFull[usLen-1] != '\\')
	      strcat (pszFull, "\\");
		strcat (pszFull, "*.*");
	}
   if (*strrchr (pszFull,'\\') != 0)
  		pszEoP = strrchr (pszFull,'\\')+1;
  	else if (*strrchr (pszFull,':') != 0)
  		pszEoP = strrchr (pszFull,':')+1;
  	else
		pszEoP = pszFull;
	*pszName = '\0';
	if (rc ==  HFILE_ERROR)
		strcpy (pszName, pszEoP);
	//
	// File search
	//
	rc = _dos_findfirst (pszFull, sIncFlags, pfs);
	while (rc == 0 && bSearching) {
	   strcpy (pszEoP, pfs->name);
	   usLen = usMaxLen;
	   rc = SearchFile (hWnd, pszFull);
	   if (usLen < usMaxLen) {
			SendDlgItemMessage (hWnd, IDD_OUTLIST, 
			                    LB_SETHORIZONTALEXTENT, 
	   		                 usMaxLen * 10, 0L);
		}
		if (rc == 0)
			rc = _dos_findnext (pfs);
	}
	//
	// Directory search
	//
	if (bRecurse && bSearching) {
		strcpy (pszEoP, "*.*");
		rc = _dos_findfirst (pszFull, sIncFlags | _A_SUBDIR, pfs);
		while (rc == 0 && bSearching) {
			if ((pfs->attrib & _A_SUBDIR) &&
			    (strcmp (pfs->name, ".") != 0) &&
			    (strcmp (pfs->name, "..") != 0)) {
				strcpy (pszEoP, pfs->name);
				if (*pszName != '\0') {
					strcat (pszEoP, "\\");
					strcat (pszEoP, pszName);
				}	
				rc = FindText (hWnd, pszFull);
			}	
			if (rc == 0)
				rc = _dos_findnext (pfs);
		}	
	}
	if (rc < ERR_START) rc = 0;
	LocalFree ((HLOCAL) pszName);
	return rc;
}
