//===========================================================
// FIND.H -- Header File 
// Copyright (c) 1993 Douglas Boling
//===========================================================
//-----------------------------------------------------------
// Generic defines and data types
//-----------------------------------------------------------
#if !defined(WIN32)
  #define WIN16     TRUE
  #define WIN31

  #define INT       int
  #define UINT      WORD
  #define APIENTRY  PASCAL
  #define WNDPROC   FARPROC
#else
  #define WIN16     FALSE
#endif

struct decodeUINT {                         // structure associates
    UINT Code;                              // messages 
    LONG (*Fxn)(HWND, UINT, UINT, LONG);    // with a function
}; 
struct decodeCMD {
    UINT Code;
    LONG (*Fxn)(HWND, UINT, HWND, UINT);
};
//struct decodeDLG {
//   UINT Code;
//    BOOL (*Fxn)(HWND, UINT, UINT, LONG);
//}; 
struct decodeFMEXT {
    UINT Code;
    LONG (*Fxn)(HWND, UINT, LONG);
};

typedef struct find_t FIND_T;
//
// Function prototypes used by generic template
//
INT  APIENTRY WinMain(HANDLE, HANDLE, LPSTR, INT);
INT  InitApp(HANDLE);
INT  InitInstance(HANDLE, LPSTR, INT);
INT  TermInstance(HANDLE, INT);
LONG CALLBACK MainWndProc(HWND, UINT, UINT, LONG);
BOOL CALLBACK AboutDlgProc (HWND, UINT, UINT, LONG);
INT  MyDisplayDialog (HINSTANCE, LPCSTR, HWND, WNDPROC, LPARAM);
BOOL MyWritePrivateProfileInt (char *, char *, int, int, char *);
//
// Profile String Names
//
#define     PRO_CASE     "ChkCase"
#define     PRO_INC      "IncFlags"
#define     PRO_CHKDIRS  "ChkDirs"
#define     PRO_MENUNAME "MenuName"
//
// Resource Idendifiers.  Additions to the File Manager 
// menu items must range from 1 to 99.
//
#define     IDM_FIND       1
#define     IDM_FFIND      2
#define     IDM_ABOUT      3

#define     IDD_SRCHTEXT   201
#define     IDD_FILESPEC   202
#define     IDD_OUTLIST    203
#define     IDD_NOCHKCASE  204
#define     IDD_RECURSE    205
#define     IDD_FIND       206
#define     IDD_CONFIG     207

#define     IDD_INCRDONLY  301
#define     IDD_INCARC     302
#define     IDD_INCHIDDEN  303
#define     IDD_INCSYSTEM  304
