
#include "windows.h"
#include "toolhelp.h"
#include <time.h>
#include <string.h>

#define  VERSION    "1.31"
#define  IDMEM	    1
#define  IDFSR	    2
#define  IDVERSTR   113

#define  USER_HEAP  1
#define  GDI_HEAP   2

#define  IDM_ABOUT  0x10
#define  IDM_ONTOP  0x11
#define  IDM_SAVLOC 0x12


//---------------------------------------------------------------------------
// Global Variables...
//---------------------------------------------------------------------------

HANDLE  hInstance;              // Global instance handle for application
int     hwndKill, idKill;
int     Millisec = 1000;         // Current timer speed in milliseconds
HWND    hwndMain;               // Main hwnd.  Needed in callback
int     counter = 0;            // Counter to display when timer goes off
char    szDT[32];               // storage to build strings
char    szMem[32];              // storage to build strings
char    szRes[32];              // storage to build strings
char    szAppName[]  = "Fres";      // Name of App
char    szOnTopKey[] = "StayOnTop"; // Profile key
char    szVerStr[12];

BOOL    fOnTop = FALSE;
HMENU   hSysMenu;
RECT    rPos;
FARPROC lpfnAbtDlg;
FARPROC lpfnDlgProc;

//---------------------------------------------------------------------------
// Function declarations
//---------------------------------------------------------------------------

BOOL FAR PASCAL DlgProc(HWND hwnd, WORD msg, WORD wParam, LONG lParam);
BOOL FAR PASCAL AbtDlg(HWND hwnd, WORD msg, WORD wParam, LONG lParam);
BOOL FormatDT(char *szStr);
BOOL FormatMem(char *szStr);
BOOL FormatSR(char *szStr);

//---------------------------------------------------------------------------
// WinMain
//---------------------------------------------------------------------------

int PASCAL WinMain(HANDLE hInst, HANDLE hInstPrev,
						 LPSTR lpstrCmdLine, int cmdShow) {
	MSG msgMain;
	char     tmp[6];

	// Set the global instance variable
	hInstance = hInst;

	wsprintf((LPSTR)szVerStr, "%s v%s", (LPSTR)szAppName, (LPSTR)VERSION);
	lpfnDlgProc = MakeProcInstance(DlgProc, hInst);

	if ((hwndMain = CreateDialog(hInst, szAppName, 0, lpfnDlgProc)) == NULL)
		return(0);

	// Add About Item to Sytem menu
	hSysMenu = GetSystemMenu(hwndMain, FALSE);
	AppendMenu(hSysMenu, MF_SEPARATOR, 0, NULL);
	AppendMenu(hSysMenu, MF_STRING, IDM_ABOUT, 	"&About...");
	AppendMenu(hSysMenu, MF_STRING, IDM_ONTOP,   "&Stay on Top");
	AppendMenu(hSysMenu, MF_STRING, IDM_SAVLOC,  "&Save Location");

	GetProfileString(szAppName, szOnTopKey, "off", tmp, sizeof(tmp));
	if (stricmp(tmp, "on")   == 0 ||
	    stricmp(tmp, "yes")  == 0 ||
	    stricmp(tmp, "true") == 0 ||
	    stricmp(tmp, "1")	 == 0) {
		fOnTop = TRUE;
		CheckMenuItem(hSysMenu, IDM_ONTOP, MF_CHECKED);
		}

	// Main message "pump"
	while (GetMessage((LPMSG) &msgMain, NULL, 0, 0)) {
		if (!IsDialogMessage(hwndMain, (LPMSG)&msgMain)) {
			TranslateMessage((LPMSG) &msgMain);
			DispatchMessage((LPMSG) &msgMain);
			}
		}

	FreeProcInstance(lpfnDlgProc);
	return(0);
	}


//===========================================================================
// AbtDlg
//
// Dialog Callback
//
//===========================================================================

BOOL FAR PASCAL AbtDlg(HWND hwnd, WORD msg, WORD wParam, LONG lParam) {

	switch(msg) {
		case WM_INITDIALOG:
			SetDlgItemText(hwnd, IDVERSTR, szVerStr);
			return(TRUE);

		case WM_CLOSE:
			EndDialog(hwnd, 0);
			return(TRUE);

		case WM_COMMAND:
			switch(wParam) {
				case IDOK:
					EndDialog(hwnd, 0);
					return(TRUE);
				}
			break;
		}
	return(FALSE);
	}

//===========================================================================
// WndProc
//
// Window procedure for the sample applications window.
//
//===========================================================================
BOOL FAR PASCAL DlgProc(HWND hwnd, WORD msg, WORD wParam, LONG lParam) {
	int xpos, ypos, nWidth, nHeight;
	WORD wCheck;
	char tmp[6];

	switch(msg) {
		case WM_INITDIALOG:
			GetWindowRect(hwnd, (LPRECT)&rPos);
			nWidth = rPos.right - rPos.left;
			nHeight = rPos.bottom - rPos.top;
			xpos = GetProfileInt(szAppName, "X", rPos.left);
			ypos = GetProfileInt(szAppName, "Y", rPos.top);
			MoveWindow(hwnd, xpos, ypos, nWidth, nHeight, TRUE);

			lpfnAbtDlg  = MakeProcInstance(AbtDlg, hInstance);
			if (SetTimer(hwnd, 1, Millisec, NULL) == NULL) {
				MessageBox(hwnd, "Couldn't create timer.", "Notice!", MB_OK);
				DestroyWindow(hwnd);
				PostQuitMessage(0);
				return(TRUE);
				}
			hwndKill = hwnd;
			idKill = 1;

		case WM_TIMER:
			if (fOnTop & GetWindow(hwnd, GW_HWNDPREV) != hwnd)
				SetWindowPos(hwnd, NULL, 0, 0, 0, 0,
					  SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOSIZE);
			if (FormatDT(szDT)) {
				SetWindowText(hwnd, szDT); // Time has changed
				PostMessage(hwnd, WM_NCPAINT, 0, 0L); // redo border
				}
			if (FormatMem(szMem) || FormatSR(szRes)) {
				SetDlgItemText(hwnd, IDMEM, szMem);
				SetDlgItemText(hwnd, IDFSR, szRes);
				}
			return(TRUE);

		case WM_CLOSE:
			KillTimer(hwndKill, idKill);
			idKill = 0;

			FreeProcInstance(lpfnAbtDlg);
			DestroyWindow(hwnd);
			PostQuitMessage(0);
			return(TRUE);

		case WM_SYSCOMMAND:
			switch(wParam) {
				case IDM_ABOUT:
					DialogBox(hInstance, "About", hwnd, lpfnAbtDlg);
					return(TRUE);

				case IDM_ONTOP:
					if (fOnTop) {
						fOnTop = FALSE;
						wCheck = MF_UNCHECKED;
						strcpy(tmp, "off");
						}
					else {
						fOnTop = TRUE;
						wCheck = MF_CHECKED;
						strcpy(tmp, "on");
						}
					CheckMenuItem(hSysMenu, IDM_ONTOP, wCheck);
					WriteProfileString(szAppName, szOnTopKey, tmp);
					return(TRUE);

				case IDM_SAVLOC:
					GetWindowRect(hwndMain, (LPRECT)&rPos);
					wsprintf((LPSTR)tmp, "%d", rPos.left);
					WriteProfileString(szAppName, "X", tmp);
					wsprintf((LPSTR)tmp, "%d", rPos.top);
					WriteProfileString(szAppName, "Y", tmp);
					return(TRUE);

				}
			break;

		}
	return(FALSE);
	}

//---------------------------------------------------------------------------
// FormatDT
//
// Formats The Date and time - Returns TRUE if it has changed.
//---------------------------------------------------------------------------

BOOL FormatDT(char *szStr) {
	static short savehr = -1;
	static short savemin = -1;
	struct tm *tym;
	time_t timer = 0;
	short  hour;
	short  mini;
	char   suffix[5];

	timer = time(&timer);
	tym = localtime(&timer);

	hour = tym->tm_hour;
	mini = tym->tm_min;

	if (hour == savehr && mini == savemin) // hasn't changed enough
	  return FALSE;

	savehr  = hour;
	savemin = mini;

	if (hour > 12) {
		hour = hour - 12;
		strcpy(suffix, "pm");
		}
	else if (hour == 12) {
		if (mini == 0)
			strcpy(suffix, "noon");
		else
			strcpy(suffix, "pm");
		}
	else {
		strcpy(suffix, "am");
		if (hour == 0) {
			hour = 12;
			if (mini == 0)
				strcpy(suffix, "nite");
			}
		}
	wsprintf((LPSTR)szStr, "%2.2d-%2.2d-%2.2d %2d:%2.2d %s",
			  tym->tm_mon+1, tym->tm_mday, tym->tm_year,
			  hour, mini, (LPSTR)suffix);
	return TRUE;
	}

//---------------------------------------------------------------------------
// FormatMem
//
// Formats the free memory string - Returns TRUE if it's changed.
//---------------------------------------------------------------------------

BOOL FormatMem(char *szStr) {
	static WORD savemem = 0;
	WORD mem;

	mem = (WORD)(GetFreeSpace(0) >> 10); // get #of KBytes

	wsprintf((LPSTR)szStr, "%s: %5u K",
             (LPSTR)((GetWinFlags() & WF_ENHANCED) ? "Enh" : "Std"), mem);
	if (mem == savemem)
		return FALSE;

	savemem = mem;
	return TRUE;
	}

//---------------------------------------------------------------------------
// FormatSR
//
// Formats the free system resources string - Returns TRUE if it's changed.
//---------------------------------------------------------------------------

BOOL FormatSR(char *szStr) {
	static char szSav[24] = "\0";
	SYSHEAPINFO hpInfo;
	short nres;
	short nmod;

	hpInfo.dwSize = sizeof(SYSHEAPINFO);
	SystemHeapInfo(&hpInfo);

	if (hpInfo.wUserFreePercent > hpInfo.wGDIFreePercent) {
		nres = hpInfo.wGDIFreePercent;
		nmod = GDI_HEAP;
		}
	else {
		nres = hpInfo.wUserFreePercent;
		nmod = USER_HEAP;
		}

	wsprintf((LPSTR)szStr, "%s: %2.2d%%",
		   (LPSTR)((nmod == GDI_HEAP) ? "GDI" : "User"), nres);
	if (strcmp(szStr, szSav) == 0)
		return FALSE;

	strcpy(szSav, szStr);  // save for next time
	return TRUE;
	}
