/************************************************************************
* This file holds all the defines for sysgraph.c
*
* Define ID equivelents:
*	IDS  = String table ID
*	IDMD = Menu dialog ID
*	IDSD = Setup dialog ID
*	IDAD = About dialog ID
*	RGB  = Color value
*/

// Max tell-tails
#define	NAME_SIZE	20		// Max program name length
#define MAX_POINTS 	40		// Max points to use in graph
#define LAST_POINT      MAX_POINTS - 1	// Last point in graph
#define MAX_POINTS_ALL	MAX_POINTS + 2	// All points plus end points

// String table
#define	IDS_NAME		100	// Location of program name

// Setup dialog
#define IDSD_1SEC		10	// Sets time to 1 sec
#define IDSD_2SEC		11	// Sets time to 2 sec
#define IDSD_5SEC		14      // Sets time to 5 sec
#define IDSD_AUTO_RESCALE	20	// Auto Rescale check box
#define IDSD_ON_TOP		30	// Keep on top check box
#define IDSD_QUEUE		40	// Queue graph type button
#define IDSD_INV_QUEUE		50	// Inverse queue graph type button
#define IDSD_SAVE_SETUP		60	// Save setup button
#define IDSD_ON_CAPTION		70	// Follow top window

// Program dialog menu
#define IDMD_MINIMIZE		500	// Minimizes program
#define IDMD_CLOSE		510	// Closes program
#define IDMD_RESCALE		520	// Rescale graph button
#define IDMD_SETUP		530	// Quit session button
#define IDMD_ABOUT		540	// About Box button

// About dialog
#define IDAD_VERSION		10	// Version list text
#define IDAD_AUTHOR             20	// Author list text
#define IDAD_WARE		30	// What is ware concept
#define IDAD_VERSION_STR	"Version 4.00"
#define IDAD_AUTHOR_STR		"By James S. Straub"

// Win.ini keywords for setup
#define INI_NAME		"System Graph"	// These are the keyname
#define VERSION_KEY		"Version"	//  fields in the win.ini
#define GRAPH_TYPE_KEY		"GraphType"	//  file.
#define UPDATE_TIME_KEY		"UpdateTime"
#define AUTO_RESCALE_KEY	"AutoRescale"
#define ON_TOP_KEY		"OnTop"
#define ON_CAPTION_KEY		"OnCaption"
#define ICONIC_KEY		"Iconic"
#define WIN_LEFT_KEY		"WinLeft"
#define WIN_TOP_KEY		"WinTop"
#define WIN_RIGHT_KEY		"WinRight"
#define WIN_BOTTOM_KEY		"WinBottom"

// Default settings
#define DEF_WIN_LEFT		50		// Starting X pos window
#define DEF_WIN_TOP		50		// Starting Y pos window
#define DEF_WIN_RIGHT		150		// Width of program window
#define DEF_WIN_BOTTOM		150		// Hight of program window
#define DEF_UPDATE_TIME		IDSD_1SEC	// The default update time
#define DEF_GRAPH_TYPE		IDSD_QUEUE	// Type of graph
#define DEF_AUTO_RESCALE	FALSE		// Auto rescale setting
#define DEF_ON_TOP		FALSE		// Keep on top
#define DEF_ON_CAPTION		FALSE		// Keep on caption
#define DEF_ICONIC		TRUE		// Start up state of window

// Misc defines
#define THE_SKY_IS_BLUE		1		// For endless loops
#define VERSION_NUMBER		4.00		// The version of this
#define DEF_FRAME_WIDTH		2       	// Width of frame in pixels
#define STANDARD_STYLE		(WS_POPUP | WS_THICKFRAME | WS_BORDER)

// Color values
#define RGB_YELLOW		0x0000FFFF	// These are RGB color values
#define RGB_BLACK		0x00000000
#define RGB_BLUE		0x00808000
#define	RGB_WHITE		0x00FFFFFF
#define	RGB_GRAY		0x00808080
#define	RGB_LIGHT_GRAY		0x00C0C0C0


/************************************************************************
* Function prototypes
*/
long FAR PASCAL MainProc(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL SetupDialog(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL AboutDialog(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL WareDialog(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL MenuDialog(HWND, unsigned, WORD, LONG);
BOOL            SetProgramTimer(int);


