#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <direct.h>
#include <dos.h>
#include <time.h>
#include <ctype.h>
#include "wstdio.h"
#include "wslib.h"
#include "copy.h"

#define CF_BUFFSIZE     1000000
#define CF_MAX_READ     65535
static char szMemError[] = "Error allocating memory for copy\n";
static char szNoSpace[] =
"Insufficent disk space copying \"%s\".  Do you want to retry?\n\nNOTE: \
If copying to a floppy, you can insert a new one and press \"Retry\" to \
continue copying to another disk.";

HANDLE hMod;

/***************************************************************************/
/* FUNCTION: LibMain - Entry function for DLL as defined by libentry.asm   */
/* USES    : parameters ignored                                            */
/* DESCRIPTION: this function is called by Windows to initailize the DLL   */
/*-------------------------------------------------------------------------*/
int FAR PASCAL LibMain (hModule, wDataSeg, cbHeapSize, lpszCmdLine)
   HANDLE   hModule ;
   WORD     wDataSeg ;
   WORD     cbHeapSize ;
   LPSTR    lpszCmdLine ;
{
   if (cbHeapSize != 0)
	   UnlockData (0);
   hMod = hModule;
   return 1;
}

/***************************************************************************/
/* FUNCTION: WEP                                                           */
/* USES    : parameters ignored                                            */
/* NOTES   : Function called by windows to destroy DLL                     */
/*-------------------------------------------------------------------------*/
void FAR PASCAL WEP (bSystemExit)
int      bSystemExit ;
{
     return ;
}

#define LINELEN 130
int CreateSourceNameAndDoCopy (HWND hwndDisplay, HANDLE hCopyBuff, LPSTR szSrcCmdLine, LPSTR dest, LPSTR destcatptr);

int FAR PASCAL ModuleProc (HWND hwndDisplay, int argc, LPSTR argv[])
{
   HANDLE hCopyBuff;          // buffer for copy

   char szDestFName[LINELEN]; // destination filename string 
   LPSTR 
        dest,              // points to dest file name 
        destcatptr;        // points end of dest path, where the source 
                           // filename is copied 
                           // if == 0, no dest filename subs done 
   LPSTR lastparam;        // pointer to last parameter

   dest = szDestFName;     // points to dest file name 
   destcatptr = 0;

   if (argc < 2)
   {
      dputs (hwndDisplay, "usage: copy <sourcefile> <destfile>\n");
      return TRUE;
   }

   lastparam = argv[argc-1];

   if (argc == 2)
   {
      // if only one parameter, use current directory for dest 
      destcatptr = szDestFName; 
   }
   /* is destination paramter a directory? if so, dest name substituions */
   else if (IsDirectory (lastparam))
   {
      LPSTR lpstrBkSlsh;
      lstrcpy (dest, lastparam);
      lpstrBkSlsh = dest + lstrlen (dest) - 1;
      if (*lpstrBkSlsh != '\\' && *lpstrBkSlsh != ':')
         *(++lpstrBkSlsh) = '\\';
      destcatptr = lpstrBkSlsh + 1;
   }

   // is it a drive letter only??
/* 5/25/92 NEEDED ????
   else if (isalpha (*lastparam) && *(lastparam+1) == ':' && *(lastparam+2) == NULL)
   {
      destcatptr = lastparam + 2;
   }
*/

   /* destination is a single file name */
   else
   {
      lstrcpy (dest, lastparam);
   }

   // allocate and lock memory for copy
   if (   (hCopyBuff = GlobalAlloc (GMEM_MOVEABLE, CF_BUFFSIZE)) != NULL
       || (hCopyBuff = GlobalAlloc (GMEM_MOVEABLE, CF_BUFFSIZE / 2)) != NULL
       || (hCopyBuff = GlobalAlloc (GMEM_MOVEABLE, CF_BUFFSIZE / 4)) != NULL)
   {
      if (GlobalLock (hCopyBuff) != NULL)
      {
         // Can you spot the command that does the copy in this section?
         argc-=2;  argv++;
         while (argc-- > 0 && CreateSourceNameAndDoCopy (hwndDisplay, hCopyBuff, *argv++, dest, destcatptr))
            ;
         GlobalUnlock (hCopyBuff);
      } // if (GlobalLock)
      else
      {
         dputs (hwndDisplay, szMemError);
      }
      GlobalFree (hCopyBuff);
   } // if (GlobalAlloc)
   else
   {
      dputs (hwndDisplay, szMemError);
   }

   return TRUE;
}

int CreateSourceNameAndDoCopy (HWND hwndDisplay, HANDLE hCopyBuff, LPSTR szSrcCmdLine, LPSTR dest, LPSTR destcatptr)
{
   BOOL bVerbose   = TRUE;    // command line flags

   char szSrcFName[LINELEN];  // destination filename string 
   static char cMsg[200];     // used to print out errors 

   struct find_t fi;          // holds file info 

   LPSTR
        src,               // points to source file name 
        srccatptr;         // points end of src path, where the source 
                           // filename is copied, also serves as flag 
                           // if == 0, no source filename subs done 

   src  = szSrcFName;      // points to source file name
   srccatptr  = 0; 

   lstrcpy (src, szSrcCmdLine);  // copy string to local area

   /* is parameter 1 a directory, if so, append "\*.*" if needed and perform
      source name subs */
   if (IsDirectory (src))
   {
      if (*(src + lstrlen (src) - 1) != '\\')
         lstrcat (src, "\\*.*");
      else
         lstrcat (src, "*.*");
      srccatptr = src + lstrlen (src) - 3; /* to point before appended "*.*" */
   }

   // is it a drive letter only??
/* 5/25/92 NEEDED???
   else if (isalpha (*src) && *(src+1) == ':' && *(src+2) == NULL)
   {
      lstrcpy (src + 2, "*.*");
      srccatptr = src + 2;
   }
   */

   /* is paramter 1 a wildcard (* or ?) - do name source substitution */
   else if ((srccatptr = lstrchr (src, '\*')) || (srccatptr = lstrchr (src, '\?')))
   {
      /* srccatptr points to * or ?, but need to get it to point to end */
      /* of the path if one specified, or begging of string. Done by waliking */
      /* back through string */
      while (srccatptr > src)    /* what a pain ! */
         if (*srccatptr-- == '\\')
         {
            srccatptr += 2;      /* srccatptr points to char before '\\' */
            break;               /* make it point to one AFTER */
         }
   }
   /* now srccatptr is NULL or points to proper place in string */

   /* ok, the shit work aside, the copy loop is nice */
   if (_dos_findfirst (src, _A_NORMAL, &fi) == 0)
   {
      do
      {
         if (destcatptr) 
            lstrcpy (destcatptr, fi.name);
         if (srccatptr != 0)      
            lstrcpy (srccatptr, fi.name);

tryagain_butihategoto:
         switch (CopyFile (hwndDisplay, hCopyBuff, dest, src))
         {
            case -1:
            case 0:
               if (bVerbose)
               {
                  wsprintf ((LPSTR) cMsg, "%s \t=> %s\n", (LPSTR) src, (LPSTR) dest);
                  dputs (hwndDisplay, cMsg);
               }
            break;
      
            case 1:
               wsprintf ((LPSTR) cMsg, "Couldn't open source file \"%s\"\n", (LPSTR) src);
               dputs (hwndDisplay, cMsg);
            break;

            case 10:
               MessageBeep (48);       // sound for exclamation
               wsprintf ((LPSTR) cMsg, (LPSTR) szNoSpace, (LPSTR) src);
               if (IDRETRY == MessageBox(hwndDisplay, cMsg, "Error Copying File", MB_RETRYCANCEL | MB_ICONEXCLAMATION | MB_DEFBUTTON2))
                  goto tryagain_butihategoto;
               else
               {
                  wsprintf ((LPSTR) cMsg, "Insufficent disk space copying \"%s\".\n", (LPSTR) src);
                  dputs (hwndDisplay, cMsg);
                  return FALSE;
               }
            break;
            
            default:
               wsprintf ((LPSTR) cMsg, "Couldn't copy \"%s\" to \"%s\"\n", (LPSTR) src, (LPSTR) dest);
               dputs (hwndDisplay, cMsg);
            break;
         }
         YieldToOthers ();
      } while (_dos_findnext (&fi) == 0);
   } // if (findfirst)
   else
   {
      wsprintf ((LPSTR) cMsg, "File not found: \"%s\"\n", (LPSTR) src);
      dputs (hwndDisplay, cMsg);
   }
}

int CopyFile (HWND hwndDisplay, HANDLE hCopyBuff, LPSTR Dest, LPSTR Src)
{
   char huge * lpCopyBuff;
   char cMsg[LINELEN];  /* used to print out errors */
   BOOL bWriteError = FALSE; 

   int hDest, hSrc,
       count;

   int iChar;

   if ( (hSrc = _lopen (Src, OF_READ | OF_SHARE_DENY_WRITE)) == -1)
      return 1;

/*
   if (bOverWrite == FALSE)
   {
      if ((hDest = _lopen (Dest, OF_READ)) != -1) 
      {
         _lclose (hDest);
         wsprintf (cMsg, "overwrite existing \"%s\"?\n", (LPSTR) Dest);
         dputs (hwndDisplay, cMsg);
         if (dgets (hwndDisplay, cMsg, sizeof (cMsg)) == -1)
         {
            _lclose (hSrc);
            return -1;
         }
         else if (cMsg[0] != 'y')
         {
            _lclose (hSrc);
            return 2;
         }
      }
   }
*/

   if ((hDest = _lcreat (Dest, 0)) == -1) 
   {
      _lclose (hSrc);
      return 3;
   }

   lpCopyBuff = (char huge *) GlobalLock (hCopyBuff);

   while (TRUE)
   {
      DWORD SpaceUsed;
      WORD  BytesRead, BytesToWrite;
      char huge *bOut;

      //----------------------- read into buffer
      SpaceUsed = 0;
      while ( GlobalSize (hCopyBuff) - SpaceUsed > CF_MAX_READ )
      {
         YieldToOthers ();
         BytesRead = _lread (hSrc, lpCopyBuff + SpaceUsed, CF_MAX_READ);
         if (BytesRead == 0)
            break;
         SpaceUsed += BytesRead;
      }

      //---------------------- write to output file
      bOut = lpCopyBuff;
      BytesToWrite = CF_MAX_READ;

      while ( SpaceUsed > 0 )
      {
         YieldToOthers ();
         if (SpaceUsed < CF_MAX_READ)
            BytesToWrite = (WORD) SpaceUsed;

         if (_lwrite (hDest, bOut, BytesToWrite) != BytesToWrite)
         {
            bWriteError = TRUE;
            break;
         }

         bOut      += (DWORD) BytesToWrite;
         SpaceUsed -= (DWORD) BytesToWrite;
      }

      if (BytesRead == 0 || bWriteError)
         break;
   }
   GlobalUnlock (hCopyBuff);

   _lclose (hDest);
   _lclose (hSrc);

   if (bWriteError)
   {
      static OFSTRUCT ofsShit;
      OpenFile (Dest, &ofsShit, OF_DELETE);
      return 10;
   }

   return 0;
}

int FAR PASCAL ShowOptions (HWND hwndParent)
{
   FARPROC lpfn;
   lpfn = MakeProcInstance (OptionsDlg, hMod);
   DialogBox (hMod, "OPTIONS", hwndParent, lpfn);
   FreeProcInstance (lpfn);
   return 0;
}

int FAR PASCAL ShowAbout (HWND hwndParent)
{
   FARPROC lpfn;
   lpfn = MakeProcInstance (AboutDlg, hMod);
   DialogBox (hMod, "ABOUT", hwndParent, lpfn);
   FreeProcInstance (lpfn);
   return 0;
}

int FAR PASCAL OptionsDlg (HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
   switch (wMsg)
   {
   	case WM_CLOSE:
	      EndDialog(hDlg, NULL);
	      return(TRUE);
      break;

      case WM_COMMAND:
         if (wParam == IDOK)
   	      EndDialog(hDlg, NULL);
	      return(TRUE);
      break;
   }
   return FALSE;
}

int FAR PASCAL AboutDlg (HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
   switch (wMsg)
   {
   	case WM_CLOSE:
	      EndDialog(hDlg, NULL);
	      return(TRUE);
      break;

      case WM_COMMAND:
         if (wParam == IDOK)
   	      EndDialog(hDlg, NULL);
	      return(TRUE);
      break;
   }
   return FALSE;
}



