#include <windows.h>
#include "wstdio.h"
#include "generic.h"

HANDLE hMod;

/***************************************************************************/
/* FUNCTION: LibMain - Entry function for DLL as defined by libentry.asm   */
/* USES    : parameters ignored                                            */
/* DESCRIPTION: this function is called by Windows to initailize the DLL   */
/*-------------------------------------------------------------------------*/
int FAR PASCAL LibMain (hModule, wDataSeg, cbHeapSize, lpszCmdLine)
   HANDLE   hModule ;
   WORD     wDataSeg ;
   WORD     cbHeapSize ;
   LPSTR    lpszCmdLine ;
{
   if (cbHeapSize != 0)
	   UnlockData (0);
   hMod = hModule;
   return 1;
}

/***************************************************************************/
/* FUNCTION: WEP                                                           */
/* USES    : parameters ignored                                            */
/* NOTES   : Function called by windows to destroy DLL                     */
/*-------------------------------------------------------------------------*/
void FAR PASCAL WEP (bSystemExit)
int      bSystemExit ;
{
     return ;
}


int FAR PASCAL ModuleProc (LPDISPLAY D, int argc, LPSTR argv[])
{
   // your code for the "main()" function goes here
}

int FAR PASCAL ShowOptions ()
{
   FARPROC lpfn;
   lpfn = MakeProcInstance (OptionsDlg, hMod);
   DialogBox (hMod, "OPTIONS", NULL, lpfn);
   FreeProcInstance (lpfn);
   return 0;
}

int FAR PASCAL ShowAbout ()
{
   FARPROC lpfn;
   lpfn = MakeProcInstance (AboutDlg, hMod);
   DialogBox (hMod, "ABOUT", NULL, lpfn);
   FreeProcInstance (lpfn);
   return 0;
}

int FAR PASCAL OptionsDlg (HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
   HDC hDC, hMemDC;
   HBITMAP  hOldBitmap;
   switch (wMsg)
   {
	case WM_CLOSE:
	      EndDialog(hDlg, NULL);
	      return(TRUE);
      break;

      case WM_COMMAND:
	 if (wParam == IDOK)
	      EndDialog(hDlg, NULL);
	      return(TRUE);
      break;
   }
   return FALSE;
}

int FAR PASCAL AboutDlg (HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
   HDC hDC, hMemDC;
   HBITMAP  hOldBitmap;
   switch (wMsg)
   {
	case WM_CLOSE:
	      EndDialog(hDlg, NULL);
	      return(TRUE);
      break;

      case WM_COMMAND:
	 if (wParam == IDOK)
	      EndDialog(hDlg, NULL);
	      return(TRUE);
      break;
   }
   return FALSE;
}


