#ifndef WSTDIO_H
#define WSTDIO_H

//-------------------------------- DISPLAY MESSAGES ---------------------
#define DM_PUTS               (WM_USER + 0)
// lParam  : LPSTR

#define DM_GETS               (WM_USER + 1)
// wParam  : MAXCHARS 
// lParam  : LPSTR
// returns : -1 if application should be terminated

#define DM_CLEAR              (WM_USER + 2)

#define DM_SETFONT            (WM_USER + 3)
// wParam  : FONTTYPE

#define DM_GETNUMCOLUMNS      (WM_USER + 5)
// returns : approximate number of columns on the display. A column is space 
//           enough for about 12 characters and a tab, not single char's

#define DM_GETMARKEDTEXT      (WM_USER + 6)
// returns : Global handle to memory block containg marked text.  This
//           memory must be freed by the user

#define DM_SETMORE            (WM_USER + 7)
// wParam  : TRUE = ON, FALSE = OFF

#define DM_APPENDTOCOMMANDLINE (WM_USER + 8)
// lParam - LPSTR string to append

#define DM_COPYTEXTTOCLIPBOARD   (WM_USER + 9)
// no parameters

#define DM_PASTETEXTFROMCLIPBOARD (WM_USER + 10)
// no parameters

#define dputs(hwnd,szStr)      (SendMessage (hwnd, DM_PUTS, 0, (LONG) (LPSTR) szStr))
#define dgets(hwnd,szStr,nLen) (SendMessage (hwnd, DM_GETS, (WORD) nLen, (LONG) (LPSTR) szStr))
#define dClear(hwnd)           (SendMessage (hwnd, DM_CLEAR, 0, 0L))
#define dSetFont(hwnd,wFont)   (SendMessage (hwnd, DM_SETFONT, wFont, 0L))
#define dGetNumColumns(hwnd)   ((int)SendMessage (hwnd, DM_GETNUMCOLUMNS, 0, 0L))
#define dGetMarkedText(hwnd)   (SendMessage (hwnd, DM_GETMARKEDTEXT, 0, 0L))
#define dSetMore(hwnd,state)   (SendMessage (hwnd, DM_SETFONT, state, 0L))
#define dCopyTextToClipboard(hwnd) (SendMessage (hwnd, DM_COPYTEXTTOCLIPBOARD, 0, 0L))
#define dPasteTextFromClipboard(hwnd) (SendMessage (hwnd, DM_PASTETEXTFROMCLIPBOARD, 0, 0L))

//---------------------------- EXPORTED FUNCTIONS -------------------------
HWND CreateDisplay (HWND hwndParent, int id, HANDLE hInstance, HANDLE hacc);

#endif

