{CO - A Win 3.1 Menu }
{Rel 3.9} {tabs = 2}
program CO;
{$S-}{$R co.RES}{$R-}{$X+}{$V-}
{$D CO Copyright (C) Doug Overmyer 12/17/91}
uses WinTypes,WinProcs,Strings,WObjects,WinDos,filecopy,WFPlus,Buttons,
	SclpText,WIN31,ShellAPI,Bitmap,CommDlg;
const
	id_BMP       = 99;
  id_RGB       = 100;
	id_ButOffset = 120;
 	id_But0    = 200;     {Base value of Icon buttons   }
  id_But1    = 201;     {User defined button 1 iconbar}
  id_But2    = 202;     {      "             2 iconbar}
  id_But3    = 203;     {      "             3 iconbar}
  id_But4    = 204;     {      "             3 iconbar}
  id_But5    = 205;     {      "             5 iconbar}
  id_But6    = 206;     {User defined button 6 iconbar}
  id_But7    = 207;     {      "             7 iconbar}
  id_But8    = 208;     {      "             8 iconbar}
  id_But9    = 209;     {      "             9 iconbar}
  id_But10   = 210;     {      "            10 iconbar}
  id_But11   = 211;     {      "            11        }
  id_But12   = 212;     {                   12        }
  id_But13   = 213;     {                   13        }
  id_But14   = 214;     {                   14        }
  id_But15   = 215;     {                   15        }
  id_But21   = 221;     {page 1 icon}
  id_But22   = 222;     {page 2 icon}
  id_But23   = 223;     {page 3 icon}
  id_But24   = 224;     {page 4 icon}
  id_Gb1     = 300;     {group box for radio buttons}
  id_GB2     = 200;     {group box for page icons}
  id_St1     = 401;     {Static text 1         icon bar}
  id_St2     = 402;     {Static text 2         icon bar}
  id_Pict    = 501;
  id_D1      = 550;     {Dlg1 - Autoiconize & Setfonts}
  id_D1RB1   = 551;     { autoiconize}
  id_D1RB2   = 552;     { don't }
  id_D1SetFont = 553;   { SetFont button}
  id_D2OK    = 601;     {Dlg2 - Properties  }
  id_D2Browse= 650;     { browse button}
  id_D2EC1   = 603;     { item #}
  id_D2EC2   = 605;     { Name}
  id_D2EC3   = 607;     { file}
  id_D2EC4   = 609;     { Start directory}
  id_D2EC5   = 617;     { parameters}
  id_D2EC6   = 621;     { start size}
  id_D2EC7   = 623;     { Autosize }
  id_D3LB1   = 701;     {Dlg3 - Drive Space}
  idm_About  = 801;     {menu id for CO_Abut menu}
  id_Timer   = 901;     {timer id}
  INISECT = 'OM';
{************************  Types    ************************}
type
TCOApplication = object(TApplication)
  	SplashRect: TRect;
  procedure InitApplication;virtual;
  procedure InitMainWindow;virtual;
  procedure Redraw;
end;

ItemRec = record
ItemNum,PgmName,PgmFile,Dir,Params,Cmdshow,AStart:Array[0..69] of Char;
end;

PPgmItem = ^TPgmItem;
TPgmItem = object(TObject)
		PgmName:PChar;
  	PgmFile:PChar;
  	Dir:PChar;
  	Params:PChar;
  	CmdShow:PChar;
    AStart:PChar;
  constructor Init(NewPgmName,NewPgmFile,NewDir,NewParams,
			NewCmdShow,NewAStart:PChar);
  destructor Done;virtual;
end;

PCOCol = ^TCOCol;
TCOCol = object(TCollection)
		IniFile:Array[0..79] of Char;
		TheItems:PCollection;
	constructor Init(ALimit,ADelta:Integer;NewIniFile:PChar);
  destructor Done;virtual;
  function At(Indx:Integer):PPgmItem;virtual;
  procedure ReadItems(Start,Finish:Integer);virtual;
	procedure ItemGet(var PgmItem:ItemRec);virtual;
	procedure ItemSet(PgmItem:ItemRec);virtual;
  function GetCount:Integer;virtual;
  function IsValidIndx(Indx:Integer):Boolean;
end;

PCODlg1 = ^TCODlg1;
TCODlg1 = object(TDialog)
	procedure IDSetFont(var Msg:TMessage);virtual id_first+id_D1SetFont;
end;

PCODlg2 = ^TCODlg2;
TCODlg2 = object(TDialog)              {Item setup dialog}
		EC1,EC2,EC3,EC4,EC5,EC6,EC7:PEdit;
  constructor Init(AParent:PWindowsObject;AName:PChar);
  procedure IDD2OK(var Msg:TMessage); virtual id_First+id_D2OK;
  procedure IDBrowse(var Msg:TMessage);virtual id_First+id_D2Browse;
end;

PCODlg3 = ^TCODlg3;
TCODlg3 = object(TDialog)              {Run dialog}
	procedure SetupWindow; virtual;
end;

PCOAboutDlg = ^TCOAboutDlg;
TCOAboutDlg = object(TDialog)
		Logo:HBitmap;
  constructor Init(AParent:PWindowsObject;AName:PChar;ALogo:HBitmap);
	procedure WMCtlColor(var Msg:TMessage);virtual wm_First+wm_CtlColor;
end;

PCORButton = ^TCORButton;
TCORButton = object(TRadioButton)
	procedure WMRButtonDown(var Msg:TMessage);virtual wm_First+wm_RButtonDown;
end;

PCOGroupBox = ^TCOGroupBox;
TCOGroupBox = object(TGroupBox)
	procedure SetupWindow;virtual;
  function CanClose:Boolean;virtual;
  procedure WMDropFiles(var Msg:TMessage);virtual wm_First+wm_DropFiles;
end;

PCOStatic = ^TCOStatic;
TCOStatic = object(TSText)
	procedure WMRButtonDown(var Msg:TMessage);virtual wm_First+wm_RButtonDown;
end;

type
PCOWindow = ^TCOWindow;
TCOWindow = object(TWindow)
  	BN1:Array[0..10] of PODDButton;  {icon bar button pointers}
  	BN2:Array[0..5] of PODButton;
  	BNR:Array[0..5] of PODDButton; {page icons}
  	GB1:PCOGroupBox;
  	GB2:PODDGroupBox;
  	RB:Array[0..20] of PCORButton; {radio button pointers id's 301-320}
  	ST1:PCOStatic;
    St2:PCOStatic;
  	Apps:PCOCol;
  	Logo,Pict:HBitmap;
  	PictRect,MPR:TRect;
  	PageNum,AutoMin:Integer;
  	TheFont:HFont;
  	D2TfB:ItemRec;
  	Bitmap:PTBMP;
  	StatDisp:Char;
  	IniFile:Array[0..79] of Char;
  	BkBrush:HBrush;
  	LogFont:TLogFont;
  	FontSize:Integer;
	constructor Init(AParent:PWindowsObject;ATitle:PChar);
  destructor Done;virtual;
  procedure SetupWindow;virtual;
  function GetClassName:PChar;virtual;
  procedure SetRBText;virtual;
  procedure AutoStart;
  procedure Paint(PaintDC:HDC;var PaintInfo:TPaintStruct);virtual;
  procedure SetStaticText;
  procedure	WMDrawItem(var Msg:TMessage);virtual wm_First + wm_DrawItem;
	procedure IDBut11(var Msg:TMessage);virtual id_First+id_But11; { }
  procedure IDBut12(var Msg:TMessage);virtual id_First+id_But12; { }
  procedure	IDBut13(var Msg:TMessage);virtual id_First+id_But13; { }
  procedure IDBut14(var Msg:TMessage);virtual id_First+id_But14; { }
  procedure IDBut15(var Msg:TMessage);virtual id_First+id_But15; {Free Icon}
  procedure DefChildProc(var Msg:TMessage);virtual;
  procedure WinExecc(var Msg:TMessage);virtual;
  procedure	WMSysCommand(var Msg:TMessage);virtual wm_First+wm_SysCommand;
  procedure SetItemValues(PgmItem:ItemRec);virtual;
	procedure WMCtlColor(var Msg:TMessage);virtual wm_First+wm_CtlColor;
  procedure RunIt;virtual;
  procedure UMDropFiles(var Msg:TMessage);virtual wm_User+wm_Dropfiles;
	procedure UMRButtonDown(var Msg:TMessage);virtual wm_User+wm_RButtonDown;
	procedure LoadBMP(BMPName:PChar);
  function CtrlToIndx(Id:Integer):Integer;virtual;
  procedure WMRButtonDown(var Msg:TMessage);virtual wm_First+wm_RButtonDown;
  procedure SetStatProp(var Msg:TMessage);virtual;
  procedure SetButProp(var Msg:TMessage);virtual;
  procedure SetBMPProp(var Msg:TMessage);virtual;
  procedure SetRGBProp(var Msg:TMessage);virtual;
  procedure WMDropFiles(var Msg:TMessage);virtual wm_First+wm_DropFiles;
  procedure GetPictRect;virtual;
  procedure CreateBrush(BkgndColor:PChar);virtual;
  procedure WMNCRButtonDown(var Msg:TMessage);virtual wm_First+wm_NCRButtonDown;
  procedure WMEraseBkGnd(var Msg:TMessage);virtual wm_First+wm_EraseBkGnd;
  procedure WMTimer(var Msg:TMessage);virtual wm_First+wm_Timer;
  procedure UMSetFont(var Msg:TMessage);virtual WM_USER+ID_D1SETFONT;
end;
{***********************  functions  *******************************}

{***********************  Methods    *******************************}
procedure TCOApplication.InitApplication;
var
  DC, MemDC: HDC;
  OldBitMap, BitMap: HBitMap;
  BM: TBitMap;
begin
  DC := CreateDC('Display', Nil, Nil, Nil);
  BitMap := LoadBitMap(HInstance, 'CO_Logo');
  MemDC := CreateCompatibleDC(DC);
  OldBitMap := SelectObject(MemDC, BitMap);
  GetObject(BitMap, SizeOf(BM), @BM);
  with SplashRect do
  begin
    Left := 200;
    Top := 150;
    Right := Left + BM.bmWidth;
    Bottom := Top + BM.bmHeight;
    BitBlt(DC, Left, Top, BM.bmWidth, BM.bmHeight, MemDC, 0, 0, SRCCopy);
  end;
  DeleteObject(SelectObject(MemDC, OldBitMap));
  DeleteDC(MemDC);
  DeleteDC(DC);
  TApplication.InitApplication;
end;

procedure TCOApplication.InitMainWindow;
begin
	MainWindow := New(PCOWindow,Init(nil,'chez O'''));
end;

procedure TCOApplication.Redraw;
begin
	if SplashRect.left = 200 then
		InvalidateRect(0,@SplashRect,True);
end;
{**********************  TCOWindow  *******************************}
constructor TCOWindow.Init(AParent:PWindowsObject;ATitle:PChar);
Const
	BMP:Array[0..25] of PChar = ('','','','','','','','','','','',
  'CO_B1','CO_B2','CO_B3', 'CO_B4', 'CO_B5',
  '','','','','',
  'CO_B21', 'cO_B22','CO_B23','CO_B24','');
{bitmaps CO_B1 to CO_B5 are 34 x 34 16 color resources}
var
  TheBmp:HBitmap;
  Buf:Array[0..69] of Char;
  Indx,ErrCode:Integer;
  TheItem:PPgmItem;
  Buf1:Array[0..80] of Char;
begin
	TWindow.Init(AParent,ATitle);
  Attr.Menu := 0; 
  Attr.X := 20; Attr.Y := 25; Attr.W := 595; Attr.H := 325;
  Attr.Style := ws_Overlapped or ws_SysMenu or ws_MinimizeBox;

  StrCopy(IniFile,'CO.INI');
	if StrLen(CmdLine) <> 0 then StrCopy(IniFile,CmdLine);
	Logo := 0;Pict := 0;PageNum := 1;BkBrush := 0;

  Apps := New(PCOCol,Init(111,20,IniFile));
  Apps^.ReadItems(0,110);
  For Indx := 0 to 10 do BN1[Indx] := nil;
  For Indx := 0 to 5 do BN2[Indx] := nil;
  For Indx := 0 to 4 do BNR[Indx] := nil;
  For Indx := 0 to 20 do RB[Indx] := nil;
  For Indx := 1 to 10 do
  	begin
    TheItem := Apps^.At(Indx+80);
  	BN1[Indx]:=New(PODDButton,Init(@Self,id_GB2+Indx,'',Pred(Indx)*35,0,35,35,False,TheItem^.PgmFile,nil));
  	end;
	For Indx := 1 to 5 do
  	BN2[Indx]:=New(PODButton,Init(@Self,id_GB2+10+Indx,'',Pred(Indx)*35,35,35,35,False,BMP[Indx+10],nil));
  GB2 := New(PODDGroupBox,Init(@Self,id_Gb2,'',0,35,34,34));
  For Indx := 1 to 4 do
  	begin
    TheItem := Apps^.At(Indx+100);
    if TheItem^.Pgmfile = nil then
			BNR[Indx] := New(PODDButton,Init(@Self,Indx+220,'',0,35,35,35,False,BMP[Indx+20],GB2))
    else
			BNR[Indx] := New(PODDButton,Init(@Self,Indx+220,'',0,35,35,35,False,TheItem^.PgmFile,GB2));
    end;
  St1 := New(PCOStatic,Init(@Self,id_St1,'',355,5,235,25,sr_Recessed,
  			dt_Center or dt_VCenter or dt_SingleLine));
  GB1 := New(PCOGroupBox,Init(@Self,id_Gb1,'',200,50,350,230));
  St2 := New(PCOStatic,Init(@Self,id_St2,'',220,54,150,20,SR_Recessed,
  			dt_Center or dt_VCenter or dt_SingleLine));
  For Indx := 1 to 10 do
  	RB[Indx]:=New(PCORButton,Init(@Self,(id_GB1+Indx),'',215,(75+Pred(Indx)*20),160,20,GB1));
  For Indx := 11 to 20 do
  	RB[Indx]:=New(PCORButton,Init(@Self,(id_GB1+Indx),'',385,(75+(Indx-11)*20),160,20,GB1));

	AutoMin :=Min(2,GetPrivateProfileInt(INISECT,'AutoMin',0,IniFile));
  BNR[1]^.State := 1;
  GB2^.SelectionChanged(id_But21);
	GetPrivateProfileString(INISECT,'StatDisp','M',Buf,SizeOf(Buf),IniFile);
  StatDisp := Buf[0];

	FontSize:= GetPrivateProfileInt(INISECT,'FontSize',80,IniFile);
  with LogFont do
  	begin
    GetPrivateProfileString(INISECT,'lfHeight','',Buf1,sizeof(Buf1),IniFile);
    Val(Buf1,lfHeight,errcode);
    lfWidth := GetPrivateProfileInt(INISECT,'lfWidth',0,IniFile);
    lfEscapement := GetPrivateProfileInt(INISECT,'lfEscapement',0,IniFile);
    lfOrientation := GetPrivateProfileInt(INISECT,'lfOrientation',0,IniFile);

    lfWeight := GetPrivateProfileInt(INISECT,'lfWeight',0,IniFile);
    lfItalic := GetPrivateProfileInt(INISECT,'lfItalic',0,IniFile);
    lfUnderLine := GetPrivateProfileInt(INISECT,'lfUnderline',0,IniFile);
    lfStrikeout := GetPrivateProfileInt(INISECT,'lfStrikeout',0,IniFile);

    lfCharSet := GetPrivateProfileInt(INISECT,'lfCharSet',0,IniFile);
    lfOutPrecision := GetPrivateProfileInt(INISECT,'lfOutPrecision',0,IniFile);
    lfClipPrecision := GetPrivateProfileInt(INISECT,'lfClipPrecision',0,IniFile);
    lfQuality := GetPrivateProfileInt(INISECT,'lfQuality',0,IniFile);
    lfPitchAndFamily := GetPrivateProfileInt(INISECT,'lfPitchAndFamily',0,IniFile);
    GetPrivateProfileString(INISECT,'lfFaceName','System',lfFaceName,sizeof(lfFaceName),IniFile);
  end;
end;

function TCOWindow.GetClassName:Pchar;
begin
	GetClassName := 'COWindow';
end;

procedure TCOWindow.SetupWindow;
var
	SysMenu:hMenu;
  Indx:Word;
  CR:TRect;
  NewTop,cModule:Integer;
  Msg:TMessage;
  Buf:Array [0..79] of Char;
begin
	TWindow.SetupWindow;
  if GetModuleUsage(HInstance)=1 then
		SetClassWord(HWindow,GCW_HIcon,LoadIcon(HInstance,'CO_Icon'));
	GetPrivateProfileString(INISECT,'BkgndColor','12632256',Buf,SizeOf(Buf),IniFile);
  CreateBrush(Buf);
  Sysmenu := GetSystemMenu(hWindow,false);
  AppendMenu(SysMenu,MF_Separator,0,nil);
  AppendMenu(Sysmenu,0,idm_About,'About...');
  TheFont := CreateFontIndirect(LogFont);
  GetClientRect(HWindow,CR);
  NewTop := CR.Bottom-Cr.Top-35;
  for Indx := 1  to 4 do
  	if BNR[Indx] <> nil then
    	begin
    	MoveWindow(BNR[Indx]^.HWindow,35*Pred(Indx),NewTop,35,35,False);
      MoveWindow(GB2^.HWindow,0,NewTOP,35*(Indx),35,False);
      end;
	For Indx := 1 to 20 do
		SendMessage(RB[Indx]^.HWindow,WM_SETFONT,TheFont,0);
  SendMessage(GB1^.HWindow,WM_SETFONT,TheFont,0);
  St1^.SetFont(TheFont);
  St2^.SetFont(TheFont);
	GetPrivateProfileString(INISECT,'PgmFile99','COLOGO.BMP',Buf,SizeOf(Buf),IniFile);
  Bitmap:= New(PTBMP,Init('xx'));
  if StrLen(Buf) <> 0 then
  	Bitmap^.LoadBitmapFile(buf);
  Pict := Bitmap^.DDB;
  Logo := LoadBitmap(HInstance,'CO_Logo');
  if Pict = 0 then
  	Pict := Logo;
  SetRect(MPR,5,75,185,CR.Bottom-40);
  GetPictRect;
	SetStaticText;
  SetRBText;
  DragAcceptFiles(HWindow,TRUE);
  SetTimer(HWindow,id_Timer,30000,nil);
  AutoStart;
end;

procedure TCOWindow.SetStaticText;
var
  Buf,Buf1:Array[0..55] of Char;
  Mem :Record
  	GlobalFreeMem,User,GDI:LongInt;
  end;
  Res:Record
  	HRes,VRes,NColors:Integer;
  end;
  PageNumBuf:Array[0..25] of Char;
  nBitsPixel,nPlanes,nSizePalette:Integer;
  DC:HDc;
  R:TRect;
  Item:PPgmItem;
begin
if StatDisp = 'M' then
	begin
	Mem.GlobalFreeMem := Round(GetFreeSpace(0) / 1024);
  Mem.GDI := GetFreeSystemResources(1);
  Mem.User := GetFreeSystemResources(2);
  wvsprintf(Buf,'GMem:%luK  User:%lu%%  GDI:%li%%',Mem);
  end
else
	begin
  Res.HRes := GetSystemMetrics(sm_CXScreen);
  Res.VRes := GetSystemMetrics(sm_CYScreen);
  DC := GetDC(HWindow);
  nPlanes := GetDeviceCaps(DC,Planes);
  nBitsPixel := GetDeviceCaps(DC,BitsPixel);
  nSizePalette := GetDeviceCaps(DC,SizePalette);
  if (RC_Palette AND GetDeviceCaps(DC,RASTERCAPS)) > 0 then
  	Res.NColors := nSizePalette
  else
 		Res.NColors := (nPlanes * nBitsPixel) shl 2 ;
  ReleaseDC(HWindow,DC);
  wvsprintf(Buf,'HRes:%i  VRes:%i  #Colors:%i',Res);
	end;
  St1^.SetText(Buf);
  GetWindowText(GB1^.HWindow,Buf1,sizeof(Buf1));
  Str(PageNum,PageNumBuf);
  StrCat(StrCopy(Buf,'Page: '),PageNumBuf);
  Item :=Apps^.At(PageNum+100);
	if Item^.PgmName <> nil then
  	StrCopy(Buf,Item^.PgmName);
  if StrIComp(Buf,Buf1) <> 0 then
   	St2^.SetText(Buf);
end;

procedure TCOWindow.SetRBText;
var
	Offset:Integer;
	ChildWin:PRadioButton;
  Indx:Integer;
  Item:PPgmItem;
begin
	Offset := Pred(PageNum)*20;
	For Indx := Offset+1 to Offset+20 do
  	begin
    Item := Apps^.At(Indx);
    SetWindowText(RB[Indx-OffSet]^.HWindow,Item^.PgmName);
	  end;
end;

procedure TCOWindow.AutoStart;
var
	Indx:Integer;
  Item:PPgmItem;
  Buf:Array[0..100] of Char;
  Errval:Integer;
  nCmdShow,CmdShow:Integer;
  Iconize:Boolean;
begin
	Iconize := False;
 	for Indx := 1 to 80 do
  	begin
		Item := Apps^.At(Indx);
    if (Item^.PgmName <> nil) and
    	 (Item^.AStart <> nil) and
       (Item^.AStart[0] = 'Y') then
    	begin
  		StrCopy(Buf,Item^.PgmFile);
  		if (Item^.Params <> NIL) then
      		StrCat(StrCat(Buf,' '),Item^.Params);
  		if (Item^.Cmdshow <> NIL) then
  			case Item^.CmdShow[0] of
    			'N','n':Cmdshow := sw_Normal;
      		'M','m':CmdShow := sw_Maximize;
      		'I','i':CmdShow := sw_Minimize;
    	 	else
      		CmdShow := sw_Normal;
    		end
  		else
  			CmdShow := sw_Normal;
			if (Item^.Dir <> NIL) then
  			SetCurdir(Item^.Dir);
  		WinExec(Buf,CmdShow);
      Iconize := True;
      end;
    end;
  if (AutoMin = 1) and Iconize then
  	PostMessage(HWindow,wm_SysCommand,sc_Icon,0);
end;

destructor TCOWindow.Done;
begin
	KillTimer(HWindow,id_Timer);
	Dispose(Bitmap,Done);
	DeleteObject(TheFont);
  Dispose(Apps,Done);
  if Logo <> 0 then DeleteObject(Logo);
	if BkBrush <> 0 then DeleteObject(BkBrush);
  DragAcceptFiles(HWindow,FALSE);
  TWindow.Done;
end;

procedure TCOWindow.Paint(PaintDC:HDC;var PaintInfo:TPaintStruct);
const
	X1=190; Y1=48; X2=560; Y2=290;
var
	ThePen,OldPen:HPen;
  TheBrush,OldBrush:HBrush;
  MemDC:hDC;
  CR:TRect;
begin
	TheBrush := GetStockObject(LtGray_Brush);
	ThePen := CreatePen(ps_Solid,1,$00000000);
  OldPen := SelectObject(PaintDC,ThePen);
  OldBrush := SelectObject(PaintDC,TheBrush);
  GetClientRect(HWindow,CR);
  Rectangle(PaintDC,0,0,CR.Right-CR.Left,35);
  SelectObject(PaintDC,OldBrush);
  SelectObject(PaintDC,OldPen);
  DeleteObject(ThePen);
  DeleteObject(TheBrush);
  SRectangle(PaintDC,X1,Y1,X2,Y2,2,sr_Recessed);
	Bitmap^.Draw(PaintDC,PictRect,False);
end;

procedure	TCOWindow.WMDrawItem(var Msg:TMessage);
var
	PDIS : ^TDrawItemStruct;
begin
	PDIS := Pointer(Msg.lParam);
	case PDIS^.CtlType of
		odt_Button:
		case PDIS^.CtlID of
			id_But1..id_But10:Bn1[PDIS^.CtlID-200]^.DrawItem(Msg);
			id_But11..id_But15:Bn2[PDIS^.CtlID-210]^.DrawItem(Msg);
			id_But21..id_But24:BnR[PDIS^.CtlID-220]^.DrawItem(Msg);
		end;
	end;
end;

procedure TCOWindow.IDBut11(var Msg:TMessage);
var
	Item:PPgmItem;
begin
	Item := Apps^.At(91);
	if (Item^.Dir <> NIL) then
  		SetCurdir(Item^.Dir);
  if (Item^.PgmFile <> nil) then
  	WinExec(Item^.PgmFile,sw_Normal)
  else
		WinExec('command.com',sw_Normal);
end;

procedure TCOWindow.IDBut12(var Msg:TMessage);
begin
	Runit;
end;

procedure TCOWindow.IDBut13(var Msg:TMessage);
var
	Dlg3:PCODlg3;
begin
	Dlg3 := New(PCODlg3,Init(@Self,'CO_Dlg3'));
	Application^.ExecDialog(Dlg3);
end;

procedure TCOWindow.IDBut14(var Msg:TMessage);
var
	FCWin:PFCWindow;
begin
	FCWin := New(PFCWindow,Init(@Self,'cO File'));
  Application^.MakeWindow(FCWin);

end;

procedure TCOWindow.IDBut15(var Msg:TMessage);
begin
  ExitWindows(0,0);
end;

procedure TCOWindow.DefChildProc(var Msg:TMessage);
var
	ID:Integer;
begin
  case Msg.WParam of
  	id_But1..id_But10:
      WinExecc(Msg);
    Succ(id_GB1)..id_GB1+20:
      WinExecc(Msg);
    id_But21..id_But24:
			begin
			PageNum := Msg.wParam-220;
  		SetRBText;
  		SetStaticText;
			end;
    else
    	TWindow.DefChildProc(Msg);
    end;
end;

procedure TCOWindow.WinExecc(var Msg:TMessage);
var
	Indx:Integer;
	Item:PPgmItem;
  Buf:Array[0..100] of Char;
  Errval:Integer;
  nCmdShow,CmdShow:Integer;
begin
	Indx := CtrlToIndx(Msg.wParam);
	Item := Apps^.At(Indx);
  if (Item^.PgmFile = NIL) then
  	begin
  	if (Msg.wParam > id_Gb1) then
  		RB[Msg.WParam-id_GB1]^.Toggle;
    TWindow.DefChildProc(Msg);
    Exit;
    end;
  StrCopy(Buf,Item^.PgmFile);
  if (Item^.Params <> NIL) then
      	StrCat(StrCat(Buf,' '),Item^.Params);
  if (Item^.Cmdshow <> NIL) then
  	case Item^.CmdShow[0] of
    	'N','n':Cmdshow := sw_Normal;
      'M','m':CmdShow := sw_Maximize;
      'I','i':CmdShow := sw_Minimize;
    	else
      	CmdShow := sw_Normal;
    end
  else
  	CmdShow := sw_Normal;
	if (Item^.Dir <> NIL) then
  	SetCurdir(Item^.Dir);
  WinExec(Buf,CmdShow);
  if Msg.wParam > id_GB1 then
		RB[Msg.WParam-id_GB1]^.Toggle;
  If AutoMin = 1 then
  	ShowWindow(HWindow,sw_Minimize);
end;

procedure	TCOWindow.WMSysCommand(var Msg:TMessage);
begin
	case Msg.Wparam of
		idm_About:
 			Application^.ExecDialog(New(PCOAboutDlg,Init(@Self,'CO_About',Logo)));
   	else
   		DefWndProc(Msg);
   	end;
end;

procedure TCOWindow.SetItemValues(PgmItem:ItemRec);
begin
	Apps^.ItemSet(PgmItem);
  SetRBText;
end;

procedure TCOWindow.WMCTLCOLOR(var Msg: TMessage);
begin
  case Msg.LParamHi of
    ctlcolor_Btn:
      begin
      SetBkMode(Msg.WParam, Transparent);
      Msg.Result := GetStockObject(ltGray_Brush);
      end;
  else
    DefWndProc(Msg);
  end;
end;

procedure TCOWindow.Runit;
const
  szFilter:Array[0..8] of Char ='*.*'#0'*.*'#0#0;
var
  Path,Name,Ext,OldDir:Array[0..fsPathName] of Char;
	szDirName:Array[0..256] of Char;
  szFile,szFileTitle:Array[0..256] of Char;
  OFN:TOpenFileName;
begin
	StrCopy(szFile,'');
  OFN.lStructSize := sizeof(TOpenFileName);
  OFN.hWndOwner := HWindow;
  OFN.lpStrFilter := @szFilter;
  OFN.lpStrCustomFilter := nil;
  OFN.nMaxCustFilter := 0;
  OFN.nFilterIndex := LongInt(1);
  OFN.lpStrFile := szFile;
  OFN.nMaxFile := sizeof(szFile);
  OFN.lpstrfileTitle := szFileTitle;
  OFN.nMaxFileTitle := sizeof(szFileTitle);
  OFN.lpstrInitialDir := NIL;
  OFN.lpStrTitle := 'Run A Program';
  OFN.flags := 0;
  OFN.nFileOffset := 0;
  OFN.nFileExtension := 0;
  OFN.lpstrDefext := nil;
  If GetOpenFileName(OFN) then
  	begin
    filesplit(szFile,Path,Name,Ext);
    SetCurDir(Path);
  	WinExec(Name,sw_Normal);
    SetCurdir(OldDir);
  	If AutoMin = 1 then
  		ShowWindow(HWindow,sw_Minimize);
    end;
end;

procedure TCOWindow.UMDropFiles(var Msg:TMessage);
var
	FileNamePtr:PChar;
  CtrlID:Integer;
	Buf1:Array[0..30] of Char;
  Indx:Integer;
	PgmItem:ItemRec;
  Dir,Name,Ext:Array[0..fsPathName] of Char;
begin
	FileNamePtr := Pointer(Msg.lParam);
  FileSplit(FileNamePtr,Dir,Name,Ext);
  AnsiLower(Name);
  Name[0] := UpCase(Name[0]);
	StrCopy(PgmItem.PgmName,Name);
  StrCopy(PgmItem.PgmFile,FileNamePtr);
  CtrlID :=Msg.wParam;
  If CtrlID = id_Pict then
  	Indx := id_BMP
  else
		Indx := CtrlToIndx(Msg.wParam);
  Str(Indx,PgmItem.ItemNum);
  StrCopy(PgmItem.Dir,'');
  StrCopy(PgmItem.Params,'');
  StrCopy(PgmItem.CmdShow,'N');
  StrCopy(PgmItem.AStart,'N');
  SetItemValues(PgmItem);
end;

procedure TCOWindow.UMRButtonDown(var Msg:TMessage);
begin
  if Msg.wParam = id_St1 then
  	SetStatProp(Msg)
  else if (Msg.wParam > id_But11) and (Msg.wParam < Succ(id_But15)) then
  else if (Msg.wParam = id_RGB) then
  	SetRGBProp(Msg)
  else if (Msg.wParam = id_Pict) then
  	SetBMPProp(Msg)
  else if (Msg.wParam > id_GB2) and (Msg.wParam < id_GB1+100) then
  	SetButProp(Msg)
  else
  	DefWndProc(Msg);
end;

function TCOWindow.CtrlToIndx(ID:Integer):Integer;
begin
	if ID > id_GB1 then
		CtrlToIndx := ID - id_GB1 + (20*Pred(PageNum))
  else
		CtrlToIndx := ID - id_GB2 + 80;
end;

procedure TCOWindow.WMRButtonDown(var Msg:TMessage);
begin
 	if PtInRect(PictRect,MakePoint(Msg.lParam))  then
  	SendMessage(HWindow,wm_User+wm_RButtonDown,id_Pict,Msg.lParam)
  else
  	SendMessage(HWindow,wm_User+wm_RButtonDown,id_RGB,Msg.lParam);
	DefWndProc(Msg);
end;

procedure TCOWindow.SetStatProp(var Msg:TMessage);
const Statx:Array[0..1] of Char = ' ';
begin
	if StatDisp = 'M' then
    StatDisp := 'R'
  else
		StatDisp := 'M';
  Statx[0] := StatDisp;
  WritePrivateProfileString(INISECT,'StatDisp',Statx,IniFile);
  SetStaticText;
end;

procedure TCOWindow.SetButProp(var Msg:TMessage);
var
  Dlg2:PCODlg2;
begin
  FillChar(D2TfB,sizeof(D2TfB),$0);
	Dlg2 := New(PCODlg2,Init(@Self,'CO_Dlg2'));
  Str(CtrlToIndx(Msg.wParam),D2TfB.ItemNum);
  Dlg2^.TransferBuffer := @D2TfB;
  Apps^.ItemGet(D2TfB);
	if StrLen(D2TfB.Cmdshow) = 0 then
  	StrCopy(D2TfB.Cmdshow,'N');
  if StrLen(D2TfB.AStart) = 0 then
  	StrCopy(D2TfB.AStart,'N');
  if (Application^.ExecDialog(Dlg2) = 1) then
  	begin
    SetItemValues(D2TfB);
  	if (Msg.wParam > id_But0) and (Msg.wParam < id_But11) then
  		BN1[Msg.wParam - id_But0]^.ChangeBMP(D2TfB.PgmFile)
    else if (Msg.wParam >id_But15) and (Msg.wParam < id_But24+1) then
    	begin
      if StrLen(D2TfB.PgmFile)> 0 then
      	BNR[Msg.wParam - 220]^.ChangeBMP(D2TfB.PgmFile);
      SetStaticText;
      end;
  	end;
end;

procedure TCOWindow.SetBMPProp(var Msg:TMessage);
var
  Dlg2:PCODlg2;
begin
  FillChar(D2TfB,sizeof(D2TfB),$0);
	Dlg2 := New(PCODlg2,Init(@Self,'CO_Dlg2'));
  StrCopy(D2TfB.ItemNum,'99');
  Dlg2^.TransferBuffer := @D2TfB;
  Apps^.ItemGet(D2TfB);
  StrCopy(D2TfB.Cmdshow,'N');
  if (Application^.ExecDialog(Dlg2) = 1) then
  	begin
    SetItemValues(D2TfB);
  	if  (StrLen(D2TfB.PgmFile) <> 0) then
  		LoadBMP(D2TfB.PgmFile);
  	end;
end;

procedure TCOWindow.SetRGBProp(var Msg:TMessage);
var
	Chsclr:TChooseColor;
  Color:LongInt;
  ColorArray:Array[0..15] of LongInt;
  Indx:Integer;
  BkColor:Array[0..12] of Char;
  Buf:Array[0..15] of Char;
  Errornum:Integer;
begin
  	begin
  	for Indx := 0 to 15 do ColorArray[Indx] := LongInt(RGB(255,255,255));
		GetPrivateProfileString(INISECT,'BkgndColor','12632256',Buf,SizeOf(Buf),IniFile);
    Val(Buf,Color,Errornum);
  	ChsClr.lStructsize:= sizeof(TChooseColor);
  	ChsClr.hWndOwner := HWindow;
  	ChsClr.hInstance := HInstance;
  	ChsClr.rgbResult := Color;
   	ChsClr.lpcustcolors := pLongInt(@ColorArray);
  	ChsClr.lcustdata := 0;
  	ChsClr.Flags :=  cc_RGBInit;
  	ChsClr.lptemplateName := PChar(nil);
		if Choosecolor(ChsClr) then
    	begin
    	Str(ChsClr.rgbResult,BkColor);
    	WritePrivateProfileString(INISECT,'BkgndColor',BkColor,IniFile);
      CreateBrush(BkColor);
      end;
    end;
end;

procedure TCOWindow.WMDropFiles(var Msg:TMessage);
var
	DropItem:hDrop;
  FileNameBuf:Array[0..fsPathName] of Char;
  GFileName:PChar;
  Loc:TPoint;
begin
	DropItem := Msg.wParam;
  DragQueryFile(DropItem,0,FileNameBuf,sizeof(FileNameBuf));
  DragQueryPoint(DropItem,Loc);
  DragFinish(DropItem);
 	if PtInRect(PictRect,Loc) then
   	begin
  	GFileName :=StrNew(FileNameBuf);
  	SendMessage(HWindow,wm_User+wm_DropFiles,id_Pict,LongInt(GFileName));
    StrDispose(GFileName);
    LoadBMP(FileNameBuf);
  	end;
end;

procedure TCOWindow.LoadBMP(BMPName:PChar);
begin
	Dispose(BitMap,Done);
  Bitmap:= New(PTBMP,Init('xx'));
  Bitmap^.LoadBitmapFile(BMPName);
  Pict := Bitmap^.DDB;
  GetPictRect;
  InvalidateRect(HWindow,nil,True);
  UpdateWindow(HWindow);
end;

procedure TCOWindow.GetPictRect;
var
	CR:TRect;
  PictMetrics:TBitmap;
  dW,dH:Integer;
begin
	GetClientRect(HWindow,CR);
  GetObject(Pict,SizeOf(PictMetrics),@PictMetrics);
  dW:=(MPR.Right-MPR.Left-PictMetrics.bmWidth) div 2;
  dH := (MPR.Bottom-MPR.Top-PictMetrics.bmHeight) div 2;
  PictRect.Left := Max(MPR.Left +dW , MPR.Left);
  PictRect.Top := Max(MPR.Top+dH, MPR.Top);
  PictRect.Right := Min(MPR.Right-dW,MPR.Right);
  PictRect.Bottom := Min(MPR.Bottom-dH,MPR.Bottom);
end;

procedure TCOWindow.CreateBrush(BkgndColor:PChar);
var
	DC,MemDC:HDC;
  NewBmp,Bmp,OldBmp:HBitmap;
  NewBrush,OldBrush,MonoBrush:HBrush;
  nBkgndColor:TColorRef;
  ErrCode:Integer;
  BkgndBr:HBrush;
begin
  If BkBrush > 0 then
  	DeleteObject(BkBrush);
  Val(BkgndColor,nBkgndColor,ErrCode);
  Bmp :=LoadBitmap(HInstance,'CO_Br');
  MonoBrush :=CreatePatternBrush(Bmp);
	DC := GetDC(HWindow);
  NewBMP := CreateCompatibleBitmap(DC,8,8);
  MemDC := CreateCompatibleDC(DC);
  SetTextColor(MemDC,nBkgndColor);
  OldBrush := SelectObject(MemDC,MonoBrush);
  OldBmp := SelectObject(MemDC,NewBmp);
	PatBlt(MemDC,0,0,8,8,PatCopy);
  SelectObject(MemDC,OldBmp);
  SelectObject(MemDC,OldBrush);
  DeleteObject(MonoBrush);
  BkBrush := CreatePatternBrush(NewBMP);
  DeleteObject(Bmp);
  DeleteObject(NewBmp);
  DeleteDC(MemDC);
  ReleaseDC(HWindow,DC);
  InvalidateRect(HWindow,nil,True);
end;

procedure TCOWindow.WMNCRButtonDown(var Msg:TMessage);
var
	TheDialog:PCODlg1;
	RadioRec :Record
  	RB1,RB2:Bool;
  end;
  RBut1,RBut2:PRadioButton;
  FontBut:PButton;
begin
	TheDialog :=New(PCODlg1,Init(@Self,'CO_DLG1'));
  New(RBut1,InitResource(TheDialog,id_D1RB1));
  New(RBut2,InitResource(TheDialog,id_D1RB2));
  New(FontBut,InitResource(TheDialog,id_D1SetFont));
  RadioRec.RB1 := False;
  RadioRec.RB2 := True;
  TheDialog^.TransferBuffer := @RadioRec;
  Application^.ExecDialog(TheDialog);
  If RadioRec.RB1 then
  	begin
    AutoMin := 1;
    WritePrivateProfileString(INISECT,'AutoMin','1',IniFile);
    end
  else
  	begin
    AutoMin := 0;
    WritePrivateProfileString(INISECT,'AutoMin','0',IniFile);
    end;
end;

procedure TCOWindow.WMEraseBkGnd(var Msg:TMessage);
var
	Rect:TRect;
  OldBrush:HBrush;
begin
	if BkBrush = 0 then
  else
  	begin
		UnrealizeObject(BkBrush);
  	OldBrush := SelectObject(Msg.WParam, BkBrush);
  	GetClientRect(HWindow, Rect);
  	PatBlt(Msg.wParam, Rect.left, Rect.top, Rect.right-Rect.left,
  			Rect.Bottom - Rect.Top, PATCOPY);
  	SelectObject(Msg.wParam, OldBrush);
  	end;
end;

procedure TCOWindow.WMTimer(var Msg:TMessage);
begin
	if Msg.wParam = id_Timer then
		SetStaticText;
end;

procedure TCOWindow.UMSetFont(var Msg:TMessage);
var
	CF:TChooseFont;
  DC:HDC;
	Buf:Array[0..5] of Char;
  Bufl:Array[0..65] of Char;
begin
  DC := GetDC(HWindow);
  with CF do
  	begin
    lStructSize := sizeof(TChooseFont);
    hDC := DC;
    hWndOwner := HWindow;
    lpLogfont:= @LogFont;
    iPointSize := FontSize	;  {in tenths of a point}
    Flags := CF_ScreenFonts or CF_EFFECTS or CF_INITTOLOGFONTSTRUCT;
    rgbColors:=RGB(255,0,0);
    lCustData := 0;
    @lpfnHook:= Pointer(0);
    end;
  if ChooseFont(CF) then
  	begin
  	ReleaseDC(HWindow,DC);
  	FontSize := CF.iPointSize;
    DeleteObject(TheFont);
  	TheFont := CreateFontIndirect(LogFont);
    SetStaticText;
    with LogFont do
  		begin
    	Str(lfHeight,Buf);
    	WritePrivateProfileString(INISECT,'lfHeight',Buf,IniFile);
    	Str(lfWidth,Buf);
    	WritePrivateProfileString(INISECT,'lfWidth',Buf,IniFile);
    	Str(lfEscapement,Buf);
    	WritePrivateProfileString(INISECT,'lfEscapement',Buf,IniFile);
    	Str(lfOrientation,Buf);
    	WritePrivateProfileString(INISECT,'lfOrientation',Buf,IniFile);
    	Str(lfWeight,Buf);
    	WritePrivateProfileString(INISECT,'lfWeight',Buf,IniFile);
    	Str(lfItalic,Buf);
    	WritePrivateProfileString(INISECT,'lfItalic',Buf,IniFile);
    	Str(lfUnderline,Buf);
    	WritePrivateProfileString(INISECT,'lfUnderline',Buf,IniFile);
    	Str(lfStrikeout,Buf);
    	WritePrivateProfileString(INISECT,'lfStrikeout',Buf,IniFile);
    	Str(lfCharSet,Buf);
    	WritePrivateProfileString(INISECT,'lfCharSet',Buf,IniFile);
    	Str(lfOutPrecision,Buf);
    	WritePrivateProfileString(INISECT,'lfOutPrecision',Buf,IniFile);
    	Str(lfClipPrecision,Buf);
    	WritePrivateProfileString(INISECT,'lfClipPrecision',Buf,IniFile);
    	Str(lfQuality,Buf);
    	WritePrivateProfileString(INISECT,'lfQuality',Buf,IniFile);
    	Str(lfPitchAndFamily,Buf);
    	WritePrivateProfileString(INISECT,'lfPitchAndFamily',Buf,IniFile);
    	WritePrivateProfileString(INISECT,'lfFaceName',lfFaceName,IniFile);
    	Str(FontSize,Buf);
    	WritePrivateProfileString(INISECT,'Fontsize',Buf,IniFile);
  	end;
  	SetRBText;
    end
  else
  	ReleaseDC(HWindow,DC);
end;
{************************  TCODlg1  *****************************}
procedure TCODlg1.IDSetFont(var Msg:TMessage);
begin
	SendMessage(Parent^.HWindow,WM_USER+ID_D1SETFONT,0,0);
end;
{***********************  TCODlg2  ******************************}
constructor TCODlg2.Init(AParent:PWindowsObject;AName:PChar);
begin
	TDialog.Init(AParent,AName);
  New(EC1,InitResource(@Self,id_D2Ec1,70));
  New(EC2,InitResource(@Self,id_D2Ec2,70));
  New(EC3,InitResource(@Self,id_D2Ec3,70));
  New(EC4,InitResource(@Self,id_D2Ec4,70));
  New(EC5,InitResource(@Self,id_D2Ec5,70));
  New(EC6,InitResource(@Self,id_D2Ec6,70));
  New(EC7,InitResource(@Self,id_D2EC7,70));
end;

procedure TCODlg2.IDD2OK(var Msg:TMessage);
begin
	TransferData(tf_GetData);
  EndDlg(1);
end;

procedure TCODlg2.IDBrowse(var Msg:TMessage);
const
  szFilter:Array[0..8] of Char ='*.*'#0'*.*'#0#0;
var
  pBuf:PChar;
  Dir,Name,Ext:Array[0..fsPathName] of Char;
	szDirName:Array[0..256] of Char;
  szFile,szFileTitle:Array[0..256] of Char;
  OFN:TOpenFileName;
  Ptr:PChar;
begin
	Ptr := @szFilter;
	StrCopy(szFile,'');
  OFN.lStructSize := sizeof(TOpenFileName);
  OFN.hWndOwner := HWindow;
  OFN.lpStrFilter := Ptr;
  OFN.lpStrCustomFilter := nil;
  OFN.nMaxCustFilter := 0;
  OFN.nFilterIndex := LongInt(1);
  OFN.lpStrFile := szFile;
  OFN.nMaxFile := sizeof(szFile);
  OFN.lpstrfileTitle := szFileTitle;
  OFN.nMaxFileTitle := sizeof(szFileTitle);
  OFN.lpstrInitialDir := NIL;
  OFN.lpStrTitle := 'Select Program';
  OFN.flags := OFN_Pathmustexist or OFN_Filemustexist;
  OFN.nFileOffset := 0;
  OFN.nFileExtension := 0;
  OFN.lpstrDefext := nil;
  If GetOpenFileName(OFN) then
  	begin
    FileSplit(szFile,Dir,Name,Ext);
    StrLower(Name);
    Name[0] := UpCase(Name[0]);
    pBuf := Name;
    EC2^.SetText(pBuf);
    pBuf := szFile;
  	EC3^.SetText(pBuf);
    SetFocus(GetItemHandle(id_D2Ec4));
    end;
end;
{***********************  TCODlg3  ******************************}
procedure TCODlg3.SetupWindow;
var
	ArgList : record
		StrPtr : PChar;
  	Free:PChar;
  	Size:LongInt;
  	PctFree:LongInt;
	end;
	szFree:Array[0..5] of Char;
  rFree:Real;
  szDr:Array[0..2] of Char;
  szOutput : Array[0..80] of Char;
  hListBox:hWnd;
begin
	TDialog.SetupWindow;
	hListBox :=GetItemHandle(Id_D3Lb1);
	SendMessage(hListBox,wm_SetFont,GetStockObject(OEM_Fixed_Font),0);
	DosError := 0; StrCopy(szOutput,'');
  WVSPrintf(szOutput,'Dr  MBf  MBt %%Free',ArgList);
  SendMessage(hListBox,lb_AddString,0,LongInt(@szOutput));

  StrCopy(szDr,'C:');
  while DosError = 0 do
   	begin
    SetCurDir(szDr);
      if DosError = 0 then
      	begin
        rFree := (DiskFree(0) / 1024 / 1024);
        Str(rFree:4:1,szFree);
        ArgList.Free := @szFree;
        ArgList.Size := Round( DiskSize(0) / 1024 /1024) ;
        ArgList.PctFree := Round(DiskFree(0) / (DiskSize(0) / 100 )) ;
        ArgList.StrPtr := @szDr;
        WVSPrintf(szOutput,'%s %s  %3li  %3li',ArgList);
        SendMessage(hListBox,lb_AddString,0,LongInt(@szOutput));
        end;
		Inc(szDr[0]);
    end;
end;
{********************  TCOAbout     **************************}
constructor TCOAboutDlg.Init(AParent:PWindowsObject;AName:PChar;ALogo:HBitmap);
begin
	TDialog.Init(AParent,AName);
  Logo := ALogo;
end;

procedure TCOAboutDlg.WMCTLCOLOR(var Msg: TMessage);
const
  as_AboutSt1 =   126;  {about dlg static text   }
  as_AboutSt2 =   128;  {about dlg static blank static to draw upon}
var
	HSt1,HSt2:HWnd;
  MemDC:hDC;
  OldBitmap:HBitmap;
  CR:TRect;
  X,Y,W,H:Integer;
  LogoMetrics:TBitmap;
begin
  case Msg.LParamHi of
    ctlColor_Static:
      begin
        If (as_AboutSt1 = GetDlgCtrlID(Msg.lParamLo)) then
        	SetTextColor(Msg.WParam, RGB(0,0,255))
        else  if (as_AboutSt2 = GetDlgCtrlID(Msg.lParamLo)) then
        	begin
          MemDC := CreateCompatibleDC(Msg.WParam);
          OldBitmap := SelectObject(MemDC,Logo);
          GetClientRect(Msg.lParamLo,CR);
          W:= CR.Right-CR.Left;H:= CR.Bottom-CR.Top;
          GetObject(Logo,SizeOf(LogoMetrics),@LogoMetrics);
          X := Max((W - LogoMetrics.bmWidth) div 2 , 0);
          Y := Max((H - LogoMetrics.bmHeight) div 2 , 0);
          BitBlt(Msg.WParam,X,Y,W,H,MemDc,0,0,SrcCopy);
          SelectObject(MemDC,OldBitmap);
          DeleteDC(MemDc);
          end;
        SetBkMode(Msg.WParam, transparent);
        Msg.Result := GetStockObject(Null_Brush);
      end;
    ctlcolor_Dlg:
      begin
        SetBkMode(Msg.WParam, Transparent);
        Msg.Result := GetStockObject(ltGray_Brush);
      end;
  else
    DefWndProc(Msg);
  end;
end;
{************************  TPrgItem    *****************************}
constructor TPgmItem.Init(NewPgmName,NewPgmFile,NewDir,NewParams:PChar;
		NewCmdShow,NewAStart:Pchar);
begin
	PgmName := StrNew(NewPgmName);
  PgmFile := StrNew(NewPgmFile);
  Dir := StrNew(NewDir);
  Params := StrNew(NewParams);
  CmdShow := StrNew(NewCmdShow);
  AStart := StrNew(NewAStart);
end;

destructor TPgmItem.Done;
begin
	StrDispose(PgmName);
  StrDispose(PgmFile);
  StrDispose(Dir);
  StrDispose(Params);
  StrDispose(CmdShow);
  StrDispose(AStart);
end;
{************************  TCOCol    *****************************}
constructor TCOCol.Init(ALimit,ADelta:Integer;NewIniFile:Pchar);
begin
	TheItems := New(PCollection,Init(ALimit,ADelta));
  StrCopy(IniFile,NewIniFile);
end;

destructor TCOCol.Done;
begin
	Dispose(TheItems,Done);
end;

function TCOCol.At(Indx:Integer):PPgmItem;
begin
	At := TheItems^.At(Indx);
end;

procedure TCOCol.ReadItems(Start,Finish:Integer);
var
	Buf1:Array[0..30] of Char;
  Indx:Integer;
  IndxStr:Array[0..5] of Char;
  Found:Boolean;
  Key:Array[0..20] of Char;
  PgmName,PgmFile,Dir,Params:Array[0..50] of Char;
  CmdShow,AStart:Array[0..5] of Char;
begin
  for Indx := Start to Finish do
  	begin
    StrCopy(PgmFile,'');Strcopy(Dir,'');StrCopy(Params,'');StrCopy(CmdShow,'');StrCopy(AStart,'');
    wvsprintf(IndxStr,'%02i',Indx);
    Str(Indx,IndxStr); 
    StrCat(StrCopy(Key,'PgmName'),IndxStr);
		GetPrivateProfileString(INISECT,Key,'',PgmName,SizeOf(PgmName),IniFile);
    if PgmName[0] <> #0 then
    	begin
    	StrCat(StrCopy(Key,'PgmFile'),IndxStr);
			GetPrivateProfileString(INISECT,Key,'',PgmFile,SizeOf(PgmFile),IniFile);
    	StrCat(StrCopy(Key,'Dir'),IndxStr);
			GetPrivateProfileString(INISECT,Key,'',Dir,SizeOf(dir),IniFile);
    	StrCat(StrCopy(Key,'Params'),IndxStr);
			GetPrivateProfileString(INISECT,Key,'',Params,SizeOf(Params),IniFile);
    	StrCat(StrCopy(Key,'CmdShow'),IndxStr);
			GetPrivateProfileString(INISECT,Key,'N',Cmdshow,SizeOf(CmdShow),IniFile);
    	StrCat(StrCopy(Key,'AStart'),IndxStr);
			GetPrivateProfileString(INISECT,Key,'N',AStart,SizeOf(AStart),IniFile);
    	end;
    TheItems^.AtInsert(Indx,New(PPgmItem,Init(PgmName,PgmFile,Dir,Params,Cmdshow,AStart)));
    end;
end;

procedure TCOCol.ItemGet(var PgmItem:ItemRec);
var
  Indx:Integer;
  IndxStr:Array[0..5] of Char;
  ErrCode:Integer;
  TheItem:PPgmItem;
begin
	Val(PgmItem.ItemNum,Indx,ErrCode);
  if (ErrCode <> 0) or (NOT(IsValidIndx(Indx))) then
  	Exit;
  begin
  TheItem := TheItems^.At(Indx);
  If TheItem^.PgmName <> nil then
  	StrCopy(PgmItem.PgmName,TheItem^.PgmName);
  If TheItem^.PgmFile <> nil then
  	StrCopy(PgmItem.PgmFile,TheItem^.PgmFile);
  If TheItem^.Dir <> nil then
  	StrCopy(PgmItem.Dir,TheItem^.Dir);
  If TheItem^.Params <> nil then
  	StrCopy(PgmItem.Params,TheItem^.Params);
  If TheItem^.Cmdshow <> nil then
  	StrCopy(PgmItem.CmdShow,TheItem^.Cmdshow);
  If TheItem^.AStart <> nil then
  	StrCopy(PgmItem.AStart,TheItem^.AStart);
	end;
end;

procedure TCOCol.ItemSet(PgmItem:ItemRec);
var
	Buf1:Array[0..30] of Char;
  Indx:Integer;
  IndxStr:Array[0..5] of Char;
  Found:Boolean;
  Key:Array[0..20] of Char;
  Errval:Integer;
begin
	Val(PgmItem.ItemNum,Indx,Errval);
  If IsValidIndx(Indx) then
  	begin
   	StrCopy(IndxStr,PgmItem.ItemNum) ;
    StrCat(StrCopy(Key,'PgmName'),IndxStr);
		WritePrivateProfileString(INISECT,Key,PgmItem.PgmName,IniFile);
    StrCat(StrCopy(Key,'PgmFile'),IndxStr);
		WritePrivateProfileString(INISECT,Key,PgmItem.PgmFile,IniFile);
    StrCat(StrCopy(Key,'Dir'),IndxStr);
		WritePrivateProfileString(INISECT,Key,PgmItem.Dir,IniFile);
    StrCat(StrCopy(Key,'Params'),IndxStr);
		WritePrivateProfileString(INISECT,Key,PgmItem.Params,IniFile);
    StrCat(StrCopy(Key,'CmdShow'),IndxStr);
		WritePrivateProfileString(INISECT,Key,ANSIUpper(PgmItem.CmdShow),IniFile);
    StrCat(StrCopy(Key,'AStart'),IndxStr);
		WritePrivateProfileString(INISECT,Key,AnsiUpper(PgmItem.AStart),IniFile);
    TheItems^.AtFree(Indx);
    TheItems^.AtInsert(Indx,New(PPgmItem,Init(PgmItem.PgmName,PgmItem.PgmFile,
    	PgmItem.Dir,PgmItem.Params,PgmItem.Cmdshow,PgmItem.AStart)));
    end;
end;

function TCOCol.GetCount:Integer;
begin
	GetCount := TheItems^.Count;
end;

function TCOCol.IsValidIndx(Indx:Integer):Boolean;
begin
	IsValidIndx :=((Indx >= 0) and (Indx < TheItems^.Count));
end;
{************************  TCORButton    *****************************}
procedure TCORButton.WMRButtonDown(var Msg:TMessage);
begin
  SendMessage(Parent^.HWindow,wm_User+wm_RButtonDown,GetID,0);
end;
{*************************  TCOGroupBox     **************************}
procedure TCOGroupBox.SetupWindow;
begin
	TGroupBox.SetupWindow;
  DragAcceptFiles(HWindow,TRUE);
end;

function TCOGroupBox.CanClose:Boolean;
begin
	DragAcceptFiles(HWindow,FALSE);
	CanClose := TGroupBox.CanClose;
end;

procedure TCOGroupBox.WMDropFiles(var Msg:TMessage);
var
	DropItem:hDrop;
  FileNameBuf:Array[0..fsPathName] of Char;
  GFileName:PChar;
  CtrlID:Integer;
  Loc,SLoc:TPoint;
  ChildWin:HWnd;
begin
	DropItem := Msg.wParam;
  DragQueryFile(DropItem,0,FileNameBuf,sizeof(FileNameBuf));
  GFileName :=StrNew(FileNameBuf);
  DragQueryPoint(DropItem,Loc);
  DragFinish(DropItem);
  SLoc := Loc;
  ClienttoScreen(HWindow,SLoc);
  ChildWin := WindowFromPoint(SLoc);
  CtrlID := GetDlgCtrlID(ChildWin);
  SendMessage(Parent^.HWindow,wm_User+wm_DropFiles,CtrlID,LongInt(GFileName));
  StrDispose(GFileName);
end;
{************************  TCOStatic    *****************************}
procedure TCOStatic.WMRButtonDown(var Msg:TMessage);
begin
  SendMessage(Parent^.HWindow,wm_User+wm_RButtonDown,GetID,0);
end;
{***********************  MainLine  ********************************}
var
	COApp : TCOApplication;
begin
	COApp.Init(INISECT);
  COApp.Redraw;
	COApp.Run;
	COApp.Done;
end.
