{WFPLUS - Function Extensions to ObjectWindows Copyright (C) Doug Overmyer 7/1/91}
unit WFPlus;
{************************  Interface       **********************}
interface
uses WinTypes, WinProcs, WinDos, Strings, WObjects;
const
  sr_Recessed     =   1;
  sr_Raised       =   0;
function Max(I,J:Integer):Integer;
function Min(I,J:Integer):Integer;
function GetDateTime(szDateTime:PChar):Boolean;
function ExpandTabs(InStr,OutStr:PChar;Tabsize:Integer):Boolean;
function CheckCC(InStr,OutStr:PChar):Boolean;
function SRectangle(PaintDC,X1,Y1,X2,Y2,LineWidth,State:Integer):Boolean;
{************************  Implementation  ***************************}
implementation
{*************************  Max           ****************************}
function Max(I,J:Integer):Integer;
begin
  if I < J then
    Max := J
  else
    Max := I;
end;

{************************  Min            ****************************}
function Min(I,J:Integer):Integer;
begin
  if I < J then
    Min := I
  else
    Min := J;
end;

function  GetDateTime(szDateTime:PChar):Boolean;
var
  m,d,y,dw: Word;
  temp,tag: string[4];
  tStr: String;
Begin
  tStr := '';
  GetTime(y,m,d,dw);
  if (y > 12) then begin
    y := (y - 12);
    tag := 'pm';
  End else
    tag := 'am';
  str(y,temp);
  if (y < 10) then
    temp := '0' + Temp;
  tStr := tStr + temp + ':';
  str(m,Temp);
  tStr := tStr + temp + ':';
  str(d,temp);
  tStr := tStr + temp + tag + '     ';
  GetDate(y,m,d,dw);
  str(m,Temp);
  if (m < 10) then
    temp := '0' + temp;
  tStr := tStr + temp + '/';
  str(d,Temp);
  if (d < 10) then
    Temp := '0' + temp;
  tStr := tStr + Temp + '/';
  str(y,temp);
  tStr := tStr + temp;
  strPcopy(szDateTime,tStr);
  GetDateTime := True;
End;

function ExpandTabs(InStr,OutStr:PChar;Tabsize:Integer):Boolean;
var
  IndxIn,IndxOut,IndxTab:Integer;
  NextTab:Integer;
  Limit:Integer;
begin
  IndxIn := 0;IndxOut:= 0;IndxTab:= 0;
  If InStr <> nil then
  	Limit := Max(StrLen(Instr)-1,0)
  else
  	Limit := 0;
  For IndxIn := 0 to Limit do
    case InStr[IndxIn] of
      #9:
        begin
        NextTab := ((IndxOut div TabSize) +1) * TabSize;
        for IndxTab := 1 to (NextTab - IndxOut) do
          begin
          OutStr[IndxOut] := #32;
          Inc(IndxOut);
          end;
        end;
      #0..#31:
        begin
        OutStr[IndxOut] := #32;
        Inc(IndxOut);
        end;
      else
        begin
        OutStr[IndxOut] := InStr[IndxIn];
        Inc(IndxOut);
        end;
    end;
  OutStr[IndxOut] := #0;
  ExpandTabs := TRUE;
end;

function CheckCC(InStr,OutStr:PChar):Boolean;
var
  IndxIn,IndxOut:Integer;
begin
  IndxIn := 0;IndxOut:= 0;
  For IndxIn := 0 to (StrLen(InStr) -1) do
    case InStr[IndxIn] of
      #9:                             {retain tabs}
        begin
        OutStr[IndxOut] := #9;
        Inc(IndxOut);
        end;
      #0..#31:
        begin
        OutStr[IndxOut] := #32;
        Inc(IndxOut);
        end;
      else
        begin
        OutStr[IndxOut] := InStr[IndxIn];
        Inc(IndxOut);
        end;
    end;
  OutStr[IndxOut] := #0;
  CheckCC := TRUE;
end;

function SRectangle(PaintDC,X1,Y1,X2,Y2,LineWidth,State:Integer):Boolean;
var
  MemDC:HDc;
  ThePen,Pen1,Pen2,OldPen:HPen;
  TheBrush,OldBrush:HBrush;
  OldBitMap:HBitMap;
  LPts,RPts:Array[0..2] of TPoint;
  X,Y,W,H:Integer;
  PW,Ofs:Integer;
  DBU:LongRec;
begin
  LongInt(DBU) := GetDialogBaseUnits;               
  PW := Ofs;
  Ofs := 1;            
  TheBrush := GetStockObject(LtGray_Brush);
  ThePen := CreatePen(ps_Solid,1,$00000000);
  OldPen := SelectObject(PaintDC,ThePen);
  OldBrush := SelectObject(PaintDC,TheBrush);
  Rectangle(PaintDC,X1,Y1,X2,Y2);    {Draw gray box,black border}
  SelectObject(PaintDC,OldBrush);
  SelectObject(PaintDC,OldPen);
  DeleteObject(ThePen);

  LPts[0].x := X1+Ofs; LPts[0].y := Y2-Ofs;
  LPts[1].x := X1+Ofs; LPts[1].y := Y1-Ofs;
  LPts[2].x := X2-Ofs; LPts[2].y := Y1-Ofs;
  RPts[0].x := X1+Ofs; RPts[0].y := Y2-Ofs;
  RPts[1].x := X2-Ofs; RPts[1].y := Y2-Ofs;
  RPts[2].x := X2-Ofs; RPts[2].y := Y1-Ofs;
  if State = sr_Raised then
    begin
    Pen1 := CreatePen(ps_Solid,LineWidth,$00FFFFFF);
    Pen2 := CreatePen(ps_Solid,LineWidth,$00808080);
    end
  else
    begin
    Pen1 := CreatePen(ps_Solid,LineWidth,$00000000);
    Pen2 := CreatePen(ps_Solid,LineWidth,$00FFFFFF);
    end;

  OldPen := SelectObject(PaintDC,Pen1);   {Draw the highlights}
  PolyLine(PaintDC,LPts,3);
  SelectObject(PaintDC,Pen2);
  DeleteObject(Pen1);

  PolyLine(PaintDC,RPts,3);
  SelectObject(PaintDC,OldPen);
  DeleteObject(Pen2);

end;

end.
