#include <stdio.h>

FILE *fp;
char filename[100];
char fileroot[100];

void main(int argc,char **argv)

{
	printf("newsaver - creates template for screen saver for Screen Peace\n");
	printf("    by Anthony Andersen\n");
	printf("This program is Public Domain\n\n");
	if (argc == 1) {
		printf("usage : newsaver filename\n\n");
		printf("    where : filename is the name of the new screen saver project\n");
		printf("            (no file extension)\n\n");
		return;
	}

	strcpy(fileroot,argv[1]);

/* make file */

	strcpy(filename,fileroot);
	fp = fopen(filename,"wt");
	if (fp == NULL) {
		printf("ERROR - can't open file %s\n",filename);
		return;
	}


	fprintf(fp,"all: %s.spx\n",fileroot);
	fprintf(fp,"\n");
	fprintf(fp,".c.obj:\n");
	fprintf(fp,"    cl -c -Asnw -Gsw -Oas -Zpe -W3 $*.c >$*.err\n");
	fprintf(fp,"\n");
	fprintf(fp,"%s.obj: %s.c %s.h\n",fileroot,fileroot,fileroot);
	fprintf(fp,"\n");
	fprintf(fp,"%s.res: %s.rc %s.dlg\n",fileroot,fileroot,fileroot);
	fprintf(fp,"    rc -r %s.rc\n",fileroot);
	fprintf(fp,"\n");
	fprintf(fp,"libentry.obj: libentry.asm\n");
	fprintf(fp,"   masm -Mx libentry,libentry;\n");
	fprintf(fp,"\n");
	fprintf(fp,"%s.spx: libentry.obj %s.obj %s.def %s.res\n",fileroot,fileroot,fileroot,fileroot);
	fprintf(fp,"    link %s libentry, %s.exe, , /NOE /NOD sdllcew libw, %s.def\n",fileroot,fileroot,fileroot);
	fprintf(fp,"    rc %s.res\n",fileroot);
	fprintf(fp,"    if exist %s.spx del %s.spx\n",fileroot,fileroot);
	fprintf(fp,"    ren %s.exe %s.spx\n",fileroot,fileroot);
	fprintf(fp,"\n");

	fclose(fp);
	printf("created file %s\n",filename);

/* end */

/* def file */

	strcpy(filename,fileroot);
	strcat(filename,".def");
	fp = fopen(filename,"wt");
	if (fp == NULL) {
		printf("ERROR - can't open file %s\n",filename);
		return;
	}

	fprintf(fp,"LIBRARY   %s\n",fileroot);
	fprintf(fp,"\n");
	fprintf(fp,"EXETYPE   WINDOWS\n");
	fprintf(fp,"\n");
	fprintf(fp,"CODE	  PRELOAD MOVEABLE DISCARDABLE\n");
	fprintf(fp,"DATA	  PRELOAD SINGLE\n");
	fprintf(fp,"\n");
	fprintf(fp,"HEAPSIZE  1024\n");
	fprintf(fp,"\n");
	fprintf(fp,"EXPORTS\n");
	fprintf(fp,"	WEP                 @1 RESIDENTNAME\n");
	fprintf(fp,"	saverinit           @2\n");
	fprintf(fp,"	saverdraw           @3\n");
	fprintf(fp,"	saverdlgproc        @4\n");
	fprintf(fp,"	LibMain             @5\n");

	fclose(fp);
	printf("created file %s\n",filename);

/* end */

/* c file */

	strcpy(filename,fileroot);
	strcat(filename,".c");
	fp = fopen(filename,"wt");
	if (fp == NULL) {
		printf("ERROR - can't open file %s\n",filename);
		return;
	}


	fprintf(fp,"#include <windows.h>\n");
	fprintf(fp,"\n");
	fprintf(fp,"#include \"%s.h\"\n",fileroot);
	fprintf(fp,"\n");
	fprintf(fp,"#define IDD_CHECKBOX 10\n");
	fprintf(fp,"\n");
	fprintf(fp,"unsigned long seed;\n");
	fprintf(fp,"char buffer[10];\n");
	fprintf(fp,"int  enabled;\n");
	fprintf(fp,"\n");
	fprintf(fp,"\n");
	fprintf(fp,"char savername[] = \"Generic Saver\";\n");
	fprintf(fp,"char appname[] = \"Screen Peace\";\n");
	fprintf(fp,"char keyname[] = \"Generic On\";\n");
	fprintf(fp,"\n");
	fprintf(fp,"/* this is called by the default dll entry code during the  */\n");
	fprintf(fp,"/* load library call - always happens BEFORE any other call */\n");
	fprintf(fp,"/* in the dll.                                              */\n");
	fprintf(fp,"\n");
	fprintf(fp,"int FAR PASCAL LibMain(hModule, wDataSeg, cbHeapSize, lpszCmdLine)\n");
	fprintf(fp,"\n");
	fprintf(fp,"HANDLE	hModule;\n");
	fprintf(fp,"WORD     wDataSeg;\n");
	fprintf(fp,"WORD     cbHeapSize;\n");
	fprintf(fp,"LPSTR    lpszCmdLine;\n");
	fprintf(fp,"\n");
	fprintf(fp,"{\n");
	fprintf(fp,"\n");
	fprintf(fp,"   /* set up things here */\n");
	fprintf(fp,"\n");
	fprintf(fp,"	GetProfileString(appname,keyname,\"y\",buffer,9);\n");
	fprintf(fp,"	if (buffer[0] != 'n' && buffer[0] != 'N') {\n");
	fprintf(fp,"		enabled = TRUE;\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	return (1);\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");
	fprintf(fp,"\n");
	fprintf(fp,"/* this is called by Windows when the dll is released */\n");
	fprintf(fp,"\n");
	fprintf(fp,"int FAR PASCAL WEP (bSystemExit)\n");
	fprintf(fp,"int  bSystemExit;\n");
	fprintf(fp,"\n");
	fprintf(fp,"{\n");
	fprintf(fp,"    /* get rid of things you allocated in the LibMain proc here */\n");
	fprintf(fp,"\n");
	fprintf(fp,"    return (1);\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");
	fprintf(fp,"/* this is called (probably lots of times) by Screen Peace */\n");
	fprintf(fp,"/* be careful not to allocate memory in here               */\n");
	fprintf(fp,"\n");
	fprintf(fp,"char FAR * FAR PASCAL saverinit(BOOL far *savenabled)\n");
	fprintf(fp,"\n");
	fprintf(fp,"{\n");
	fprintf(fp,"	/* tell enable state */\n");
	fprintf(fp,"\n");
	fprintf(fp,"	*savenabled = enabled;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	/* this next is optional but it may be used in future versions */\n");
	fprintf(fp,"\n");
	fprintf(fp,"	return(savername);\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");
	fprintf(fp,"/* dialog proc for user customization */\n");
	fprintf(fp,"\n");
	fprintf(fp,"BOOL FAR PASCAL saverdlgproc(HWND hdlg,unsigned message,WORD wparam,LONG lparam)\n");
	fprintf(fp,"\n");
	fprintf(fp,"{\n");
	fprintf(fp,"	switch (message) {\n");
	fprintf(fp,"\n");
	fprintf(fp,"	case WM_INITDIALOG:\n");
	fprintf(fp,"		SendDlgItemMessage(hdlg,IDD_CHECKBOX,BM_SETCHECK,enabled,0);\n");
	fprintf(fp,"		return (TRUE);\n");
	fprintf(fp,"\n");
	fprintf(fp,"	case WM_COMMAND:\n");
	fprintf(fp,"		if (wparam == IDOK) {\n");
	fprintf(fp,"			enabled = (int)SendDlgItemMessage(hdlg,IDD_CHECKBOX,BM_GETCHECK,0,0);\n");
	fprintf(fp,"			if (enabled) buffer[0] = 'y';\n");
	fprintf(fp,"			else buffer[0] = 'n';\n");
	fprintf(fp,"			buffer[1] = 0;\n");
	fprintf(fp,"			WriteProfileString(appname,keyname,buffer);\n");
	fprintf(fp,"			EndDialog(hdlg,TRUE);\n");
	fprintf(fp,"			return (TRUE);\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"		else if (wparam == IDCANCEL) {\n");
	fprintf(fp,"			EndDialog(hdlg,FALSE);\n");
	fprintf(fp,"			return (TRUE);\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"      break;\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");
	fprintf(fp,"	return (FALSE);\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");
	fprintf(fp,"/* returns pseudorandom number from 0 to x-1 */\n");
	fprintf(fp,"\n");
	fprintf(fp,"int arand(int x)\n");
	fprintf(fp,"{\n");
	fprintf(fp,"	seed = seed*0x343fd+0x269ec3;\n");
	fprintf(fp,"	return (int)(((seed>>16)&0x7fff)*x>>15);\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");
	fprintf(fp,"/* the main drawing routine */\n");
	fprintf(fp,"\n");
	fprintf(fp,"VOID FAR PASCAL saverdraw(HWND hwnd,HDC hdc,HANDLE hinst,BOOL (FAR PASCAL *yieldproc)(VOID)) \n");
	fprintf(fp,"\n");
	fprintf(fp,"{\n");
	fprintf(fp,"	RECT   rect;\n");
	fprintf(fp,"	HBRUSH hbrush;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	GetWindowRect(hwnd,&rect);\n");
	fprintf(fp,"\n");
	fprintf(fp,"	/* seed the pseudorandom number generator */\n");
	fprintf(fp,"\n");
	fprintf(fp,"	seed = GetTickCount();\n");
	fprintf(fp,"\n");
	fprintf(fp,"	hbrush = GetStockObject(BLACK_BRUSH);\n");
	fprintf(fp,"\n");
	fprintf(fp,"	/* You MUST \"black out\" the screen if you want the screen black */\n");
	fprintf(fp,"\n");
	fprintf(fp,"	FillRect(hdc,&rect,hbrush);\n");
	fprintf(fp,"\n");
	fprintf(fp,"	/* make sure to call yieldproc OFTEN - windows is locked up until */\n");
	fprintf(fp,"	/* yieldproc is called.                                           */\n");
	fprintf(fp,"\n");
	fprintf(fp,"	while ((*yieldproc)()) {\n");
	fprintf(fp,"\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");
	fprintf(fp,"}\n");

	fclose(fp);
	printf("created file %s\n",filename);

/* end */

/* res file */

	strcpy(filename,fileroot);
	strcat(filename,".rc");
	fp = fopen(filename,"wt");
	if (fp == NULL) {
		printf("ERROR - can't open file %s\n",filename);
		return;
	}

	fprintf(fp,"#include \"windows.h\"\n");
	fprintf(fp,"\n");
	fprintf(fp,"RCINCLUDE %s.dlg\n",fileroot);


	fclose(fp);
	printf("created file %s\n",filename);

/* end */

/* dlg file */

	strcpy(filename,fileroot);
	strcat(filename,".dlg");
	fp = fopen(filename,"wt");
	if (fp == NULL) {
		printf("ERROR - can't open file %s\n",filename);
		return;
	}

	fprintf(fp,"DIALOGBOX DIALOG LOADONCALL MOVEABLE DISCARDABLE 13, 35, 110, 80\n");
	fprintf(fp,"STYLE WS_DLGFRAME | WS_POPUP\n");
	fprintf(fp,"BEGIN\n");
	fprintf(fp,"    CONTROL \"OK\", 1, \"button\", BS_DEFPUSHBUTTON | WS_TABSTOP | WS_CHILD, 40, 59, 30, 14\n");
	fprintf(fp,"    CONTROL \"Generic Screen Saver\", 101, \"static\", SS_CENTER | WS_CHILD, 10, 8, 90, 8\n");
	fprintf(fp,"    CONTROL \"by Someone\", 102, \"static\", SS_CENTER | WS_CHILD, 10, 22, 90, 8\n");
	fprintf(fp,"    CONTROL \"Enabled\", 10, \"button\", BS_AUTOCHECKBOX | WS_TABSTOP | WS_CHILD, 35, 41, 40, 12\n");
	fprintf(fp,"END\n");
	fprintf(fp,"\n");


	fclose(fp);
	printf("created file %s\n",filename);

/* end */

/* dlg file */

	strcpy(filename,fileroot);
	strcat(filename,".h");
	fp = fopen(filename,"wt");
	if (fp == NULL) {
		printf("ERROR - can't open file %s\n",filename);
		return;
	}

	fprintf(fp,"\n");

	fclose(fp);
	printf("created file %s\n",filename);

/* end */

}

