/*----------------------------------------
   SSBLIND.C -- Pull Blinds on Windows
                (c) Paul J. Gyugyi, 1992
   Based on:	Mixup Screen Saver
                (c) Charles Petzold, 1992
  ----------------------------------------*/

#include <windows.h>
#include <mmsystem.h>
#include <scrnsave.h>
#include <stdlib.h>

#define ID_TIMER    1
#define UINT unsigned int

char szAppName [] = "ScreenSaver.Blind" ;
char szProfKey [] = "Sound" ;
int  noise = MB_ICONSTOP;

LONG FAR PASCAL ScreenSaverProc (HWND hwnd,   UINT message,
                                 WORD wParam, LONG lParam)
     {
     static int      iIndex ;
     static short    cxClient, cyClient ;
     static HDC      hdc ;
     static HWND     hwnd2;
     RECT			 rect;
     static HRGN     hrgn;
     int             rheight;
     HBRUSH          dabrush;
     static int      isound;

     switch (message)
          {
          case WM_CREATE:
               isound = GetProfileInt(szAppName,szProfKey,0);
               cxClient = GetSystemMetrics (SM_CXSCREEN) ;
               cyClient = GetSystemMetrics (SM_CYSCREEN) ;
               SetTimer (hwnd, ID_TIMER, 1000/16, NULL) ;
			   hwnd2=GetWindow(hwnd,GW_HWNDFIRST);
			   hrgn=CreateRectRgn(0,0,cxClient,cyClient);
               hdc = GetDC (hwnd) ;
			   SelectObject(hdc,
			     CreatePen(PS_SOLID,2,RGB(0,255,255)));
			   SelectObject(hdc,
			     CreateHatchBrush(HS_HORIZONTAL,RGB(192,192,192)));
			   SetBkMode(hdc,OPAQUE);
			   SetBkColor(hdc,RGB(128,128,128));
			   SelectClipRgn(hdc,hrgn);
               break ;

          case WM_ERASEBKGND:
               return 1 ;

          case WM_TIMER:
			   if (hwnd2 != NULL) {
			     if ((hwnd2 != hwnd)    &&
			         (IsWindow(hwnd2))  &&
			         (IsWindowVisible(hwnd2))) {
			       GetWindowRect(hwnd2,&rect);
			       dabrush=SelectObject(hdc,
			         GetStockObject(BLACK_BRUSH));
			       UnrealizeObject(dabrush);
			       SetBrushOrg(hdc,rect.left,rect.top);
			       SelectObject(hdc,dabrush);
			       rheight=rect.bottom - rect.top;
			       Rectangle(hdc,rect.left,rect.top+rheight/4,
			         rect.right,rect.top);
			       Rectangle(hdc,rect.left,rect.top,
			         rect.right,rect.top + rheight/2);
			       Rectangle(hdc,rect.left,rect.top,
			         rect.right,rect.top+rheight*3/4);
			       if (isound) {
			         MessageBeep(noise);
			       }
			       Rectangle(hdc,rect.left,rect.top,
			         rect.right,rect.bottom);
			       ExcludeClipRect(hdc,
			         rect.left,rect.top,rect.right,rect.bottom);
			     };
               };
  		       hwnd2 = GetWindow(hwnd2,GW_HWNDNEXT);
               return 0 ;

          case WM_DESTROY:
               KillTimer (hwnd, ID_TIMER) ;
		       DeleteObject(SelectObject(hdc,
	             GetStockObject(BLACK_PEN)));
	           DeleteObject(SelectObject(hdc,
	             GetStockObject(BLACK_BRUSH)));
               ReleaseDC (hwnd, hdc) ;
			   DeleteObject(hrgn);
               break ;
          }

     return DefScreenSaverProc (hwnd, message, wParam, lParam) ;
     }

BOOL FAR PASCAL ScreenSaverConfigureDialog (HWND hDlg,   UINT message,
                                            WORD wParam, LONG lParam)
     {
     static int isound;
     char szSound[8];

     switch(message) {
       case WM_INITDIALOG:
         isound = GetProfileInt(szAppName,szProfKey,0);
         CheckDlgButton(hDlg,101,isound);
         return TRUE;
       case WM_COMMAND:
         switch(wParam) {
           case 101:
             if (IsDlgButtonChecked(hDlg,101)) {
               isound=1;
             }else{
               isound=0;
             }
             return TRUE;
           case IDOK:
             itoa(isound,szSound,10);
             WriteProfileString(szAppName,szProfKey,szSound);
             EndDialog(hDlg, TRUE);
             return TRUE;
           case IDCANCEL:
             EndDialog(hDlg,FALSE);
             return TRUE;
         }
         break;
     }
     return FALSE ;
     }

BOOL RegisterDialogClasses (HANDLE hInstanc)
     {
     return TRUE ;
     }
