#define	_WINDOWS

#define	no_Trace_

#include "c:\windev\include\windows.h"
#include "cwinst.h"

BOOL	FAR PASCAL MainWndProc (HWND, WORD, WORD, LONG);
BOOL	FAR PASCAL About (HWND, WORD, WORD, LONG);
BOOL	FAR PASCAL Options (HWND, WORD, WORD, LONG);

HANDLE	hInst;
char	szCwInst []= "CWINST";
char	szTitle []= "Cyrillic driver installation";

HANDLE	hWait;
HANDLE	hArrow;

#define	WM_ALTKEYBKILL	(WM_USER + 1141)

//
// installations options
//
int	bInstallSys= 1;
int	bCommentFonts= 1;
int	bLangInfo= 1;
int	bLoadFonts= 1;
int	bLoadAuto= 1;

int	PASCAL WinMain (hInstance, hPrevInstance, lpCmdLine, nCmdShow)
	HANDLE hInstance;
	HANDLE hPrevInstance;
	LPSTR lpCmdLine;
	int nCmdShow;
	{
	MSG	msg;
	FARPROC	lpfnProc;
	HWND	hWnd;
	/*
	if (!hPrevInstance)
		if (!InitApplication (hInstance))
			return FALSE;
	*/
	/*
	if (!InitInstance(hInstance, nCmdShow))
		return FALSE;
	*/
	hInst= hInstance;
	lpfnProc= MakeProcInstance (MainWndProc, hInst);
	hWnd= CreateDialog (hInst, "MAINOPTS", NULL, lpfnProc);
//	SetMenu (hWnd, LoadMenu (hInst, szCwInst));

	hWait= LoadCursor (NULL, IDC_WAIT);
	hArrow= LoadCursor (NULL, IDC_ARROW);

	SetClassWord (hWnd, GCW_HCURSOR, NULL);

	while (GetMessage (&msg, NULL, NULL, NULL))
		{
		if (!IsDialogMessage (hWnd, &msg))
			{
			TranslateMessage (&msg);
			DispatchMessage (&msg);
			}
		}
//	while (GetMessage ((LPMSG) &msg, NULL, 0, 0) && !IsDialogMessage(hWnd, &msg))
//		DispatchMessage ((LPMSG) &msg);

#ifdef	_Trace_
	DestroyDebugWindow ();
#endif

	FreeProcInstance (lpfnProc);
	return msg.wParam;
	}

//
//	main window procedure (new version)
//
BOOL	FAR PASCAL MainWndProc (hWnd, wMsg, wParam, lParam)
	register HWND hWnd;
	register WORD wMsg;
	WORD	wParam;
	LONG	lParam;
	{
	FARPROC	lpfnAbout;
	int	cwInst (HWND);
	int	cwDefaults (HWND);
	BOOL	bUninstall (HWND);
	HMENU	hSysMenu;

	switch (wMsg)
		{
	case WM_SYSCOMMAND:
		if (wParam == 101)
			{
			lpfnAbout = MakeProcInstance(About, hInst);
			DialogBox (hInst, (LPSTR) "About", hWnd, lpfnAbout);
			FreeProcInstance(lpfnAbout);
			}
		return DefWindowProc(hWnd, wMsg, wParam, lParam);

	case WM_DESTROY:
		PostQuitMessage (0);
		break;
	case WM_INITDIALOG:
		SendMessage (-1, WM_ALTKEYBKILL, 0, 0L);
		if (!cwDefaults (hWnd))
			{
			MessageBox (hWnd, "Error initializing installation procedure", szTitle, MB_ICONSTOP|MB_OK);
			PostMessage (hWnd, WM_DESTROY, 0, 0L);
			return FALSE;
			}
		CheckDlgButton (hWnd, IDM_REPLACE, bInstallSys);
		CheckDlgButton (hWnd, IDM_REPLACELANG, bLangInfo);
		CheckDlgButton (hWnd, IDM_AUTO, bLoadAuto);
		CheckDlgButton (hWnd, IDM_REPLACEORIG, bCommentFonts);
		if (bLoadFonts)
			CheckRadioButton (hWnd, IDM_LOADCYR, IDM_DONTLOADCYR, IDM_LOADCYR);
		else
			CheckRadioButton (hWnd, IDM_LOADCYR, IDM_DONTLOADCYR, IDM_DONTLOADCYR);
		EnableWindow (GetDlgItem (hWnd, IDM_REPLACEORIG), bLoadFonts);
		hSysMenu = GetSystemMenu(hWnd, 0);
		AppendMenu(hSysMenu, MF_SEPARATOR, -1, NULL);
		AppendMenu(hSysMenu, MF_STRING, 101,
			(LPSTR) "&About CyrWin installation...");
		return TRUE;
	case WM_COMMAND:
		switch (wParam)
			{
		case IDD_HELP:
			WinHelp (hWnd, "CWINST.HLP", HELP_INDEX, NULL);
			break;
		case IDM_REPLACE:
			bInstallSys^= 1;
			CheckDlgButton (hWnd, IDM_REPLACE, bInstallSys);
			break;
		case IDM_REPLACELANG:
			bLangInfo^= 1;
			CheckDlgButton (hWnd, IDM_REPLACELANG, bLangInfo);
			break;
		case IDM_AUTO:
			bLoadAuto^= 1;
			CheckDlgButton (hWnd, IDM_AUTO, bLoadAuto);
			break;
		case IDM_LOADCYR:
			bLoadFonts= 1;
			if (bLoadFonts)
				CheckRadioButton (hWnd, IDM_LOADCYR, IDM_DONTLOADCYR, IDM_LOADCYR);
			else
				CheckRadioButton (hWnd, IDM_LOADCYR, IDM_DONTLOADCYR, IDM_DONTLOADCYR);
			EnableWindow (GetDlgItem (hWnd, IDM_REPLACEORIG), bLoadFonts);
			break;
		case IDM_DONTLOADCYR:
			bLoadFonts= 0;
			if (bLoadFonts)
				CheckRadioButton (hWnd, IDM_LOADCYR, IDM_DONTLOADCYR, IDM_LOADCYR);
			else
				CheckRadioButton (hWnd, IDM_LOADCYR, IDM_DONTLOADCYR, IDM_DONTLOADCYR);
			EnableWindow (GetDlgItem (hWnd, IDM_REPLACEORIG), bLoadFonts);
			break;
		case IDM_REPLACEORIG:
			bCommentFonts^= 1;
			CheckDlgButton (hWnd, IDM_REPLACEORIG, bCommentFonts);
			break;
		case IDM_UNINSTALL:
			if (bUninstall (hWnd))
				{
				MessageBox (hWnd, "CyrWin files was removed from Windows directory\nwin.ini and system.ini files was restored", szTitle, MB_OK|MB_ICONEXCLAMATION);
				PostMessage (hWnd, WM_DESTROY, 0, 0L);
				}
			break;
		case IDOK:
			SetCursor (hWait);
			if (cwInst (hWnd))
				{
				MessageBox (hWnd, "CyrWin was sucessfully installed on your computer", szTitle, MB_ICONINFORMATION);
				ExitWindows (0L, 0);
				}
			else
				{
				MessageBox (hWnd, "Installation failed\nTry again", szTitle, MB_ICONSTOP|MB_OK);
				}
			SetCursor (hArrow);
			break;
		case IDCANCEL:
			PostQuitMessage (0);
			break;
			}
		}
	return FALSE;
	}


BOOL	FAR PASCAL About (hDlg, wMsg, wParam, lParam)
	register HWND hDlg;
	register WORD wMsg;
	WORD	wParam;
	LONG	lParam;
	{
	switch (wMsg)
		{
	case WM_INITDIALOG:
		return TRUE;

	case WM_COMMAND:
		EndDialog (hDlg, TRUE);
		return TRUE;
		}
	return FALSE;
	}
