#include "c:\windev\include\dos.h"
#include "c:\windev\include\bios.h"
#include "c:\windev\include\memory.h"

//#define _TRACE_

#define	SecSize 512
#define	SectorId 0x55

#pragma	check_stack (off)

static	unsigned char SecTable []= {
	79, 1,  1, 2,
	79, 1,  2, 2,
	79, 1,  3, 2,
	79, 1,  4, 2,
	79, 1,  SectorId, 2,
	79, 1,  6, 2,
	79, 1,  7, 2,
	79, 1,  8, 2,
	79, 1,  9, 2,
	79, 1, 10, 2,
	79, 1, 11, 2,
	79, 1, 12, 2,
	79, 1, 13, 2,
	79, 1, 14, 2,
	79, 1, 15, 2
	};

int	makedisk (int serialno, short drive, int ninsts);
int	checkdsk (short drive);
extern	unsigned BiosSum (void);

static	struct
	{
	int	serialId;
	int	installed;
	unsigned bioschk;
	char	reserved [SecSize-6];
	} Sector;

//
//	write copyright information to disk (serial number);
//
int	makedisk (int serialno, short drive, int ninsts)
	{
	short retval;
	char *iobuf= (char*) &Sector;

	memset ((char*) &Sector, 0, SecSize);
	Sector.serialId= serialno;
	Sector.installed= ninsts;
	Sector.bioschk= 0x1234;
	_asm
		{
		push	es
		mov	ax, ds
		mov	es, ax
		}
	_asm
		{
		xor	ah, ah
		int	13h
		mov	ax, 1703h
		mov	dl, byte ptr drive
		int	13h
		jc	wfail
		mov	dl, byte ptr drive	// drive number
		mov	dh, 1			// head number
		mov	ch, 79			// track number
		mov	al, 15			// number of sectors
		mov	ah, 5			// format track
		mov	bx, offset SecTable	// addr. fields for track
		int	13h
		jc	wfail
		mov	dl, byte ptr drive	// drive number
		mov	dh, 1			// head number
		mov	ch, 79			// track number
		mov	cl, SectorId		// sector number
		mov	al, 1			// number of sectors
		mov	bx, iobuf		// io buffer address
		mov	ah, 3			// write sector
		int	13h
		jc	wfail
		xor	ax, ax
		jmp	short wdone
	wfail:	mov	ax, -1
	wdone:	mov	retval, ax
		}
	return retval;
	}

//
//	check copyright information, decrement installation counter
//	if first installlation, write BIOS checksumm value
//
int	checkdsk (short drive)
	{
	short retval;
	char *iobuf= (char*) &Sector;

	_asm
		{
		mov	dl, byte ptr drive	// drive number
		mov	dh, 1			// head number
		mov	ch, 79			// track number
		mov	cl, SectorId		// sector number
		mov	al, 1			// number of sectors
		mov	bx, iobuf		// io buffer address
		mov	ah, 2			// write sector
		int	13h
		jc	rfail
		xor	ax, ax
		jmp	short rdone
	rfail:	mov	ax, -2
	rdone:	mov	retval, ax
		}
	if (!retval)
		{
		if (Sector.installed)
			{
			Sector.installed--;
			_asm
				{
				mov	dl, byte ptr drive
				mov	dh, 1
				mov	ch, 79
				mov	cl, SectorId
				mov	al, 1
				mov	bx, iobuf
				mov	ah, 3
				int	13h
				jc	wfail
				xor	ax, ax
				jmp	short wdone
			wfail:	mov	ax, -3
			wdone:	mov	retval, ax
				}
			return retval;
			}
		else
			return 1;
		}
	}
