/****************************************************************************
  
    IntlDemo   version 1.0
  
****************************************************************************/

#define NOCOMM

#include <windows.h>
#include <time.h>
#include <stdlib.h>
#include "intl.h"
#include "intldemo.h"
#include "demo.h"

#define DEMO_GETDATE      WM_USER
#define DEMO_GETTIME      WM_USER+1
#define DEMO_GETFLOAT     WM_USER+2
#define DEMO_GETCURRENCY  WM_USER+3


char		szIniFile[] = "intldemo.ini";

static HANDLE	hInst;
static HWND	hIntlDemoDialog;
static HWND	hIntlLanguageDialog;
static FARPROC	lpSendWinIniChange;
static char	szDlgBoxStrings[IDS_CURRENCY - IDS_DATE + 2][20];
static char	lpszLanguage[10];
static char	language[10];

BOOL FAR PASCAL About(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
    char string[40], szTmp[40], sDecimal[4];
    WORD wVersion;
    int  nCount;

    switch (message) {
    case WM_INITDIALOG:
	GetWindowText(hDlg, string, sizeof string);
	IntlGetPhrase(szTmp, sizeof szTmp, szIniFile, string);
	SetWindowText(hDlg, szTmp);
	for (nCount = 0; nCount <= IDS_USINGVER - IDS_INTLDEMO; nCount++) {
	    GetDlgItemText(hDlg, IDS_INTLDEMO + nCount, string, sizeof string);
	    IntlGetPhrase(szTmp, (int)sizeof szTmp, szIniFile, string);
	    SetDlgItemText(hDlg, IDS_INTLDEMO + nCount, szTmp);
	}
	wVersion = IntlVersion();
	GetProfileString("intl", "sDecimal", ".", sDecimal, sizeof(sDecimal));
	wsprintf((LPSTR)string, "%d%s%1.1d", HIBYTE(DEMOVERSION), (LPSTR)sDecimal, LOBYTE(DEMOVERSION));
	SetDlgItemText(hDlg, IDS_DEMOVER, string);
	wsprintf((LPSTR)string, "%d%s%d", HIBYTE(wVersion), (LPSTR)sDecimal, LOBYTE(wVersion));
	SetDlgItemText(hDlg, IDS_DLLVER, string);
	return TRUE;
    case WM_COMMAND:
	if (wParam == IDOK || wParam == IDCANCEL) {
	    EndDialog(hDlg, TRUE);
	    return TRUE;
	}
	break;
    }
    return FALSE;
}

static LPSTR FAR PASCAL AnsiInsert(LPSTR lpStr1, int nPos, LPSTR lpStr2)
{
    static char	 temp[256];
    LPSTR	 lpPos;
    int		 i;

    lpPos = lpStr1;
    for (i = 0; i < nPos; ++i)
	lpPos = AnsiNext(lpPos);
    lstrcpy(temp, lpPos);
    lstrcpy(lpPos, lpStr2);
    lstrcat(lpStr1, (LPSTR) temp);
    return lpStr1;
}


BOOL FAR PASCAL SendWinIniChange(HWND hWnd, DWORD lParam)
{
    PostMessage(hWnd, WM_WININICHANGE, NULL, lParam);
    return TRUE;
}

void TranslateMenu(HMENU hMenu)
{
    int iCount, nItems, nIndex;
    WORD wMenuItemState, wMenuItemID;
    char lpszMenuItemString[80], lpszNewMenuItemString[80], lpszEnding[80], lpAccelerators[30];
    LPSTR p1, p2;

    nItems = GetMenuItemCount(hMenu);
    if (nItems != -1)
	for (iCount = 0; iCount < nItems; iCount++) {
	    wMenuItemState = GetMenuState(hMenu, iCount, MF_BYPOSITION);
	    if (wMenuItemState & MF_POPUP) {
		wMenuItemState &= 0x00ff;
		wMenuItemID = GetSubMenu(hMenu, iCount);
		TranslateMenu(wMenuItemID);
	    } else
		wMenuItemID = GetMenuItemID(hMenu, iCount);
	    GetMenuString(hMenu,
			  iCount,
			  (LPSTR)lpszMenuItemString,
			  sizeof(lpszMenuItemString),
			  MF_BYPOSITION);
	    p1 = p2 = (LPSTR)lpszMenuItemString;
	    while (*p1 && *p1 != '\t') {
		*p2 = *p1;
		if (*(p1++) != '&')
		    *p2++;
	    }
	    *p2 = '\0';
	    lstrcpy((LPSTR)lpszEnding, p1);
	    IntlGetPhrase((LPSTR)lpszNewMenuItemString,
			  sizeof(lpszNewMenuItemString),
			  szIniFile,
			  (LPSTR)lpszMenuItemString);
	    lstrcat(lpszNewMenuItemString, lpszEnding);
	    p1 = (LPSTR)lpszNewMenuItemString;
	    do {
		nIndex = 0;
		while (nIndex < iCount && lpAccelerators[nIndex] != *p1)
		    nIndex++;
		if (nIndex == iCount) {
		    lpAccelerators[nIndex] = *p1;
		    AnsiInsert(p1, 0, (LPSTR)"&");
		} else
		    p1++;
	    } while (nIndex != iCount);
	    ModifyMenu(hMenu,
		       iCount,
		       MF_BYPOSITION | wMenuItemState,
		       wMenuItemID,
		       (LPSTR)lpszNewMenuItemString);
	}
}

BOOL FAR PASCAL CountryDialog(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
    static char rambling[1024], local[255];
    static WORD count;

    switch (wMsg) {
    case WM_COMMAND:
	switch (wParam) {
	case IDOK:
	    if (count == IDR_OTHER)
		GetDlgItemText(hDlg, IDE_OTHER, local, sizeof local);
	    else
		LoadString(hInst, count, local, sizeof local);
	    WriteProfileString("INTL", "sLanguage", local);

	    /* Tell everyone that win.ini just changed */
	    EnumWindows(lpSendWinIniChange, (DWORD)(LPSTR)"intl");
	case IDCANCEL:
	    EndDialog(hDlg, TRUE);
	    return TRUE;
	case IDR_DAN:
	case IDR_DUT:
	case IDR_ENG:
	case IDR_FCF:
	case IDR_FIN:
	case IDR_FRN:
	case IDR_GER:
	case IDR_ICE:
	case IDR_ITN:
	case IDR_NOR:
	case IDR_POR:
	case IDR_SPA:
	case IDR_SWE:
	case IDR_USA:
	case IDR_OTHER:
	    count = wParam;
	    return TRUE;
	default:
	    return FALSE;
	}
    case WM_INITDIALOG:
	for (count = IDR_DAN; count <= IDR_OTHER; count++) {
	    GetDlgItemText(hDlg, count, local, sizeof local);
	    IntlGetPhrase((LPSTR)rambling, sizeof rambling, szIniFile, (LPSTR)local);
	    SetDlgItemText(hDlg, count, rambling);
	}
	GetDlgItemText(hDlg, IDG_LANGUAGE, local, sizeof local);
	IntlGetPhrase((LPSTR)rambling, sizeof rambling, szIniFile, (LPSTR)local);
	SetDlgItemText(hDlg, IDG_LANGUAGE, rambling);
	GetDlgItemText(hDlg, IDOK, local, sizeof local);
	IntlGetPhrase((LPSTR)rambling, sizeof rambling, szIniFile, (LPSTR)local);
	SetDlgItemText(hDlg, IDOK, rambling);
	GetDlgItemText(hDlg, IDCANCEL, local, sizeof local);
	IntlGetPhrase((LPSTR)rambling, sizeof rambling, szIniFile, (LPSTR)local);
	SetDlgItemText(hDlg, IDCANCEL, rambling);
	IntlGetMessage(rambling, sizeof rambling, szIniFile, "language info");
	SetDlgItemText(hDlg, IDS_RAMBLE, rambling);
	count = IDR_DAN;
	do {
	    LoadString(hInst, count, (LPSTR)local, sizeof local);
	} while (count++ < IDR_OTHER && lstrcmp(language, local));
	--count;
	CheckRadioButton(hDlg, IDR_DAN, IDR_OTHER, count);
	if (count == IDR_OTHER)
	    SetDlgItemText(hDlg, IDE_OTHER, language);
	return TRUE;
    }
    return FALSE;
}

long FAR PASCAL MainWndProc(HWND hWnd, unsigned message, WORD wParam, LONG lParam)
{
    static FARPROC	lpProcAbout;
    static FARPROC	lpProcCountry;
    char		szString[256], rambling[1024];
    HMENU		hMenu, hOldMenu;
    char		szTmp[128];
    static struct tm	tm = {0, 0, 0, 1, 0, 0, 0, 0, 0};
    double		val, val2;
    int			nCount;

    switch (message) {
    case WM_GETMINMAXINFO:

    case WM_COMMAND:
	switch (wParam) {
	case IDM_ABOUT:
	    lpProcAbout = MakeProcInstance(About, hInst);
	    DialogBox(hInst, "AboutBox", hWnd, lpProcAbout);
	    FreeProcInstance(lpProcAbout);
	    return TRUE;
	case IDM_LANGUAGE:
	    lpProcCountry = MakeProcInstance(CountryDialog, hInst);
	    DialogBox(hInst, "COUNTRY", hWnd, lpProcCountry);
	    FreeProcInstance(lpProcCountry);
	    return TRUE;
	default:
	    return (DefWindowProc(hWnd, message, wParam, lParam));
	}
	break;
    case WM_CREATE:
	if (!IntlInit(language)) {
	    MessageBox(hWnd, "Couldn't initiate the internationalizing DLL", "IntlDemonstration: Error!", MB_ICONSTOP | MB_OK);
	    PostMessage(hWnd, WM_DESTROY, 0, 0L);
	    return TRUE;
	}
	if (HIBYTE(IntlVersion()) < 1) {
	    MessageBox(hWnd, "You're using a beta version of INTL.DLL. Use the new one instead", "IntlDemonstration: Error!", MB_ICONSTOP | MB_OK);
	    PostMessage(hWnd, WM_DESTROY, 0, 0L);
	    return TRUE;
	}
	*rambling='\0';
	for (nCount = 0; nCount < 3; nCount++) {
	    LoadString(hInst, nCount, (LPSTR)szString, sizeof szString);
	    lstrcat(rambling, szString);
	}
	if (!*language) {
	    if (MessageBox(hWnd,rambling, "Intl Demonstration: Missing language information", MB_ICONINFORMATION | MB_YESNO) == IDYES) {
		lpProcCountry = MakeProcInstance(CountryDialog, hInst);
		DialogBox(hInst, "COUNTRY", hWnd, lpProcCountry);
		FreeProcInstance(lpProcCountry);
	    }
	} else {
	    IntlGetMessage(szString, (int)sizeof szString, szIniFile, "sLanguage luck");
	    MessageBox(hWnd, szString,"sLanguage", MB_ICONINFORMATION | MB_OK);
	}
	return TRUE;
    case WM_DESTROY:
	PostQuitMessage(0);
	return TRUE;
    case WM_WININICHANGE:
	if (lParam == NULL || !lstrcmp((LPSTR) lParam, "intl")) {
	    GetDlgItemText(hIntlDemoDialog, IDE_DATE, szString, 24);
	    IntlStringToDate(szString, &tm.tm_year, &tm.tm_mon, &tm.tm_mday, NULL);
	    GetDlgItemText(hIntlDemoDialog, IDE_TIME, szString, 24);
	    IntlStringToTime(szString, &tm.tm_hour, &tm.tm_min, &tm.tm_sec, NULL);
	    GetDlgItemText(hIntlDemoDialog, IDE_FLOAT, szString, 24);
	    val = IntlStringToFloat(szString, NULL);
	    GetDlgItemText(hIntlDemoDialog, IDE_CURRENCY, szString, 24);
	    val2 = IntlStringToFloat(szString, NULL);
	    mktime(&tm);
	    IntlInit(lpszLanguage);
	    SetDlgItemText(hIntlDemoDialog, IDE_DATE, IntlDateToString(szString, tm.tm_year, tm.tm_mon, tm.tm_mday, tm.tm_wday, IntlSHORT));
	    SetDlgItemText(hIntlDemoDialog, IDE_TIME, IntlTimeToString(szString, tm.tm_hour, tm.tm_min, tm.tm_sec));
	    SetDlgItemText(hIntlDemoDialog, IDE_FLOAT,IntlFloatToString(szString, val, IntlSTD, 24, IntlDEFAULT));
	    SetDlgItemText(hIntlDemoDialog, IDE_CURRENCY, IntlFloatToString(szString, val2, IntlSTD, 24, IntlDEFAULT));
	    if (lstrcmp(lpszLanguage, language)) {
		lstrcpy(language, lpszLanguage);
		for (nCount = 0; nCount <= IDS_CURRENCY - IDS_DATE; nCount++) {
		    IntlGetPhrase(szTmp, (int)sizeof szTmp, szIniFile, szDlgBoxStrings[nCount]);
		    SetDlgItemText(hIntlDemoDialog, IDS_DATE+nCount, szTmp);
		}
		IntlGetPhrase(szTmp, (int)sizeof szTmp, szIniFile, szDlgBoxStrings[IDS_CURRENCY - IDS_DATE + 1]);
		SetDlgItemText(hIntlDemoDialog, IDR_DEFAULT, szTmp);
		if (hMenu = LoadMenu(hInst,"IntlDemoMenu")) {
		    hOldMenu = GetMenu(hWnd);
		    DestroyMenu(hOldMenu);
		    TranslateMenu(hMenu);
		    SetMenu(hWnd, hMenu);
		}
	    }
	    PostMessage(hIntlDemoDialog, DEMO_GETDATE, 0, 0L);
	    PostMessage(hIntlDemoDialog, DEMO_GETTIME, 0, 0L);
	    PostMessage(hIntlDemoDialog, DEMO_GETFLOAT, 0, 0L);
	    PostMessage(hIntlDemoDialog, DEMO_GETCURRENCY, 0, 0L);
	}
	return TRUE;
    default:
	return (DefWindowProc(hWnd, message, wParam, lParam));
    }
}


BOOL FAR PASCAL IntlDemoDialog(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
    static char 	String[25];
    static int		width, hms, decimals;
    LPSTR		end;
    static struct tm	tm = {0, 0, 0, 1, 0, 0, 0, 0, 0};
    struct tm		*tim;
    time_t		timer;
    double		val;
    int			nCount;
    BOOL		bOk;

    switch (wMsg) {
    case WM_COMMAND:
	switch (wParam) {
	case IDE_DATE:
	    if (HIWORD(lParam) == EN_CHANGE) {
		PostMessage(hDlg, DEMO_GETDATE, 0, 0L);
		return TRUE;
	    }
	    break;
	case IDE_TIME:
	    if (HIWORD(lParam) == EN_CHANGE) {
		PostMessage(hDlg, DEMO_GETTIME, 0, 0L);
		return TRUE;
	    }
	    break;
	case IDE_FLOAT:
	    if (HIWORD(lParam) == EN_CHANGE) {
		PostMessage(hDlg, DEMO_GETFLOAT, 0, 0L);
		return TRUE;
	    }
	    break;
	case IDE_CURRENCY:
	    if (HIWORD(lParam) == EN_CHANGE) {
		PostMessage(hDlg, DEMO_GETCURRENCY, 0, 0L);
		return TRUE;
	    }
	    break;
	case IDE_FLOATWIDTH:
	    if (HIWORD(lParam) == EN_CHANGE) {
		GetDlgItemText(hDlg, IDE_FLOATWIDTH, (LPSTR) String, 20);
		width = atoi(String);
		PostMessage(hDlg, DEMO_GETFLOAT, 0, 0L);
		PostMessage(hDlg, DEMO_GETCURRENCY, 0, 0L);
	    }
	    return TRUE;
	case IDE_DECIMALS:
	    if (HIWORD(lParam) == EN_CHANGE && IsDlgButtonChecked(hDlg, IDR_DECIMALS)) {
		decimals = GetDlgItemInt(hDlg, IDE_DECIMALS, &bOk, TRUE);
		if (!bOk) {
		    decimals = IntlDEFAULT;
		    CheckRadioButton(hDlg, IDR_DEFAULT, IDR_DECIMALS, IDR_DEFAULT);
		}
		PostMessage(hDlg, DEMO_GETFLOAT, 0, 0L);
		PostMessage(hDlg, DEMO_GETCURRENCY, 0, 0L);
	    }
	    return TRUE;
	case IDR_H:
	case IDR_HM:
	case IDR_HMS:
	    hms = wParam;
	    CheckRadioButton(hDlg, IDR_H, IDR_HMS, wParam);
	    PostMessage(hDlg, DEMO_GETTIME, 0, 0L);
	    return TRUE;
	case IDR_DECIMALS:
	case IDR_DEFAULT:
	    CheckRadioButton(hDlg, IDR_DEFAULT, IDR_DECIMALS, wParam);
	    decimals = wParam == IDR_DEFAULT ? IntlDEFAULT
					     : (int)GetDlgItemInt(hDlg, IDE_DECIMALS, (BOOL FAR *)&bOk, TRUE);
	    if (!bOk)
		decimals = IntlDEFAULT;
	    PostMessage(hDlg, DEMO_GETFLOAT, 0, 0L);
	    PostMessage(hDlg, DEMO_GETCURRENCY, 0, 0L);
	    return TRUE;
	}
	return TRUE;
    case WM_INITDIALOG:
	for (nCount = 0; nCount <= IDS_CURRENCY - IDS_DATE; nCount++) {
	    GetDlgItemText(hDlg, IDS_DATE+nCount, szDlgBoxStrings[nCount], sizeof szDlgBoxStrings[0]);
	    IntlGetPhrase(String, sizeof String, szIniFile, szDlgBoxStrings[nCount]);
	    SetDlgItemText(hDlg, IDS_DATE+nCount, String);
	}
	GetDlgItemText(hDlg, IDR_DEFAULT, szDlgBoxStrings[IDS_CURRENCY - IDS_DATE + 1], sizeof szDlgBoxStrings[0]);
	IntlGetPhrase(String, sizeof String, szIniFile, szDlgBoxStrings[IDS_CURRENCY - IDS_DATE + 1]);
	SetDlgItemText(hDlg, IDR_DEFAULT, String);
	time(&timer);
	tim = localtime(&timer);
	tm = *tim;
	SetDlgItemText(hDlg, IDE_DATE, IntlDateToString(String,
							tim->tm_year,
							tim->tm_mon,
							tim->tm_mday,
							tim->tm_wday,
							IntlSHORT));
	SetDlgItemText(hDlg, IDE_TIME, IntlTimeToString(String,
							tim->tm_hour,
							tim->tm_min,
							tim->tm_sec));

	SetDlgItemText(hDlg, IDE_FLOATWIDTH, "12");
	CheckRadioButton(hDlg, IDR_DEFAULT, IDR_DECIMALS, IDR_DEFAULT);
	CheckRadioButton(hDlg, IDR_H, IDR_HMS, IDR_HMS);
	width = 12;
	decimals = IntlDEFAULT;
	return TRUE;
    case DEMO_GETDATE:
	GetDlgItemText(hDlg, IDE_DATE, (LPSTR) String, 24);
	if (IntlStringToDate(String, &tm.tm_year, &tm.tm_mon, &tm.tm_mday, &end)) {
	    mktime(&tm);
	    SendDlgItemMessage(hDlg,
			       IDS_DATESHORT,
			       WM_SETTEXT,
			       0,
			       (DWORD)IntlDateToString(String,
						       tm.tm_year,
						       tm.tm_mon,
						       tm.tm_mday,
						       tm.tm_wday,
						       IntlSHORT));
	    SendDlgItemMessage(hDlg,
			       IDS_DATELONG,
			       WM_SETTEXT,
			       0,
			       (DWORD)IntlDateToString(String,
						       tm.tm_year,
						       tm.tm_mon,
						       tm.tm_mday,
						       tm.tm_wday,
						       IntlLONG));
	}
	return TRUE;
    case DEMO_GETTIME:
	GetDlgItemText(hDlg, IDE_TIME, (LPSTR) String, 24);
	if (IntlStringToTime(String, &tm.tm_hour, &tm.tm_min, &tm.tm_sec, &end)) {
	    mktime(&tm);
	    SendDlgItemMessage(hDlg,
			       IDS_TIME,
			       WM_SETTEXT,
			       0,
			       (DWORD)IntlTimeToString(String,
						       tm.tm_hour,
						       hms == IDR_H ? IntlSKIP
								    : tm.tm_min,
						       hms == IDR_HM ? IntlSKIP
								     : tm.tm_sec));
	}
	return TRUE;
    case DEMO_GETFLOAT:
	GetDlgItemText(hDlg, IDE_FLOAT, (LPSTR) String, 24);
	val = IntlStringToFloat(String, &end);
	SendDlgItemMessage(hDlg,
			   IDS_FLOATFIX,
			   WM_SETTEXT,
			   0,
			   (DWORD) IntlFloatToString((LPSTR)String,
						     val,
						     IntlFIX,
						     width,
						     decimals));
	SendDlgItemMessage(hDlg,
			   IDS_FLOATSTD,
			   WM_SETTEXT,
			   0,
			   (DWORD) IntlFloatToString((LPSTR)String,
						     val,
						     IntlSTD,
						     width,
						     decimals));
	SendDlgItemMessage(hDlg,
			   IDS_FLOATSCI,
			   WM_SETTEXT,
			   0,
			   (DWORD) IntlFloatToString((LPSTR)String,
						     val,
						     IntlSCI,
						     width,
						     decimals));
	SendDlgItemMessage(hDlg,
			   IDS_FLOATENG,
			   WM_SETTEXT,
			   0,
			   (DWORD) IntlFloatToString((LPSTR)String,
						     val,
						     IntlENG,
						     width,
						     decimals));
	SendDlgItemMessage(hDlg,
			   IDS_FLOATPRE,
			   WM_SETTEXT,
			   0,
			   (DWORD) IntlFloatToString((LPSTR)String,
						     val,
						     IntlPRE,
						     width,
						     decimals));
	return TRUE;
    case DEMO_GETCURRENCY:
	GetDlgItemText(hDlg, IDE_CURRENCY, (LPSTR) String, 24);
	val = IntlStringToFloat(String, &end);
	SendDlgItemMessage(hDlg,
			   IDS_CURRENCYSTD,
			   WM_SETTEXT,
			   0,
			   (DWORD) IntlCurrencyToString((LPSTR)String,
							val,
							IntlSTD,
							width,
							decimals));
	SendDlgItemMessage(hDlg,
			   IDS_CURRENCYFIX,
			   WM_SETTEXT,
			   0,
			   (DWORD) IntlCurrencyToString((LPSTR)String,
							val,
							IntlFIX,
							width,
							decimals));
	SendDlgItemMessage(hDlg,
			   IDS_CURRENCYSCI,
			   WM_SETTEXT,
			   0,
			   (DWORD) IntlCurrencyToString((LPSTR)String,
							val,
							IntlSCI,
							width,
							decimals));
	SendDlgItemMessage(hDlg,
			   IDS_CURRENCYENG,
			   WM_SETTEXT,
			   0,
			   (DWORD) IntlCurrencyToString((LPSTR)String,
							val,
							IntlENG,
							width,
							decimals));
	SendDlgItemMessage(hDlg,
			   IDS_CURRENCYPRE,
			   WM_SETTEXT,
			   0,
			   (DWORD) IntlCurrencyToString((LPSTR)String,
							 val,
							 IntlPRE,
							 width,
							 decimals));
	return TRUE;
    }
    return FALSE;
}

BOOL            InitApplication(HANDLE hInstance)
{
    WNDCLASS	wc;

    lpSendWinIniChange=MakeProcInstance(SendWinIniChange, hInstance);
    wc.style = CS_BYTEALIGNCLIENT;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(hInstance, "worldicon");
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName = "IntlDemoMenu";
    wc.lpszClassName = "IntlDemoWClass";

    return RegisterClass(&wc);
}

BOOL            InitInstance(HANDLE hInstance, int nCmdShow)
{
    HWND	hWnd;
    HMENU	hMenu;
    RECT	rectDialog, rectWindow;

    hInst = hInstance;

    hWnd = CreateWindow("IntlDemoWClass",
			"Intl Demo",
			WS_BORDER | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX,
			CW_USEDEFAULT,
			CW_USEDEFAULT,
			CW_USEDEFAULT,
			CW_USEDEFAULT,
			NULL,
			NULL,
			hInstance,
			NULL);

    if (!hWnd)
	return FALSE;

    if (hMenu = GetMenu(hWnd))
	TranslateMenu(hMenu);

    hIntlDemoDialog = CreateDialog(hInstance,
				   "IntlDemoDialog",
				   hWnd,
				   MakeProcInstance(IntlDemoDialog, hInstance));

    if (!hIntlDemoDialog)
	return FALSE;

    GetWindowRect(hIntlDemoDialog, &rectDialog);
    GetWindowRect(hWnd, &rectWindow);

    MoveWindow(hWnd,
	       rectWindow.left,
	       rectWindow.top,
	       rectDialog.right - rectDialog.left + 2*GetSystemMetrics(SM_CXBORDER),
	       rectDialog.bottom-rectDialog.top + 2*GetSystemMetrics(SM_CYBORDER) + GetSystemMetrics(SM_CYMENU) + GetSystemMetrics(SM_CYCAPTION),
	       FALSE);
    ShowWindow(hWnd, nCmdShow);
    return TRUE;
}

int PASCAL      WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    MSG		msg;

    if (!hPrevInstance)
	if (!InitApplication(hInstance))
	    return FALSE;

    if (!InitInstance(hInstance, nCmdShow))
	return FALSE;


    while (GetMessage(&msg, NULL, NULL, NULL)) {
	if (!IsDialogMessage(hIntlDemoDialog, &msg)) {
	    TranslateMessage(&msg);
	    DispatchMessage(&msg);
	}
    }
    return msg.wParam;
}
