#ifndef	WINDOW_INC
#define	WINDOW_INC

#include "winobj.hpp"

extern "C" {
LONG CALLBACK CPPWinProc(HWND, UINT, UINT, LONG);
}

#define WM_USER_DELETE 	WM_USER+0x300
#define WM_USER_DESTROY	WM_USER+0x301

class Event {

public:
UINT wParam;
LONG lParam;

Event(UINT w, LONG l) {wParam=w; lParam=l;};
}; // class Event

typedef struct {
  int RepeatCount:16,
      ScanCode:8,
      fExtended:1,
      reserved1:4,
      fAlt:1,
      fPrev:1,
      fTransition:1;
} KEYCODES;


class Window: public  WinObj	{
protected :
//#ifdef WIN32
//  WNDPROC DefaultHandler;
//  static WNDPROC Handler;
//#else
  FARPROC DefaultHandler;	// default callback
  static FARPROC Handler;	// proc instance
//#endif
  void SetHandler();
  static HANDLE hAccel;

public:
  Window();			// void constructor
  ~Window();

protected:
  void Create(                  // Create a window
    LPSTR pCaption,             // Caption
    LONG  Style,
    int x,                      // Position
    int y,
    int width,                  // Size
    int height,
    HWND hPwnd,                 // Parent handle
    HMENU hMenu=NULL);

public:	
  Window * HorzScrollBar;
  Window * VertScrollBar;

  HWND hWnd;                    // Window handle

  friend  LONG CALLBACK CPPWinProc(
    HWND hWnd, UINT msg, UINT wParam, LONG lParam);

  virtual int MessageLoop();
  virtual LONG MessageProc(
    HWND hWnd,
    unsigned msg,
    Event& evt);

  virtual LPSTR Register(WNDCLASS& wc);

  void Move(
    RECT *rc,                   // Move the window
    BOOL repaint=TRUE);

  BOOL Show(                    // Show or hide the window
    int nCmdShow=SW_SHOW){
    return ShowWindow(hWnd,nCmdShow);};

  int GetText(                  // Get window text
    LPSTR pBuffer,
    int Size){
    return SendMessage(hWnd,WM_GETTEXT,Size,(LONG)pBuffer);};

  int SetText(                  // Set window text
    LPSTR pBuffer){
    return SendMessage(hWnd,WM_SETTEXT,0,(LONG)pBuffer);};

#ifdef __BORLANDC__
  #pragma warn -par
#endif                          // Virtual event methods
  virtual BOOL  InitMenu(HMENU hMenu)
    {return FALSE;};
  virtual BOOL  QueryClose()
    {return TRUE;};
  virtual BOOL  Size( UINT Width, UINT Height, UINT Type);
  virtual BOOL  Char(UINT Value, UINT Repeat)
    {return FALSE;};
  virtual BOOL  KeyDown(UINT VirtKey, KEYCODES KeyCodes)
    {return FALSE;};
  virtual BOOL  LButtonDown(POINT Cursor, UINT Keys)
    {return FALSE;};
  virtual BOOL  LButtonDblClk(POINT Cursor, UINT Keys)
    {return FALSE;};
  virtual BOOL  MouseMove(POINT Cursor, UINT Keys)
    {return FALSE;};
  virtual BOOL  MouseActivate(HWND hTop, UINT HitTest)
    {return FALSE;};
  virtual BOOL  LButtonUp(POINT Cursor, UINT Keys)
    {return FALSE;};
  virtual BOOL  RButtonDown(POINT Cursor, UINT Keys)
    {return FALSE;};
  virtual BOOL  RButtonUp(POINT Cursor, UINT Keys)
    {return FALSE;};
  virtual BOOL  Paint();
  virtual BOOL  SetFocus (HWND hPrev)
    {return FALSE;};
  virtual BOOL  KillFocus (HWND hNext)
    {return FALSE;};
  virtual BOOL  Command( UINT Id, UINT Code, HWND hControl);
  virtual BOOL  DialogMessage(MSG& msg){return FALSE;};

#ifdef __BORLANDC__
  #pragma warn +par
#endif
}; // class Window

extern void PutWin(HWND hWnd, Window * pWin);
extern Window * GetWin(HWND hWnd);
extern Window * DelWin(HWND hWnd);

#endif // WINDOW_INC
