#include	<windows.h>
#include	<stdio.h>
#include	<iostream.h>
#include	<iomanip.h>
#include	<fstream.h>
#include	<string.h>

ofstream	CERR("results.out", ios::app);
int	BUFLEN = 0x10000;

ostream	& operator << (ostream & os, SYSTEMTIME & r)
{
	static	const char	* const rgszDayNames[] =
		{
		"Sunday",
		"Monday",
		"Tuesday",
		"Wednesday",
		"Thursday",
		"Friday",
		"Saturday",
		0
		};
	char	chFill = os.fill();
	os.fill('0');
	os //--------------------------------- << rgszDayNames[r.wDayOfWeek] << ' '
		<< setw(2) << r.wMonth << '/'
		<< setw(2) << r.wDay << '/'
		<< setw(2) << r.wYear << ' '
		<< setw(2) << r.wHour << ':'
		<< setw(2) << r.wMinute << ':'
		//------------------- << setw(2) << r.wSecond
		;
	os.fill(chFill);
	return	os;
}

void cat(FILE *fp)
{
	char	szBuf[0X10000];
	size_t	nRead;
	while (0 != (nRead = fread(szBuf, 1, sizeof(szBuf), fp)) )
		{
		fwrite(szBuf, nRead, 1, stdout);
		}
}

int main(int argc, char **argv)
{
	if (argc < 2)
		{
		cat(stdin);
		return	0;
		}
	//----------------------------------------------------------------
	SYSTEMTIME	sNow;
	GetLocalTime(&sNow);
	CERR << sNow << "===> " << GetCommandLine() << endl;
	//----------------------------------------------------------------
	DWORD	dwStart = GetTickCount();
	for (int iArg = 1; iArg < argc; iArg++)
		{
		FILE *fp = fopen(argv[iArg], "rb");
		if (0 == fp)
			continue;
		cat(fp);
		fclose(fp);
		}
	dwStart = GetTickCount( ) - dwStart;
 	CERR << "**** Total time: " << (dwStart / 1000)
		<< '.' << (dwStart % 1000) << " seconds."
		<< endl;
	return	0;
}
