#include	<windows.h>
#include	<iostream.h>
#include	<iomanip.h>
#include	<fstream.h>
#include	<string.h>

ofstream	CERR("results.out", ios::app);
int	BUFLEN = 0x10000;

ostream	& operator << (ostream & os, SYSTEMTIME & r)
{
	static	const char	* const rgszDayNames[] =
		{
		"Sunday",
		"Monday",
		"Tuesday",
		"Wednesday",
		"Thursday",
		"Friday",
		"Saturday",
		0
		};
	char	chFill = os.fill();
	os.fill('0');
	os //--------------------------------- << rgszDayNames[r.wDayOfWeek] << ' '
		<< setw(2) << r.wMonth << '/'
		<< setw(2) << r.wDay << '/'
		<< setw(2) << r.wYear << ' '
		<< setw(2) << r.wHour << ':'
		<< setw(2) << r.wMinute << ':'
		//------------------- << setw(2) << r.wSecond
		;
	os.fill(chFill);
	return	os;
}

int main(int argc, char **argv)
{
	if (argc < 2)
		{
		cin.get(*cout.rdbuf(), EOF);
		return	0;
		}
	SYSTEMTIME	sNow;
	GetLocalTime(&sNow);
	CERR << sNow << "===> " << GetCommandLine() << endl;

	char	*pBuf = new char[BUFLEN];
	char	*pOut = new char[BUFLEN];

	ifstream	ifs;
	delete [] ifs.setbuf(pBuf, BUFLEN);

	ofstream	ofs( ((filebuf *)cout.rdbuf())->fd(), pOut, BUFLEN);
	if (!ofs)
		{
		CERR << "Error attaching output stream." << endl;
		}

	DWORD	dwStart = GetTickCount();
	
	for (int iArg = 1; iArg < argc; iArg++)
		{
		ifs.open(argv[iArg], ios::in | ios::binary);
		if (!ifs)
			{
			CERR << "Error opening input file: " << argv[iArg] << endl;
			ifs.clear();
			continue;
			}
		ifs.get(*ofs.rdbuf(), EOF);
		ifs.close();
		}
	ofs.close();
	dwStart = GetTickCount( ) - dwStart;
 	CERR << "**** Total time: " << (dwStart / 1000)
		<< '.' << (dwStart % 1000) << " seconds."
		<< endl;
	delete	[] ifs.setbuf(0,0);
	delete	[] ofs.setbuf(0,0);
	return	0;
}

