/*++

 Copyright Data Connection Ltd. 1992

 semfisel.mc

 NT IBM SDLC Device Driver: Error Logging Strings

--*/

//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//
#define FACILITY_IO_ERROR_CODE           0x0


//
// Define the severity codes
//
#define STATUS_SEVERITY_WARNING          0x2
#define STATUS_SEVERITY_INFORMATIONAL    0x1
#define STATUS_SEVERITY_ERROR            0x0


//
// MessageId: IO_ERR_HARDWARE_INIT_FAILURE
//
// MessageText:
//
//  An error occurred while setting up the default link characteristics.
//
#define IO_ERR_HARDWARE_INIT_FAILURE     0x00000001L

//
// MessageId: IO_ERR_CANT_CONNECT_INTERRUPT_1
//
// MessageText:
//
//  The driver could not connect the required interrupt.
//
#define IO_ERR_CANT_CONNECT_INTERRUPT_1  0x00000002L

//
// MessageId: IO_ERR_CANT_CONNECT_INTERRUPT_2
//
// MessageText:
//
//  The driver could not connect the second required interrupt.
//
#define IO_ERR_CANT_CONNECT_INTERRUPT_2  0x00000003L

//
// MessageId: IO_ERR_SET_EVENT_NO_EVENT
//
// MessageText:
//
//  The event semaphore given to the driver is null.
//
#define IO_ERR_SET_EVENT_NO_EVENT        0x00000004L

//
// MessageId: IO_ERR_HARDWARE_CMD_TIMEOUT_1
//
// MessageText:
//
//  Hardware Error (1) - the 8273 did not respond to a command sequence within the required time while setting V24 output status.
//
#define IO_ERR_HARDWARE_CMD_TIMEOUT_1    0x00000005L

//
// MessageId: IO_ERR_HARDWARE_CMD_TIMEOUT_2
//
// MessageText:
//
//  Hardware Error (2) - the 8273 did not respond to a command sequence within the required time.
//
#define IO_ERR_HARDWARE_CMD_TIMEOUT_2    0x00000006L

//
// MessageId: IO_ERR_HARDWARE_CMD_TIMEOUT_3
//
// MessageText:
//
//  Hardware Error (3) - the 8273 did not respond to a command sequence within the required time while initialising the adapter.
//
#define IO_ERR_HARDWARE_CMD_TIMEOUT_3    0x00000007L

//
// MessageId: IO_ERR_HARDWARE_CMD_TIMEOUT_4
//
// MessageText:
//
//  Hardware Error (4) - the 8273 did not respond to a command sequence within the required time while initialising the adapter.
//
#define IO_ERR_HARDWARE_CMD_TIMEOUT_4    0x00000008L

//
// MessageId: IO_ERR_LINKCHAR_BUF_WRONG_SIZE
//
// MessageText:
//
//  The given link characteristics buffer is the wrong size.
//
#define IO_ERR_LINKCHAR_BUF_WRONG_SIZE   0x00000009L

//
// MessageId: IO_ERR_FRAME_BUF_TOO_BIG
//
// MessageText:
//
//  The given SDLC frame size is too large.
//
#define IO_ERR_FRAME_BUF_TOO_BIG         0x0000000AL

//
// MessageId: IO_ERR_FRAME_BUF_TOO_SMALL
//
// MessageText:
//
//  The given SDLC frame size is too small.
//
#define IO_ERR_FRAME_BUF_TOO_SMALL       0x0000000BL

//
// MessageId: IO_ERR_NO_CLOCKS
//
// MessageText:
//
//  Invalid request - internal clocks are not supported by these adapters.
//
#define IO_ERR_NO_CLOCKS                 0x0000000CL

//
// MessageId: IO_ERR_CANT_ALLOCATE_MDL
//
// MessageText:
//
//  The driver could not allocate an MDL for the DMA buffer.
//
#define IO_ERR_CANT_ALLOCATE_MDL         0x0000000DL

//
// MessageId: IO_ERR_CANT_ALLOCATE_MEMORY
//
// MessageText:
//
//  The driver could not allocate contiguous memory for DMA.
//
#define IO_ERR_CANT_ALLOCATE_MEMORY      0x0000000EL

//
// MessageId: IO_ERR_DMA_BUFFER_UNUSABLE
//
// MessageText:
//
//  The driver could not use the allocated DMA buffer as it crosses a 64K boundary.
//
#define IO_ERR_DMA_BUFFER_UNUSABLE       0x0000000FL

//
// MessageId: IO_ERR_TX_BUFFER_FULL
//
// MessageText:
//
//  The Link Service has attempted to transmit a frame that will not currently fit into the driver's buffer.
//
#define IO_ERR_TX_BUFFER_FULL            0x00000010L

//
// MessageId: IO_ERR_TX_FRAME_TOO_BIG
//
// MessageText:
//
//  The given transmit frame size is too large.
//
#define IO_ERR_TX_FRAME_TOO_BIG          0x00000011L

//
// MessageId: IO_ERR_TX_FRAME_TOO_SMALL
//
// MessageText:
//
//  The given transmit frame size is too small - the minimum frame size is 2.
//
#define IO_ERR_TX_FRAME_TOO_SMALL        0x00000012L

//
// MessageId: IO_ERR_READ_IR_BUFFER_WRONG_SIZE
//
// MessageText:
//
//  The read buffer given to the Read Interface Record call is the wrong size.
//
#define IO_ERR_READ_IR_BUFFER_WRONG_SIZE 0x00000013L

//
// MessageId: IO_ERR_NEEDS_MCA_BUS
//
// MessageText:
//
//  This type of Adapter needs a MCA bus.
//
#define IO_ERR_NEEDS_MCA_BUS             0x00000014L

//
// MessageId: IO_ERR_NEEDS_ISA_BUS
//
// MessageText:
//
//  This type of Adapter needs an Isa or Eisa bus.
//
#define IO_ERR_NEEDS_ISA_BUS             0x00000015L

//
// MessageId: IO_ERR_GET_IF_TYPE_1
//
// MessageText:
//
//  Memory shortage (1) - the driver could not allocate a pool for a Registry Path buffer.
//
#define IO_ERR_GET_IF_TYPE_1             0x00000016L

//
// MessageId: IO_ERR_GET_IF_TYPE_2
//
// MessageText:
//
//  Memory shortage (2) - the driver could not allocate a pool for a Registry Path buffer.
//
#define IO_ERR_GET_IF_TYPE_2             0x00000017L

//
// MessageId: IO_ERR_GET_IF_TYPE_3
//
// MessageText:
//
//  Memory shortage (3) - the driver could not allocate a pool for a Registry Path buffer.
//
#define IO_ERR_GET_IF_TYPE_3             0x00000018L

//
// MessageId: IO_ERR_GET_IF_TYPE_4
//
// MessageText:
//
//  The driver could not query the Registry for the Bus type.
//
#define IO_ERR_GET_IF_TYPE_4             0x00000019L

//
// MessageId: IO_ERR_INVALID_IOCTL_CODE
//
// MessageText:
//
//  The driver does not recognise this IO control code.
//
#define IO_ERR_INVALID_IOCTL_CODE        0x0000001AL

//
// MessageId: IO_ERR_NO_DMA_FDX
//
// MessageText:
//
//  The 8273 cannot support the requested full-duplex DMA transfer mode.
//
#define IO_ERR_NO_DMA_FDX                0x8000001BL

