
/* semfddis.h */

/*****************************************************************************/
/* NT IBM SDLC Adapter Device Driver: IBM SDLC adapter-specific stuff        */
/*                                                                           */
/* Note that this also includes codes for the 8255 registers.  The reason    */
/* for this is that the designation of these bits and the use of the 8255    */
/* is really defined by the SDLC adapter.  This is in contrast to the 8273:  */
/* this has its own definition file because the command codes etc. really    */
/* are a property of the 8273 chip and not of the SDLC adapter.              */
/*****************************************************************************/

/*****************************************************************************/
/* AR_ : offsets to Adapter Registers                                        */
/*****************************************************************************/

#define AR_Max    0x0F   /* Max port in the IO Port range                    */

#define AR_8255A  0x00   /* 8255 register A                                  */
#define AR_8255B  0x01   /* 8255 register B                                  */
#define AR_8255C  0x02   /* 8255 register C                                  */
#define AR_8255   0x03   /* 8255 mode set                                    */

#define AR_8273S  0x08   /* 8273 Command/Status register                     */
#define AR_8273P  0x09   /* 8273 Parameter/Result register                   */
#define AR_8273T  0x0A   /* 8273 TX result                                   */
#define AR_8273R  0x0B   /* 8273 RX result                                   */
#define AR_8273D  0x0C   /* 8273 Data Buffer                                 */

#define AC_MPCAD  0x0F   /* MPCA command: disable                            */

/*****************************************************************************/
/* Equates for port values on the 8255                                       */
/*****************************************************************************/

#define A55_ModeSet         0x98
#define A55_Reset8273On     0x17
#define A55_Reset8273Off    0x07
#define A55_InitPortC       0xf2
#define A55_ResetPortC      0xfc
#define A55_ResetModemStatusCh       0x08

/*****************************************************************************/
/* This is the value in the MCA POS ID register defining an MPA/A adapter.   */
/*****************************************************************************/
#define POS_MPAATypeID       0xdeff

/*****************************************************************************/
/* Macro to wait for particular state of 8273                                */
/*****************************************************************************/
#define CVHMAXWT  64            /* Max times to poll 8273 before error       */

#define WAITUNTIL(pDX,Mask,OP,StopVal)                                        \
{                                                                             \
  register int waitcnt = CVHMAXWT;                                            \
                                                                              \
  while (waitcnt--)                                                           \
  {                                                                           \
    LastWaitUntilStatus = IO_IN (pDX->ADAPTERBASE + AR_8273S);                \
    if ((LastWaitUntilStatus & (Mask)) OP (StopVal))                          \
      break;                                                                  \
    if (waitcnt <= 1)                                                         \
    {                                                                         \
      pDX->pIR->StatusArray[SA_HardwareError]++;                              \
      pDX->pIR->StatusCount++;                                                \
      pDX->DPCAction |= DPC_ACTION_PULSE;                                     \
      pDX->HardwareError = TRUE; /* can be tested by callers if nec. */       \
      TRACE_EVENT (WaTo);                                                     \
      ASSERT (FALSE);                                                         \
      break;                                                                  \
    }                                                                         \
    KeStallExecutionProcessor (1L);                                           \
  }                                                                           \
}


