
/* semfddmi.h */

/*****************************************************************************/
/* NT IBM SDLC Adapter Device Driver: Nt-Specific Grabbage                   */
/*****************************************************************************/

/*****************************************************************************/
/* Power-up-selector values for reading MCA configuration from adapters.     */
/*****************************************************************************/

#define POS_Adapter_Select   0x0096
#define POS_AdapterID_HiByte 0x0101
#define POS_AdapterID_LoByte 0x0100
#define POS_ConfigByte2      0x0102
#define POS_ConfigByte3      0x0103

/*****************************************************************************/
/* following #defines pinched from OS2 pmsdk: os2def.h                       */
/*****************************************************************************/

/* Cast any variable to an instance of the specified type. */
#define MAKETYPE(v, type)   (*((type *)&v))

/* cast an expression  to any type */
#define CAST(v, type)       ((type) (v))

/* Calculate the byte offset of a field in a structure of type type. */
#define FIELDOFFSET(type, field)    ((SHORT)&(((type *)0)->field))

/* Combine l & h to form a 32 bit quantity. */
#define MAKELONG(l, h)   ((LONG)MAKEULONG(l, h))

/* Combine l & h to form a 16 bit quantity. */
#define MAKEUSHORT(l, h) (((USHORT)(l)) | ((USHORT)(h)) << 8)
#define MAKESHORT(l, h)  ((SHORT)MAKEUSHORT(l, h))

/* Extract high and low order parts of 16 and 32 bit quantity */
#define LOBYTE(w)       LOUCHAR(w)
#define HIBYTE(w)       HIUCHAR(w)
#define LOUCHAR(w)      ((UCHAR)(w))
#define HIUCHAR(w)      ((UCHAR)(((USHORT)(w) >> 8) & 0xff))
#define LOUSHORT(l)     ((USHORT)(l))
#define HIUSHORT(l)     ((USHORT)(((ULONG)(l) >> 16) & 0xffff))

#define FIELDOFFSET(type, field)    ((SHORT)&(((type *)0)->field))

/*****************************************************************************/
/* syntactic niceties                                                        */
/*****************************************************************************/

#define EQ ==
#define NE !=

#define BITSOFF(Val,Bits) (((Val) & (Bits)) EQ 0) //famous Russian striptease artist (hi steve)

/*****************************************************************************/
/* what is BOOLean all about?  Well, ntdef.h (in public\sdk\inc) defines     */
/* BOOLEAN to be a CCHAR i.e. a char.  But the result of a logical expression*/
/* is an int - so casting needed every time you assign a logical value to a  */
/* BOOLEAN variable.  The BOOLean is a device to document that a variable is */
/* a boolean thing while avoiding conversion problems of 'BOOLEAN' typedef.  */
/* (Ggggarrrhhhhh) (to quote jocky wilson).                                  */
/*****************************************************************************/
typedef int BOOLean;

