/************************************************************************\
* The enclosed files, "the software," is provided by 
* Microsoft Corporation "as is" without warranty of any kind. 
* MICROSOFT DISCLAIMS ALL WARRANTIES, EITHER EXPRESS OR IMPLIED, 
* INCLUDING BUT NOT LIMITED TO IMPLIED WARRANTIES OF MERCHANTABILITY 
* AND FITNESS FOR A PARTICULAR PURPOSE.  You assume all risks of 
* using the software.
* 
* The software is Copyright (c) 1992 Microsoft Corporation.
* Original Author: John M. Hall, Microsoft SDE  9/1/92
*
* You are granted the right to freely distribute this software.
* You are granted the right to make changes provided this comment block
* is retained without modification and you acknowledge the changes.
* 
\************************************************************************/
#define DEBUG
#include <stdio.h>
#include <assert.h>
#include <windows.h>
#include <string.h>
#include <queue.h>
#include <shrmem.h>
#include <myopt.h>

#define QUEUE_NAME "\\queues\\test"

#define TEST_MSGS     5
#define TEST_DELAY  400

struct _write_test {
    DWORD  dwEventCode;
    DWORD  dwPriority;
    LPTSTR lptstr;
} test[TEST_MSGS] =
    {
     0,  0, "Terminate Processing",
    11,  1, "First message sent",
    12, 10, "Second message sent",
    13,  5, "Third test msg",
    14,  8, "Fourth"
    };

void do_it(HQUEUE hq, int ii)
{
    DWORD   dwShrHandle;
    LPTSTR  lptstr;

    dwShrHandle = ShrAlloc( 1000, 0);
    lptstr = (LPTSTR) ShrLock(dwShrHandle);
    strcpy( lptstr, test[ii].lptstr);
    ShrUnlock(dwShrHandle);
    printf( "Writing %d %d %d\n", test[ii].dwEventCode,
            dwShrHandle, test[ii].dwPriority);
    WriteQueue(hq, test[ii].dwEventCode, dwShrHandle, test[ii].dwPriority);
    Sleep(TEST_DELAY);

}

main(int argc, char *argv[])
{
    HQUEUE  hq;
    DWORD   dwErr;
    DWORD   dwOwner;
    int     ii;
    HANDLE  hClient;
    BOOL    bWait = FALSE;
    int     iFlag;


    while (iFlag = my_getopt( argc, argv, "w"))
        {
        switch(iFlag)
            {
            case 'w':
                bWait = TRUE;
                break;
            default:
                printf( "Unidentified flag %c\n", (char) iFlag);
                break;
            }
        }



    if (bWait)
        hClient = CreateEvent( NULL, TRUE, FALSE, "ClientSaysGo");

    dwErr = OpenQueue( &dwOwner, &hq, QUEUE_NAME);

    if (dwErr != 0)
        {
        printf( "CreateQueue Failed\n");
        return(-1);
        }

    printf( "Queue owner is %d\n", dwOwner);


    for (ii = 1; ii < TEST_MSGS; ii++)
        {
        do_it(hq, ii);
        }

    if (bWait)
        SetEvent(hClient);

    do_it(hq, 0);

    printf( "Client exiting\n");
    CloseQueue(hq);

    return(0);
}
