/************************************************************************\
* The enclosed files, "the software," is provided by 
* Microsoft Corporation "as is" without warranty of any kind. 
* MICROSOFT DISCLAIMS ALL WARRANTIES, EITHER EXPRESS OR IMPLIED, 
* INCLUDING BUT NOT LIMITED TO IMPLIED WARRANTIES OF MERCHANTABILITY 
* AND FITNESS FOR A PARTICULAR PURPOSE.  You assume all risks of 
* using the software.
* 
* The software is Copyright (c) 1992 Microsoft Corporation.
* Original Author: John M. Hall, Microsoft SDE  9/1/92
*
* You are granted the right to freely distribute this software.
* You are granted the right to make changes provided this comment block
* is retained without modification and you acknowledge the changes.
* 
\************************************************************************/
#define DEBUG
#include <stdio.h>
#include <assert.h>
#include <windows.h>
#include <string.h>
#include <queue.h>
#include <shrmem.h>
#include <myopt.h>

#define QUEUE_NAME "\\queues\\test"

main(int argc, char *argv[])
{
    HQUEUE  hq;
    DWORD   dwErr;
    HANDLE  hEvent;
    DWORD   dwProcess = 1;
    Q_ELEMENT qe;
    LPTSTR  lptstr;
    HANDLE  hProcess = GetCurrentProcess();
    HANDLE  hClient;
    int     iType = QUE_FIFO;
    BOOL    bWait = FALSE;
    int     iFlag;
    BOOL    bPeek = FALSE;
    int     iElement = -1;


    while (iFlag = my_getopt( argc, argv, "plfwP"))
        {
        switch(iFlag)
            {
            case 'P':
                bPeek = TRUE;
                bWait = TRUE;
                break;

            case 'p':
                iType = QUE_PRIORITY;
                break;
            case 'l':
                iType = QUE_LIFO;
                break;
            case 'f':
                iType = QUE_FIFO;
                break;
            case 'w':
                bWait = TRUE;
                break;
            default:
                printf( "Unidentified flag %c\n", (char) iFlag);
                break;
            }
        }


    if (bWait)
        hClient = CreateEvent( NULL, TRUE, FALSE, "ClientSaysGo");

    dwErr = CreateQueue( &hq, iType, QUEUE_NAME);

    if (dwErr != 0)
        {
        printf( "CreateQueue Failed\n");
        return(-1);
        }

    hEvent = GetQueueEventHandle(hq);

    if (hEvent == 0)
        {
        CloseQueue(hq);
        printf( "GetQueueEventHandle Failed\n");
        return(-1);
        }
    else
        printf( "GetQueueEventHandle Succeeded\n");


    if (bWait)
        WaitForSingleObject(hClient, INFINITE);

    while (bPeek)
        {
        SetPriorityClass(hProcess, HIGH_PRIORITY_CLASS);
        WaitForSingleObject(hEvent, INFINITE);

        if (PeekQueue(hq, &qe, &iElement, FALSE) != 0)
            {
            bPeek = FALSE;
            printf( "End of Peek's\n");
            continue;
            }

        SetPriorityClass(hProcess, NORMAL_PRIORITY_CLASS);

        printf( "E %5d,  P %5d, W %5d, S %5d, ",
            qe.dwEventCode, qe.dwPriority, qe.dwWriterId, qe.dwShrHandle);

        if (qe.dwShrHandle != 0)
            {
            lptstr = (LPTSTR) ShrLock(qe.dwShrHandle);
            printf( "M:%30s.\n", lptstr);
            ShrUnlock(qe.dwShrHandle);
            }

        }

    while (dwProcess)
        {
        SetPriorityClass(hProcess, HIGH_PRIORITY_CLASS);
        WaitForSingleObject(hEvent, INFINITE);

        dwErr = ReadQueue(hq, &qe, 0, FALSE);

        SetPriorityClass(hProcess, NORMAL_PRIORITY_CLASS);

        if (dwErr != 0)
            {
            printf( "ReadQueue failed\n");
            }


        dwProcess = qe.dwEventCode;

        printf( "E %5d,  P %5d, W %5d, S %5d, ",
            qe.dwEventCode, qe.dwPriority, qe.dwWriterId, qe.dwShrHandle);

        if (qe.dwShrHandle != 0)
            {
            lptstr = (LPTSTR) ShrLock(qe.dwShrHandle);
            printf( "M:%30s.\n", lptstr);
            ShrUnlock(qe.dwShrHandle);
            ShrFree(qe.dwShrHandle);
            }
        }
    CloseQueue(hq);
    printf( "Server exiting\n");

    return(0);
}
