#include<windows.h>
#include"winapp.h"
#include"stdwin.h"
#include"winfont.h"
#include<string.h>
class WHello : public WinAppStdWindow
{
    static WinClass wc;             // ALL descendants of Window must do this...
    char *message;
    WinFont     myFont;
public:
    static long FAR PASCAL _export WHello :: WndProc(HWND hWnd,
                                   unsigned iMsg, WORD wParam, LONG lParam);
    WHello(WinApp *myApp, char *winname, char *msg) :
                    WinAppStdWindow(myApp, &wc, winname) {
        // insert calls to change window class info here
        message = msg;
        if(GetClassName() == NULL) {
            SetClassName("Hello");
            SetClassWinProc(WHello::WndProc);
        }
        myFont.SetFontWeight(FW_HEAVY);
        myFont.SetFontCharSet(OEM_CHARSET);
        myFont.SetFontPitchAndFamily(FF_SCRIPT | VARIABLE_PITCH);
        myFont.SetFontHeight(70);
        myFont.SetFontWidth(15);
        myFont.Create();
    }
    void Paint(void) {
        PAINTSTRUCT ps; HDC hdc = BeginPaint(GetHandle(), &ps);
        // set alignment flags for centering
        SetTextAlign(ps.hdc, TA_CENTER);
        SelectObject(hdc,myFont.GetHandle());
        RECT rect;
        GetClientRect(GetHandle(),&rect); // new centered rectangle
        TextOut(ps.hdc,rect.right/2, rect.bottom/2,message, strlen(message));
        EndPaint(GetHandle(), &ps);
    }
    void SetMessage(char *newmsg)  { message = newmsg; }
};

WinClass WHello::wc;                                                            // ...and this.

// this should become a winproc for handling app-specific behavior
long FAR PASCAL _export WHello::WndProc(HWND hWnd,
                      unsigned iMsg, WORD wParam, LONG lParam) {
    WHello *pWHello = (WHello *)GetPointer(hWnd);
    switch (iMsg) {
        case WM_CREATE:                         // insert the pointer
            pWHello = (WHello *)((LPCREATESTRUCT)lParam)->lpCreateParams;
            SetPointer(hWnd, pWHello);
            break;
        case WM_PAINT:
            pWHello->Paint();             // call Paint method
            break;
        case WM_CLOSE:
            DestroyWindow(hWnd);
            break;
        case WM_DESTROY:
            PostQuitMessage(0);
            break;
        default:
            return DefWindowProc(hWnd, iMsg, wParam, lParam);
    }
    return 0L;
}

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
                                   LPSTR lpszCmdLine, int  nCmdShow) {
    // create an instance of WinApp and initialize it
    WinApp MyApp(hInstance, hPrevInstance, lpszCmdLine, nCmdShow);
    // create an instance of WHello for MyApp with winname, "Hello!"
    WHello MyWin(&MyApp, "Hello!", "Hello, Windows from Borland C++");
    MyWin.Display();                                        // open the window
    // create another instance
    WHello MyWin2(&MyApp, "Hello2!", "And, another Hello!");
    MyWin2.Display();                                      // open it
    return MyApp.MessageLoop();                   // process any messages
}
