/*----------------------------------------------------
   SYSMETS1.C -- System Metrics Display Program No. 1
		 (c) Charles Petzold, 1990
  ----------------------------------------------------*/

#include <windows.h>
#include "sysmets.h"

long FAR PASCAL WndProc (HWND, WORD, WORD, LONG) ;

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
		    LPSTR lpszCmdline, int nCmdShow)
     {
     static char szAppName[] = "SysMets1" ;
     HWND        hwnd ;
     MSG         msg ;
     WNDCLASS    wndclass ;

     if (!hPrevInstance)
	  {
	  wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
	  wndclass.lpfnWndProc   = WndProc ;
	  wndclass.cbClsExtra    = 0 ;
	  wndclass.cbWndExtra    = 0 ;
	  wndclass.hInstance     = hInstance ;
	  wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
	  wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
	  wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
	  wndclass.lpszMenuName  = NULL ;
	  wndclass.lpszClassName = szAppName ;

	  RegisterClass (&wndclass) ;
	  }

     hwnd = CreateWindow (szAppName, "Get System Metrics No. 1",
			  WS_OVERLAPPEDWINDOW,
			  CW_USEDEFAULT, CW_USEDEFAULT,
			  CW_USEDEFAULT, CW_USEDEFAULT,
			  NULL, NULL, hInstance, NULL) ;
     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
	  {
	  TranslateMessage (&msg) ;
	  DispatchMessage (&msg) ;
	  }
     return msg.wParam ;
     }

long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
     {
     static short cxChar, cxCaps, cyChar ;
     char         szBuffer[10] ;
     HDC          hdc ;
     short        i ;
     PAINTSTRUCT  ps ;
     TEXTMETRIC   tm ;
     switch (message)
	  {
	  case WM_CREATE :
	       hdc = GetDC (hwnd) ;

	       GetTextMetrics (hdc, &tm) ;
	       cxChar = tm.tmAveCharWidth ;
	       cxCaps = (tm.tmPitchAndFamily & 1 ? 3 : 2) * cxChar / 2 ;
	       cyChar = tm.tmHeight + tm.tmExternalLeading ;

	       ReleaseDC (hwnd, hdc) ;
	       return 0;

	  case WM_PAINT :
	       hdc = BeginPaint (hwnd, &ps) ;

	       for (i = 0 ; i < NUMLINES ; i++)
		    {
		    TextOut (hdc, cxChar, cyChar * (1 + i),
			     sysmetrics[i].szLabel,
			     lstrlen (sysmetrics[i].szLabel)) ;

		    TextOut (hdc, cxChar + 18 * cxCaps, cyChar * (1 + i),
			     sysmetrics[i].szDesc,
			     lstrlen (sysmetrics[i].szDesc)) ;

		    SetTextAlign (hdc, TA_RIGHT | TA_TOP) ;

		    TextOut (hdc, cxChar + 18 * cxCaps + 40 * cxChar,
			     cyChar * (1 + i), szBuffer,
			     wsprintf (szBuffer, "%5d",
				  GetSystemMetrics (sysmetrics[i].nIndex))) ;

		    SetTextAlign (hdc, TA_LEFT | TA_TOP) ;
		    }

	       EndPaint (hwnd, &ps) ;
	       return 0 ;

	  case WM_DESTROY :
	       PostQuitMessage (0) ;
	       return 0 ;
	  }

     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }