/*****************************************************************************

	utils.c
	-------

	This module contains Useful Things

	This source is Copyright (c) Alan Phillips 1991. It may be freely used
	and adapted for non-commercial applications. Commercial and ShareWare
	authors should first obtain the written permission of the author.

	The source is edited with a tab size of 4.

*****************************************************************************/

#include	"stdhead.h"
#include	<stdarg.h>
#include	<ctype.h>


/*****************************************************************************

	Local Variables
	---------------

*****************************************************************************/

static	HCURSOR	hSaveCursor,			/* cursor handle saved when hourglass
										*  is being shown
										*/
				hHourGlass;				/* handle to hourglass cursor */

/*****************************************************************************

	message
	-------

	Outputs a message in a tsk modal message box, with variable arguments

	reply = message(string,caption,type,...)

	int		reply;			Reply from MessageBox
	LPSTR	string;			String to output, or NULL
	LPSTR	caption;		Message box caption
	WORD	type;			MessageBox wType argument. If NULL, the setting
							MB_ICONINFORMATION is used.
	...						Optional arguments

*****************************************************************************/

int		message(LPSTR string,LPSTR caption,WORD type,...)

{
	char	buffer[128];				/* work buffer */
	va_list	arg_ptr;					/* arg list pointer */

	/* Set up the argument list stuff */

	va_start(arg_ptr,type);

	/* And build the actual string to output */

	wvsprintf(buffer,string,arg_ptr);

	/* And display it, returning the result from MessageBox */

	return( MessageBox(NULL,
					   buffer,
					   caption,
					   (type == NULL ) ? MB_ICONINFORMATION | MB_TASKMODAL
					   				   : type | MB_TASKMODAL) );


}
			

/*****************************************************************************

	hourglass_on
	------------

	Sets an hourglass cursor, getting window capture. There must be a call
	of hourglass_off() to follow this.

	hourglass_on(hWnd)

	HWND	hWnd;				Window handle

*****************************************************************************/

void	hourglass_on(HWND hWnd)

{
	hHourGlass	= LoadCursor(NULL,IDC_WAIT);
	SetCapture(hWnd);
	hSaveCursor	= SetCursor(hHourGlass);
}


/*****************************************************************************

	hourglass_off
	-------------

	Restores the cursor from an hourglass to whatever it used to be, and
	loses mouse capture. A previous call to hourglass_on() must have been
	made.

	hourglass_off()

*****************************************************************************/

void	hourglass_off()

{
	SetCursor(hSaveCursor);
	ReleaseCapture();
}


