/*****************************************************************************

	textview.h
	----------

	This contains function prototypes and other items needed for users of
	the TextView DLL

*****************************************************************************/

/* Various typedefs that can be used by applications */

typedef	struct	sTVWSTATUS				/* TextView window status block */
		{
			DWORD	dwFlags;				/* dwFlags used in TVCreateWindow */
			int		nMaxLines;				/* max number of lines allowed */
			int		nLinesStored;			/* number of lines stored */
			BOOL	nSuspended;				/* window suspended? */
			BOOL	nReturningData;			/* window in TVReturnData? */
			BOOL	nRedraw;				/* is redrawing allowed? */
			int		nScrollState;			/* scrolling state */
			int		nTabSize;				/* tab size in characters */
			int		nMessagesLost;			/* messages lost in manual scroll */
			int		nRows;					/* current depth of window in rows */
			int		nColumns;				/* current width in average chars */
			int		nTopLine;				/* number of line at top of window */
			int		nNextRow;				/* number of next free row */
			COLORREF	crColor;			/* currently selected text colour */
			COLORREF	crBkColor;			/* currently selected background color */
		} TVWSTATUS;

typedef	TVWSTATUS	FAR * LPTVWSTATUS;

/* Routines in the TextView DLL that can be called by an application */

HWND	FAR	PASCAL	TVCreateWindow(LPSTR,LPSTR,int,int,int,int,HANDLE,HFONT,
								   DWORD,DWORD,int,int,FARPROC);
BOOL	FAR	PASCAL	TVDestroyWindow(HWND);
HWND	FAR	PASCAL	TVFindWindow(LPSTR);
BOOL	FAR	PASCAL	TVGetWindowStatus(HWND,LPTVWSTATUS);
BOOL	FAR	PASCAL	TVOutputText(HWND,LPSTR,int);
int		FAR	PASCAL	TVReturnData(HWND,LPSTR,int,FARPROC);
BOOL	FAR	PASCAL	TVRegisterClass(HANDLE,LPSTR,HICON,HBRUSH);
BOOL	FAR	PASCAL	TVResetWindow(HWND);
BOOL	FAR	PASCAL	TVSaveToFile(HWND,int,int,int,DWORD);
DWORD	FAR	PASCAL	TVSetBkColor(HWND,COLORREF);
DWORD	FAR	PASCAL	TVSetTextColor(HWND,COLORREF);
int		FAR	PASCAL	TVSetRedraw(HWND,BOOL);
BOOL	FAR PASCAL	TVSetVPosition(HWND,int);
BOOL	FAR	PASCAL	TVSuspendWindow(HWND,BOOL);
WORD	FAR	PASCAL	TVSetScrollState(HWND,WORD);
void	FAR	PASCAL	TVVersion(LPINT,LPINT,LPINT);

/* Flags for the dwStyle argument to TVCreateWindow */

#define	TVS_TIMESTAMP	0x00000001L		/* timestamp all messages */
#define	TVS_MINIMIZE	0x00000002L		/* window has a minimize box */
#define	TVS_MAXIMIZE	0x00000004L		/* window has a maximize box */
#define	TVS_NOCLOSE		0x00000008L		/* disable close in system menu */
#define	TVS_NORESIZE	0x00000010L		/* don't give window a resizing border */
#define	TVS_SYSMENU		0x00000020L		/* window has a system menu */
#define	TVS_FILESAVE	0x00000040L		/* window has 'File save' menu item */
#define	TVS_FILESAVEAS	0x00000080L		/* window has 'File save as' menu item */
#define	TVS_FILEPRINT	0x00000100L		/* window has 'File Print' menu items */
#define	TVS_HSCROLL		0x00000200L		/* window can be scrolled horizontally */
#define	TVS_VSCROLL		0x00000400L		/* window can be scrolled vertically */
#define	TVS_SCROLLMENU	0x00000800L		/* window has 'Scrolling' menu */

/* Values for the nState argument to TVSetScrollState and replies from
*  TVGetScrollState
*/

#define	TV_SCR_MANUAL	0x0001			/* manual - scroll bars visible */
#define	TV_SCR_AUTO		0x0002			/* auto - no scroll bars visible */

/* Values for the nPosition argument to TVSetVposition */

#define	TVSP_START		-1				/* top of scroll range */
#define	TVSP_END		-2				/* bottom of scroll range */

/* Menu identifier values passed back in the nMenuItem word of the menu handler
*  call back function declared to TVCreateWindow
*/

#define	TVMI_CLOSE			1			/* 'System Close' clicked */
#define	TVMI_FILESAVE		16			/* 'File save' clicked */
#define	TVMI_FILESAVEAS		17			/* 'File save as' clicked */
#define	TVMI_FILEPRINT		18			/* 'File print' clicked */
#define	TVMI_AUTOSCROLL		32			/* 'Scroll auto' clicked */
#define	TVMI_MANUALSCROLL	33			/* 'Scroll manual' clicked */

