/****************************************************************
/*
/*						HexDump.C
/*
/* Copyright (c) 1990 by Michael I. Hyman.  All rights reserved.
/*
***************************************************************/

/*********************************************************** 
/* 
/* C Code for hexdump DLL 
/* 
***********************************************************/ 
 
/*********************************************************** 
/* 
/* define types used in the program 
/* 
***********************************************************/ 
 
typedef unsigned char	    BYTE; 
typedef unsigned int	    WORD; 
typedef unsigned long	    DWORD; 
typedef char far	    *LPSTR; 
typedef WORD		    HANDLE; 
typedef HANDLE		    HWND; 
 
/*********************************************************** 
/* 
/* type the routine 
/* 
***********************************************************/ 
void far pascal hexdump(LPSTR, LPSTR, int); 
 
/*********************************************************** 
/* 
/* This routine is called by LibEntry when the DLL 
/* is initialized.  LibMain is used to further initialize 
/* the DLL 
/* 
***********************************************************/ 
            
int far pascal 
LibMain(hModule, wDataSeg, cbHeapSize, lpszCmdLine) 
HANDLE  hModule; 
WORD    wDataSeg; 
WORD    cbHeapSize; 
LPSTR   lpszCmdLine; 
{ 
    return 1; 
} 
 
 
/*********************************************************** 
/* 
/* This routine is called when Windows closes the DLL. 
/* 
***********************************************************/ 
 
void far pascal 
WEP (bSystemExit) 
int  bSystemExit; 
{ 
    return; 
} 
 
 
/*********************************************************** 
/* 
/* This routine demonstrates calling optimized routines 
/* from DLL's.  This routine takes a 256 character string 
/* and creates a 65x16 bytes string showing the hex 
/* values of each byte, and the raw data.  Values under 
/* 0x20 are displayed as periods. 
/* 
/* src is a pointer to the data to convert. 
/* dest is a pointer to a buffer into which the result is 
/*  placed 
/* len indicates the number of characters to convert 
/* 
***********************************************************/ 
 
 
void far pascal 
hexdump( src, dest, len ) 
BYTE far *src; 
char far *dest; 
int len; 
{ 
    short  i, j; 
    char far *ascside; 
    BYTE c; 
    /* Create hex character look up table */ 
    char *hexchars = "0123456789ABCDEF"; 
 
    /* Loop for 16 rows or until run out of data */ 
    for (i = 16; --i >= 0, len > 0; ) { 
         /* The ASCII representation is 48 characters after  
         /* the beginning of the hex representation 
         */ 
         ascside = dest + 48; 
         /* Loop for each character in the row */ 
         for (j = 16; --j >= 0; ) { 
              /* Don't read beyond end of data */ 
              c = --len >= 0 ? *src++ : 0; 
              /* Print two hexits followed by a space */ 
              *dest++ = hexchars[c >> 4]; 
              *dest++ = hexchars[c & 0xf]; 
              *dest++ = ' '; 
              /* Print the actual character */ 
              *ascside++ = c < 32 ? '.' : c; /* suppress ctrls */ 
         } 
         *ascside++ = 13;  /* Carriage return */ 
         dest = ascside;     /* Next line starts after end */ 
    } 
    /* if hit end of file */
    if (i > len)
        *dest = 0;
} 
  