//*
//* getoff.c: 	This utility reads the offsets of variables, named in a list
//*				file, from the named *.MAP file.
//*
//*				"getoff <MAPFILE> <LISTFILE>"
//*				
//*				The utility then overwrites the original list file
//*				with the offsets of the global variables as constants.
//*				The constants file can then be include in the DLL routines.
//*				The use of in-line assembly allows you to reference the
//*				variables.
//*
//*	r.e.haxton 93jan20
//*

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>

#define	VAR_DS_OFFSET	6

void main(int argc, char **argv)
{
	/* function prototypes */
	short		GetVarName(FILE *, char *, long *);
	char		*GetVarOffset(FILE *, long *);

	void		raiseStr(char *);

	/* local variables */
	char		mapFile[50];
	char		listFile[50];
	float		perCent;
  	FILE		*mapPtr, *filePtr;
	long		bufStartPos;

	static	float fileCount= 0;
	static	float matchCount= 0;

	struct LIST_NODE	{

		char	name[50];
		char	offset[5];
		struct LIST_NODE *next;

	} *tailPtr, *headPtr;

//REH--->93jan20 	LATER PUT IN CORRECT ERROR CHECKING...
//						FOR NOW IN HOUSE UTILITY.

	/* get file name */
	if(argc < 3) {

		printf("Please enter the name of the MAP file you wish to search: ");
		scanf(mapFile, "%s\n");

		printf("Please enter the name of the LIST file: ");
		scanf(listFile, "%s\n");

	}
							 
	else {

		strcpy(mapFile, argv[argc-2]);
		strcpy(listFile, argv[argc-1]);

	}

	/* open the map file (read) */
	if((mapPtr= fopen(mapFile, "r")) == NULL) {

		printf("Can't open file: %s\n");
		exit(-1);

	}
	
	/* open the list file (read/write) */
	if((filePtr= fopen(listFile, "r+")) == NULL) {

		printf("Can't open file: %s\n");
		exit(-1);

	}

	/* indicate to user that you're working */
	printf("Reading List File...\n");

	/*	alloc space for tailPtr node and read list file */
	if((headPtr= (struct LIST_NODE *) malloc(sizeof(struct LIST_NODE))) == NULL) {

		printf("Not Enough Memory!\n");
		exit(-1);

	}

	/* read list file */
	fscanf(filePtr, "%s", headPtr->name);

	/* increment file counter */
	++fileCount;

	headPtr->next= NULL;
	tailPtr= headPtr;
		
	/* read list file until EOF */
	while(!feof(filePtr)) {

		if((tailPtr->next= (struct LIST_NODE *) malloc(sizeof(struct LIST_NODE))) == NULL) {

			printf("Not Enough Memory!\n");
			exit(1);

		}

		tailPtr= tailPtr->next;

		/* read name from list file */
		fscanf(filePtr, "%s", tailPtr->name);

		/* increment file counter */
		++fileCount;

		tailPtr->next= NULL;
		
	}

	/* decrement the fileCount by one */
	--fileCount;

	/* close list file */
	fclose(filePtr);

	/* set up search file pointer */
	tailPtr= headPtr;

	/* search map file */
	while(tailPtr->next != NULL) {

		/* search for variable string */
		if(GetVarName(mapPtr, tailPtr->name, &bufStartPos)) {

			/* grab offset of variable from map file */
			strcpy(tailPtr->offset, GetVarOffset(mapPtr, &bufStartPos));
			tailPtr= tailPtr->next;

			/* calculate and print percentage of search done */
			perCent=  ((++matchCount) / fileCount) * 100;
			printf("Percent completed: %3.2f\n", perCent);

		}
	}

	/* open an include file and output the constants */
	if((filePtr= fopen("consts.h", "w+")) == NULL) {

		printf("Can't open file: %s\n");
		exit(-1);

	}

	/* output var name and offsets to new include file */
	tailPtr= headPtr;

	printf("Writing output file...\n");

	while(tailPtr->next != NULL) {

		/* convert variable name to uppercase */
		raiseStr(tailPtr->name);

		fprintf(filePtr, "#define %s\t\t0x%s\n", tailPtr->name, tailPtr->offset);
		tailPtr= tailPtr->next;

	}

	/* free nodes */
	tailPtr= headPtr;
	headPtr= headPtr->next;
	
	while(tailPtr->next != NULL) {

		/* free node */
		free(tailPtr);

		tailPtr= headPtr;
		headPtr= headPtr->next;

	}

	/* close files */
	fclose(filePtr);
	fclose(mapPtr);

	printf("Finish\n");

}	/* main */

//-------------------------------------------------------------------------->

//
// This routine keeps track of the search file pointer and grabs the
// names of variables from the name field in the *.map file. 
//

short GetVarName(FILE *mapPtr, char *varName, long *prevpos)
{
	/* local variables */
	char		tmpBuffer[80];
	static	long ptrpos= 0;

	/* obtain record start position if beginning reset pointer position */
	if((*prevpos= ftell(mapPtr)) == 0)
		ptrpos= 0;
	else
		*prevpos= ptrpos;

	/* grab total map line */
	fgets(tmpBuffer, 80, mapPtr);

	/* get new position */
	ptrpos= ftell(mapPtr);

	/* check for matching string */
	if(strstr(tmpBuffer, varName) != NULL)
		return(1);

	else
		return(0);

}	/* GetVarName */

//-------------------------------------------------------------------------->

//
// This routine grabs the offset of the found named variable.
//

char  *GetVarOffset(FILE *mapPtr, long *prevPos)
{
	/* local variables */
	char	tmpBuffer[5];

	/* seek to and get variable name data offset map file */
	fseek(mapPtr, (*prevPos + VAR_DS_OFFSET), SEEK_SET);
	fgets(tmpBuffer, 5, mapPtr);

	/* return offset */
	return(tmpBuffer);

}	/* GetVarOffset */

//------------------------------------------------------------------------>

//
// this routine converts a string to uppercase
//
void	raiseStr(char *string)
{
  /* local variables */
	short		i;

	for(i= 0; (i < strlen(string)); i++)
		string[i]= toupper(string[i]);

} /* raiseStr */
