function TChartWindow.Read(FName : PChar) : Boolean;
var S : TBufStream;
begin
  S.Init(FName, StOpenRead, 1024);
  if S.Status <> stOk then
    IOError('Can''t open file ')
  else
    begin
      Chart := PChart(S.Get);
      if S.Status <> stOk then
        IOError('Can''t read file ')
      else
      begin
        setCaption(Name);
        Saved := True;
      end;
    end;
  S.Done;
  Read := (S.Status = stOk);
end;

{ Store a chart onto a file by storing onto a stream. }
function TChartWindow.Write(FName : PChar) : Boolean;
var S : TBufStream;
begin
  S.Init(FName, stCreate, 1024);
  if S.Status <> stOk then
    IOError('Can''t create file ')
  else
    begin
      S.put(Chart);
      if S.Status <> stOk then
        IOError('Can''t write file ')
      else
      begin
        setCaption(Name);
        Saved := True;
      end;
    end;
  S.Done;
  Write := (S.status = StOk);
end;

