library Frames;

{$C Fixed Permanent}

uses WinTypes, WinProcs;

type
	WinInfo = Record
   	Wnd:hWnd;
    Style:Integer;
    DefProc:TFarProc;
  end;

const
	FRAME = 0;
  UNFRAME = 1;
  CHANGE = 2;

var
	WinArray: array [1..1024] of WinInfo;
  TWins:Integer;
  hGreyPen, hWhitePen:hPen;
  SaveExit:Pointer;

function Wnd2El (Wnd:HWND):Integer;
	Var
  	El:Integer;
    Match:Bool;
	Begin
  	El := 0;
    Match := FALSE;
    While (Match = FALSE) do
    	Begin
      	Inc (El);
        if (WinArray[El].Wnd = Wnd) then Match := TRUE;
      end;
    Wnd2El := El;
  end;

procedure RemoveEl (El:Integer);
	Begin
  	SetWindowLong (WinArray[El].Wnd, GWL_WNDPROC, LongInt (WinArray[El].DefProc));
   	Move (WinArray[El + 1].Wnd, WinArray[El].Wnd,
      	SizeOf (WinInfo) * (TWins - El));
    Dec (TWins);
	end;


function FrameProc (Wnd:HWND; Msg, wParam:WORD; lParam:Longint):longint;export;
	var
  	El:Integer;
    DC:hDC;
    hOldPen:hPen;
    hDarkPen:hPen;
    hLightPen:hPen;
   	MyRect:TRect;

	begin
		El := Wnd2El(Wnd);
    if (Msg = WM_DESTROY) then
    	Begin
	   		FrameProc := CallWindowProc (WinArray[El].DefProc, Wnd, Msg, wParam, lParam);
        	RemoveEl (El);
      end
      else
   	  	FrameProc := CallWindowProc (WinArray[El].DefProc, Wnd, Msg, wParam, lParam);
   			if (Msg = WM_PAINT) then
      		Begin
         		if WinArray[El].Style = 0 then
            	Begin
              	hDarkPen := hGreyPen;
	              hLightPen := hWhitePen;
	            end
	            else
	            	Begin
	              	hDarkPen := hWhitePen;
	                hLightPen := hGreyPen;
	              end;
	          DC := GetWindowDC (Wnd);
	         	GetWindowRect (Wnd, MyRect);
	            hOldPen := SelectObject (DC, hLightPen);
	            MoveTo (DC, 0, (MyRect.Bottom - MyRect.Top));
	            LineTo (DC, 0, 0);
	            LineTo (DC, ((MyRect.Right - MyRect.Left) - 1), 0);
	            hLightPen := SelectObject (DC, hDarkPen);
	            LineTo (DC, ((MyRect.Right - MyRect.Left) - 1), ((MyRect.Bottom - MyRect.Top) - 1));
	            LineTo (DC, ((MyRect.Right - MyRect.Left) - 1) * -1, (MyRect.Bottom - MyRect.Top));
	            hDarkPen := SelectObject (DC, hOldPen);
	            ReleaseDC (Wnd, DC);
	    end;
  end;

procedure FrameWnd (Wnd:HWND;Style:Integer);export;
	begin
  	Inc (TWins);
    WinArray[TWins].Wnd := Wnd;
    WinArray[TWins].Style := Style;
    WinArray[TWins].DefProc := TFarProc(GetWindowLong (Wnd, GWL_WNDPROC));
    SetWindowLong (Wnd, GWL_WNDPROC, Longint (@FrameProc));
  end;

procedure UnFrameWnd (Wnd:HWND);export;
	Begin
  	RemoveEl (Wnd2El (Wnd));
  end;

procedure ChangeFrame (Wnd:HWND; Style:Integer);export;
	Begin
  	WinArray[Wnd2El(Wnd)].Style := Style;
  end;

function EnumFunc (Wnd:HWND; Action:LongInt):Bool;export;
   Begin
   	case LoWord(Action) of
    	FRAME:
      	FrameWnd (Wnd, HiWord(Action));
      UNFRAME:
      	UnFrameWnd (Wnd);
      CHANGE:
				ChangeFrame (Wnd, HiWord(Action));
    end;
    EnumFunc := TRUE;
   end;

procedure FrameChildren (Wnd:HWND; Style:Integer);export;
	Begin
  	EnumChildWindows (Wnd, @EnumFunc, MakeLong(FRAME, Style));
  end;

procedure UnFrameChildren (Wnd:HWND);export;
	Begin
  	EnumChildWindows (Wnd, @EnumFunc, MakeLong(UNFRAME, 0));
  end;

procedure ChangeChildren (Wnd:HWND; Style:Integer);export;
	Begin
   	EnumChildWindows (Wnd, @EnumFunc, MakeLong(CHANGE, Style));
  end;


procedure LibExit; far;
	var
   	El:Integer;
	begin
   	For El := 1 to TWins do
      	SetWindowLong (WinArray[El].Wnd, GWL_WNDPROC, LongInt(WinArray[El].DefProc));
   	DeleteObject (hWhitePen);
    DeleteObject (hGreyPen);
    ExitProc := SaveExit;
  end;


Exports
	FrameProc,
  FrameWnd resident,
  ChangeFrame resident,
  UnFrameWnd resident,
  FrameChildren resident,
  UnFrameChildren resident,
  ChangeChildren resident,
  EnumFunc;

begin
	TWins := 0;
  hGreyPen := CreatePen (0, 1, 8421504);
  hWhitePen := CreatePen (0, 1, 16777215);
  SaveExit := ExitProc;
  ExitProc := @LibExit;
end.
