// openfile.cpp RHS 3/31/91

#include"openfile.h"

char    OpenFileDlg::filename[FILENAME_MAX];
char    OpenFileDlg::openname[FILENAME_MAX];
char    OpenFileDlg::defpath[FILENAME_MAX];
char    OpenFileDlg::defspec[13];
char    OpenFileDlg::default_extension[4];
char    OpenFileDlg::str[FILENAME_MAX*2];
char    OpenFileDlg::caption[20];
char    OpenFileDlg::buttontext[20];
char    OpenFileDlg::mode;
WORD    OpenFileDlg::attribute;

unsigned  OpenFileDlg::hEditBox;
unsigned  OpenFileDlg::hListBox;
unsigned  OpenFileDlg::hPath;

// lets user select and open files
BOOL CALLBACK OpenFileDlg::DlgProc(HWND hDlg, UINT message, 
    WPARAM wParam, LPARAM lParam)
    {
    BOOL result;

    switch (message)
        {
        case WM_INITDIALOG:                        // message: initialize    
            SetDlgItemText(hDlg,IDOK,buttontext);
            SetWindowText(hDlg,caption);
            UpdateListBox(hDlg);
            SetDlgItemText(hDlg, hEditBox, defspec);
            SendDlgItemMessage(hDlg,hEditBox,EM_SETSEL,NULL,
                MAKELONG(0, 0x7fff));
            SetFocus(GetDlgItem(hDlg, hEditBox));
            return FALSE; // Indicates the focus is set to a control

        case WM_COMMAND:
            if(wParam == hListBox)
                {
                switch (HIWORD(lParam))
                    {
                    case LBN_SELCHANGE:
                        //  If item is a directory name, append "*.*" 
                        if(DlgDirSelect(hDlg, str, hListBox))
                            strcat(str, defspec);

                        SetDlgItemText(hDlg, hEditBox, str);
                        SendDlgItemMessage(hDlg,hEditBox,EM_SETSEL,NULL,MAKELONG(0, 0x7fff));
                        break;

                    case LBN_DBLCLK:
                        goto openfile;
                    }
                return TRUE;
                }

            switch (wParam)
                {
                case IDOK:
openfile:
                    GetDlgItemText(hDlg, hEditBox, openname, FILENAME_MAX);
                    if(strchr(openname, '*') || strchr(openname, '?'))
                        {
                        SeparateFilePath((LPSTR) str, (LPSTR) defspec,
                            (LPSTR) openname);
                        if(str[0])
                            strcpy(defpath, str);
                        ChangeDfExt(default_extension, defspec);
                        UpdateListBox(hDlg);
                        return TRUE;
                        }

                    if(!openname[0])
                        {
                        MessageBox(hDlg, "No filename specified.",
                            NULL, MB_OK | MB_ICONHAND);
                        return TRUE;
                        }

                    AddExtension(openname, default_extension);

                    if(mode == OPENFILE_FILEOPEN)
                        {
                        OFSTRUCT OfStruct;
                        int hdl;

                        if((hdl = OpenFile(openname,&OfStruct,OF_EXIST)) == -1)
                            {
                            filename[0] = '\0';
                            result = FALSE;
                            }
                        else
                            {
                            result = TRUE;
                            strcpy(filename, openname);
                            }
                        _lclose(hdl);
                        }
                    else    // mode is FILESAVE
                        {
                        result = TRUE;
                        strcpy(filename,openname);
                        }

                    EndDialog(hDlg, result);
                    return TRUE;

                case IDCANCEL:
                    EndDialog(hDlg, FALSE);
                    return TRUE;
                }
        }
    return FALSE;
    }

// updates the list box in the Open Dialog
void OpenFileDlg::UpdateListBox(HWND hDlg)
    {
    strcpy(str, defpath);
    strcat(str, defspec);
    DlgDirList(hDlg, str, hListBox, hPath, 0x4010);

        // list is for subdir of current drive directory
    if(!strchr (defpath, ':'))
    	DlgDirList(hDlg, defspec, hListBox, hPath, 0x4010);

        // remove the '..', if one
    if(strstr (defpath, ".."))
	    defpath[0] = '\0';
    SetDlgItemText(hDlg, hEditBox, defspec);
    }

// changes default extension
void OpenFileDlg::ChangeDfExt(char *Ext, char *Name)
    {
    char *pTptr;

    pTptr = Name;
    while(*pTptr && *pTptr != '.')
        pTptr++;
    if(*pTptr)
        if(!strchr(pTptr, '*') && !strchr(pTptr, '?'))
            strcpy(Ext, pTptr);
    }

// separates file and path names
void OpenFileDlg::SeparateFilePath(LPSTR lpDestPath,
    LPSTR lpDestFileName, LPSTR lpSrcFileName)
    {
    LPSTR lpTmp;
    char  cTmp;

    lpTmp = lpSrcFileName + (long) lstrlen(lpSrcFileName);
    while(*lpTmp != ':' && *lpTmp != '\\' && lpTmp > lpSrcFileName)
        lpTmp = AnsiPrev(lpSrcFileName, lpTmp);
    if(*lpTmp != ':' && *lpTmp != '\\') {
        lstrcpy(lpDestFileName, lpSrcFileName);
        lpDestPath[0] = 0;
        return;
    }
    lstrcpy(lpDestFileName, lpTmp + 1);
    cTmp = *(lpTmp + 1);
    lstrcpy(lpDestPath, lpSrcFileName);
    *(lpTmp + 1) = cTmp;
    lpDestPath[(lpTmp - lpSrcFileName) + 1] = 0;
    }

// adds default extension
void OpenFileDlg::AddExtension(char *Name, char *Ext)
    {
    char *pTptr;

    pTptr = Name;
    while(*pTptr && *pTptr != '.')
        pTptr++;
    if(*pTptr != '.')
        strcat(Name, Ext);
    }


