// winapp.cpp
#include<windows.h>
#include"winapp.h"

HINSTANCE WinApplication::ApphInstance;
HINSTANCE WinApplication::hPrevInstance;
LPSTR WinApplication::lpszCmdLine;
int WinApplication::nCmdShow;

int WinApplication::Run(void)    // default message loop processing
    {
    MSG msg;

    while(GetMessage(&msg, NULL, 0, 0))
        {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
        }
    return msg.wParam;
    }

WinClass::WinClass(void)
    {
    style = NOSTYLE;
    lpfnWndProc = DefWindowProc;
    cbClsExtra = NOEXTRABYTES;
    cbWndExtra = NOEXTRABYTES;
    hInstance = NULL;
    hIcon = LoadIcon(NULL, IDI_APPLICATION);
    hCursor = LoadCursor(NULL, IDC_ARROW);
    hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
    lpszMenuName = NULL;
    lpszClassName = NULL;
    class_registered = FALSE;
    }

void WinClass::ClassRegister(void)
    {
        // since 'this' is derived from WNDCLASS, it's passed as one
    RegisterClass(this);
    class_registered = TRUE;
    }

BOOL WinClass::ClassRegistered(void)   
    { 
    if(class_registered)
        return TRUE;
    if(!lpszClassName || !hInstance)
        return FALSE;

    WNDCLASS wndclass;
    
    if(GetClassInfo(hInstance,lpszClassName,&wndclass))
        {
        LPCSTR menuName = lpszMenuName;
        HINSTANCE hInst = hInstance;
        LPCSTR className = lpszClassName;
        WNDCLASS *wc = this;
        *wc = wndclass;         // structure assignment
        lpszClassName = className;
        lpszMenuName = menuName;
        hInstance = hInst;
        return class_registered = TRUE;
        }
    return FALSE;
    }


WinHandle::WinHandle(void)
    {
    hWnd = NULL;
    classname = (LPSTR)"WinApplication";
    windowname = (LPSTR)"WinApplication:Window";
    winstyle = 0;
    upper_left_x = upper_left_y = winwidth = winheight = 0;
    winParent = NULL;
    menu = NULL;
    hInstance = 0;
    lpParam = NULL;
    }

BOOL WinHandle::Create(void)
    {
    if(hWnd)    // if window's already created, return TRUE
        return TRUE;

    hWnd = CreateWindow(classname,windowname,winstyle,upper_left_x,
        upper_left_y,winwidth,winheight,winParent,menu,hInstance,
        lpParam);

    return (hWnd ? TRUE : FALSE);
    }

Window::Window(char *winname)
    {
    SetClassInstance();         // insert instance handle
    SetWinInstance(GetInstance());
    SetClassName(winname);
    SetWinName(winname);
    DefaultDisplay();
    previously_visible = FALSE;
    hWnd = 0;
    SetClassWinXbytes(WINAPP_RESERVED);
    lpfnWndProc = DispatchMessage;
    };

    // displays window and creates if not already created
BOOL Window::Display(void)
    {
    Register();
    if(!Create())
        return FALSE;
    Show();
    Update();
    return TRUE;
    }

BOOL Window::Display(int display_style)
    {
    current_display = display_style;
    return Display();
    }

BOOL Window::ClassRegistered(void)
    {
    if(WinClass::ClassRegistered())
        {
//        if(!UserWndProc)
//            SetClassWinProc(lpfnWndProc);
        return TRUE;
        }
    return FALSE;
    }
    // should call SetClassInstance and SetClassName if not called

void Window::RegisterMDIChild(void)
    {
    lpfnWndProc = Window::MDIChildWndProc;
    Register();
    }
        
void Window::Register(void)
    {
    if(!ClassRegistered())         // if class not registered
        {
        if(!GetClassName())         // if class name not set
            SetClassName("WinApplication");
        ClassRegister();           // register the class
        }
    }

BOOL Window::Create(void)
    {
    Register();
    WHdl.hInstance = GetInstance();
    WHdl.classname = lpszClassName;
    WHdl.lpParam = (LPSTR)this;
    return WHdl.Create();
    }

void Window::Paint(void)     // paints window
    {
    PAINTSTRUCT ps;

    BeginPaint(hWnd, &ps);
    EndPaint(hWnd, &ps);
    }

void Window::SetClassIcon(LPSTR iconname)
    {
    if(hInstance)
        hIcon = LoadIcon(hInstance,iconname);
    }

LRESULT CALLBACK Window::MDIChildWndProc(HWND hWnd, UINT msg, WPARAM wParam, 
    LPARAM lParam)
    {
//    pWindow = (void *)GetPointer(hWnd);

    if(msg == WM_CREATE)
        {
#if defined(FIX)
        LONG l = (void *)((LPMDICREATESTRUCT)
            ((LPCREATESTRUCT)lParam)->lpCreateParams)->lParam;
        pWindow = (void *)l;
#endif

//        SetPointer(hWnd, pWindow);
//        ((Window *)pWindow)->hWnd = hWnd;
        }
//    if(pWindow && ((Window *)pWindow)->UserWndProc)
//        return ((Window *)pWindow)->UserWndProc(hWnd, msg, wParam, lParam);
    return DefMDIChildProc(hWnd, msg, wParam, lParam);
    }

void pascal Window::DWP(void)
    {
    MsgReturnValue = DefWindowProc(hWnd,msg,wParam,lParam);
    }

LRESULT CALLBACK DispatchMessage(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
    {
    Window *w = (Window *)GetPointer(hWnd);

    if(msg == WM_CREATE)
        {
        w = (Window *)((LPCREATESTRUCT)lParam)->lpCreateParams;
        SetPointer(hWnd, w);
        w->hWnd = hWnd;
        }

    if(!w)
        return DefWindowProc(hWnd, msg, wParam, lParam);

    w->wParam = wParam;
    w->lParam = lParam;
    w->msg = msg;
    w->MsgReturnValue = 0L;

    if(msg < WM_USER)
        switch(msg)
            {
            case WM_NULL:
	            w->WMNULL();
			    break;

            case WM_CREATE:
	            w->WMCREATE();
			    break;

            case WM_DESTROY:
	            w->WMDESTROY();
			    break;

            case WM_MOVE:
	            w->WMMOVE();
			    break;

            case WM_SIZE:
	            w->WMSIZE();
			    break;

            case WM_ACTIVATE:
	            w->WMACTIVATE();
			    break;

            case WM_SETFOCUS:
	            w->WMSETFOCUS();
			    break;

            case WM_KILLFOCUS:
	            w->WMKILLFOCUS();
			    break;

            case WM_ENABLE:
	            w->WMENABLE();
			    break;

            case WM_SETREDRAW:
	            w->WMSETREDRAW();
			    break;

            case WM_SETTEXT:
	            w->WMSETTEXT();
			    break;

            case WM_GETTEXT:
	            w->WMGETTEXT();
			    break;

            case WM_GETTEXTLENGTH:
	            w->WMGETTEXTLENGTH();
			    break;

            case WM_PAINT:
	            w->WMPAINT();
			    break;

            case WM_CLOSE:
	            w->WMCLOSE();
			    break;

            case WM_QUERYENDSESSION:
	            w->WMQUERYENDSESSION();
			    break;

            case WM_QUIT:
	            w->WMQUIT();
			    break;

            case WM_QUERYOPEN:
	            w->WMQUERYOPEN();
			    break;

            case WM_ERASEBKGND:
	            w->WMERASEBKGND();
			    break;

            case WM_SYSCOLORCHANGE:
	            w->WMSYSCOLORCHANGE();
			    break;

            case WM_ENDSESSION:
	            w->WMENDSESSION();
			    break;

            case WM_SHOWWINDOW:
	            w->WMSHOWWINDOW();
			    break;

            case WM_CTLCOLOR:
	            w->WMCTLCOLOR();
			    break;

            case WM_WININICHANGE:
	            w->WMWININICHANGE();
			    break;

            case WM_DEVMODECHANGE:
	            w->WMDEVMODECHANGE();
			    break;

            case WM_ACTIVATEAPP:
	            w->WMACTIVATEAPP();
			    break;

            case WM_FONTCHANGE:
	            w->WMFONTCHANGE();
			    break;

            case WM_TIMECHANGE:
	            w->WMTIMECHANGE();
			    break;

            case WM_CANCELMODE:
	            w->WMCANCELMODE();
			    break;

            case WM_SETCURSOR:
	            w->WMSETCURSOR();
			    break;

            case WM_MOUSEACTIVATE:
	            w->WMMOUSEACTIVATE();
			    break;

            case WM_CHILDACTIVATE:
	            w->WMCHILDACTIVATE();
			    break;

            case WM_QUEUESYNC:
	            w->WMQUEUESYNC();
			    break;

            case WM_GETMINMAXINFO:
	            w->WMGETMINMAXINFO();
			    break;

//            case WM_PAINTICON:
//	            w->WMPAINTICON();
//			    break;

            case WM_ICONERASEBKGND:
	            w->WMICONERASEBKGND();
			    break;

            case WM_NEXTDLGCTL:
	            w->WMNEXTDLGCTL();
			    break;

            case WM_SPOOLERSTATUS:
	            w->WMSPOOLERSTATUS();
			    break;

            case WM_DRAWITEM:
	            w->WMDRAWITEM();
			    break;

            case WM_MEASUREITEM:
	            w->WMMEASUREITEM();
			    break;

            case WM_DELETEITEM:
	            w->WMDELETEITEM();
			    break;

            case WM_VKEYTOITEM:
	            w->WMVKEYTOITEM();
			    break;

            case WM_CHARTOITEM:
	            w->WMCHARTOITEM();
			    break;

            case WM_SETFONT:
	            w->WMSETFONT();
			    break;

            case WM_GETFONT:
	            w->WMGETFONT();
			    break;

            case WM_QUERYDRAGICON:
	            w->WMQUERYDRAGICON();
			    break;

            case WM_COMPAREITEM:
	            w->WMCOMPAREITEM();
			    break;

            case WM_COMPACTING:
	            w->WMCOMPACTING();
			    break;

            case WM_NCCREATE:
	            w->WMNCCREATE();
			    break;

            case WM_NCDESTROY:
	            w->WMNCDESTROY();
			    break;

            case WM_NCCALCSIZE:
	            w->WMNCCALCSIZE();
			    break;

            case WM_NCHITTEST:
	            w->WMNCHITTEST();
			    break;

            case WM_NCPAINT:
	            w->WMNCPAINT();
			    break;

            case WM_NCACTIVATE:
	            w->WMNCACTIVATE();
			    break;

            case WM_GETDLGCODE:
	            w->WMGETDLGCODE();
			    break;

            case WM_NCMOUSEMOVE:
	            w->WMNCMOUSEMOVE();
			    break;

            case WM_NCLBUTTONDOWN:
	            w->WMNCLBUTTONDOWN();
			    break;

            case WM_NCLBUTTONUP:
	            w->WMNCLBUTTONUP();
			    break;

            case WM_NCLBUTTONDBLCLK:
	            w->WMNCLBUTTONDBLCLK();
			    break;

            case WM_NCRBUTTONDOWN:
	            w->WMNCRBUTTONDOWN();
			    break;

            case WM_NCRBUTTONUP:
	            w->WMNCRBUTTONUP();
			    break;

            case WM_NCRBUTTONDBLCLK:
	            w->WMNCRBUTTONDBLCLK();
			    break;

            case WM_NCMBUTTONDOWN:
	            w->WMNCMBUTTONDOWN();
			    break;

            case WM_NCMBUTTONUP:
	            w->WMNCMBUTTONUP();
			    break;

            case WM_NCMBUTTONDBLCLK:
	            w->WMNCMBUTTONDBLCLK();
			    break;

            case WM_KEYDOWN:
	            w->WMKEYDOWN();
			    break;

            case WM_KEYUP:
	            w->WMKEYUP();
			    break;

            case WM_CHAR:
	            w->WMCHAR();
			    break;

            case WM_DEADCHAR:
	            w->WMDEADCHAR();
			    break;

            case WM_SYSKEYDOWN:
	            w->WMSYSKEYDOWN();
			    break;

            case WM_SYSKEYUP:
	            w->WMSYSKEYUP();
			    break;

            case WM_SYSCHAR:
	            w->WMSYSCHAR();
			    break;

            case WM_SYSDEADCHAR:
	            w->WMSYSDEADCHAR();
			    break;

            case WM_KEYLAST:
	            w->WMKEYLAST();
			    break;

            case WM_INITDIALOG:
	            w->WMINITDIALOG();
			    break;

            case WM_COMMAND:
	            w->WMCOMMAND();
			    break;

            case WM_SYSCOMMAND:
	            w->WMSYSCOMMAND();
			    break;

            case WM_TIMER:
	            w->WMTIMER();
			    break;

            case WM_HSCROLL:
	            w->WMHSCROLL();
			    break;

            case WM_VSCROLL:
	            w->WMVSCROLL();
			    break;

            case WM_INITMENU:
	            w->WMINITMENU();
			    break;

            case WM_INITMENUPOPUP:
	            w->WMINITMENUPOPUP();
			    break;

            case WM_MENUSELECT:
	            w->WMMENUSELECT();
			    break;

            case WM_MENUCHAR:
	            w->WMMENUCHAR();
			    break;

            case WM_ENTERIDLE:
	            w->WMENTERIDLE();
			    break;

            case WM_MOUSEFIRST:
	            w->WMMOUSEMOVE();
			    break;

            case WM_LBUTTONDOWN:
	            w->WMLBUTTONDOWN();
			    break;

            case WM_LBUTTONUP:
	            w->WMLBUTTONUP();
			    break;

            case WM_LBUTTONDBLCLK:
	            w->WMLBUTTONDBLCLK();
			    break;

            case WM_RBUTTONDOWN:
	            w->WMRBUTTONDOWN();
			    break;

            case WM_RBUTTONUP:
	            w->WMRBUTTONUP();
			    break;

            case WM_RBUTTONDBLCLK:
	            w->WMRBUTTONDBLCLK();
			    break;

            case WM_MBUTTONDOWN:
	            w->WMMBUTTONDOWN();
			    break;

            case WM_MBUTTONUP:
	            w->WMMBUTTONUP();
			    break;

            case WM_MBUTTONDBLCLK:
	            w->WMMOUSELAST();
			    break;

            case WM_PARENTNOTIFY:
	            w->WMPARENTNOTIFY();
			    break;

            case WM_MDICREATE:
	            w->WMMDICREATE();
			    break;

            case WM_MDIDESTROY:
	            w->WMMDIDESTROY();
			    break;

            case WM_MDIACTIVATE:
	            w->WMMDIACTIVATE();
			    break;

            case WM_MDIRESTORE:
	            w->WMMDIRESTORE();
			    break;

            case WM_MDINEXT:
	            w->WMMDINEXT();
			    break;

            case WM_MDIMAXIMIZE:
	            w->WMMDIMAXIMIZE();
			    break;

            case WM_MDITILE:
	            w->WMMDITILE();
			    break;

            case WM_MDICASCADE:
	            w->WMMDICASCADE();
			    break;

            case WM_MDIICONARRANGE:
	            w->WMMDIICONARRANGE();
			    break;

            case WM_MDIGETACTIVE:
	            w->WMMDIGETACTIVE();
			    break;

            case WM_MDISETMENU:
	            w->WMMDISETMENU();
			    break;

            case WM_CUT:
	            w->WMCUT();
			    break;

            case WM_COPY:
	            w->WMCOPY();
			    break;

            case WM_PASTE:
	            w->WMPASTE();
			    break;

            case WM_CLEAR:
	            w->WMCLEAR();
			    break;

            case WM_UNDO:
	            w->WMUNDO();
			    break;

            case WM_RENDERFORMAT:
	            w->WMRENDERFORMAT();
			    break;

            case WM_RENDERALLFORMATS:
	            w->WMRENDERALLFORMATS();
			    break;

            case WM_DESTROYCLIPBOARD:
	            w->WMDESTROYCLIPBOARD();
			    break;

            case WM_DRAWCLIPBOARD:
	            w->WMDRAWCLIPBOARD();
			    break;

            case WM_PAINTCLIPBOARD:
	            w->WMPAINTCLIPBOARD();
			    break;

            case WM_VSCROLLCLIPBOARD:
	            w->WMVSCROLLCLIPBOARD();
			    break;

            case WM_SIZECLIPBOARD:
	            w->WMSIZECLIPBOARD();
			    break;

            case WM_ASKCBFORMATNAME:
	            w->WMASKCBFORMATNAME();
			    break;

            case WM_CHANGECBCHAIN:
	            w->WMCHANGECBCHAIN();
			    break;

            case WM_HSCROLLCLIPBOARD:
	            w->WMHSCROLLCLIPBOARD();
			    break;

            case WM_QUERYNEWPALETTE:
	            w->WMQUERYNEWPALETTE();
			    break;

            case WM_PALETTEISCHANGING:
	            w->WMPALETTEISCHANGING();
			    break;

            case WM_PALETTECHANGED:
	            w->WMPALETTECHANGED();
			    break;

            default:
                w->DWP();
                break;
            }
    else
        {
        w->UserMessageUsed = FALSE;
        w->UserMessages();
        }
    return w->MsgReturnValue;
    }
