/----------------------------------------------------------------
// BPMEM.C
//
// BPlus Tree memory allocation functions
//
//---------------------------------------------------------------

#include <windows.h>
#include "bptree.h"

//---------------------------------------------------------------
// Entry point for Windows DLL
//---------------------------------------------------------------

int FAR PASCAL LibMain(  HANDLE hInstance, WORD wDataSeg, WORD wHeapSize, LPSTR lpszCmdLine ) {
   if ( wHeapSize > 0 )
      UnlockData( 0 );
   return( 1 );
}

//--------------------------------------------------------------
// Memory allocation function implementations for Windows
//--------------------------------------------------------------

void FAR * FAR Malloc( DWORD bytes ) {
   return GlobalLock( GlobalAlloc( GHND, bytes ) );
}
   
void FAR Free( void FAR *memory ) {
   GLOBALHANDLE hMemory;
   if( memory == NULL )
      return;
   hMemory = (GLOBALHANDLE)GlobalHandle( (UINT)SELECTOROF( memory ) );
   GlobalUnlock( hMemory );
   GlobalFree( hMemory );
}
