/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
** PROJECT NAME: Abstract Data Types Library
**
** MODULE  NAME: HEAP.H 
**	  Class HEAP is responsible for doing sub-segment allocation as outlined
**   in the Norton & Yao text on Windows Programming.
**
**   Instantiate a HEAP to get an allocator for doing inequally sized
**   objects (ie. mallocs).  An HEAP can store upto 64K of objects (total).
**
** $Header:   E:/ADT.LIB/VCS/HEAP.H_V   1.1   03 Jul 1992 22:34:16   GenKiyooka  $
**
**   AUTHOR.: Gen Kiyooka 
**
**   NAME DESCRIBES CLASS - LOCATION:  The naming convention for functions
**     attempts to describe the location and the class of the function. 
**       ie. BOX_Display is a method of Class BOX (in BOX.C)
**
** $Log:   E:/ADT.LIB/VCS/HEAP.H_V  $
 * 
 *    Rev 1.1   03 Jul 1992 22:34:16   GenKiyooka
 * Added some documentation.
 * 
 *    Rev 1.0   22 May 1992 06:58:52   GenKiyooka
 * Initial revision.
*/

// Under Win32, this stuff is simply ignored.  The HEAP.C module should
// be excluded from the build under Win32.

#ifndef WIN32

#define HEAP_SERIALIZE 0		// simply provided for source compatibility

HANDLE HeapCreate( UINT fdwHeap, UINT cbInitial, UINT cbMaximum );
LPSTR HeapAlloc( HANDLE hHeap, UINT cbAlloc );
BOOL  HeapFree( HANDLE hHeap, LPSTR lpMem );
UINT 	HeapSize( HANDLE hHeap, LPSTR lpMem );
BOOL  HeapDestroy( HANDLE hHeap );

#endif
