# Makefile : Builds wxWindows library wx.lib for Windows 3.1
# written for Borland C++ 3.1 by Edmund J. Sutcliffe, <edmund@york.ac.uk>
#				 with a little help from prj2mak
#
# Change WXDIR to be wherever wxWindows is on your system.
.AUTODEPEND

#		*Translator Definitions*
CC = bcc +WX.CFG
TASM = tasm
TLIB = tlib
TLINK = tlink
# Replace WXDIR with the path of the root of the wxWindows Distribution
WXDIR = f:\wxwin
WXLIB = $(WXDIR)\LIB
WXINC = $(WXDIR)\INCLUDE
LIBPATH = P:\BCC\LIB
INCLUDEPATH = P:\BCC\INCLUDE;$(WXINC)

.PATH.obj = $(WXLIB)

#		*Implicit Rules*
.c.obj:
  $(CC) -c {$< }

.cpp.obj:
  $(CC) -c {$< }

#		*List Macros*


LIB_dependencies =  \
 wx_canvs.obj \
 wx_dc.obj \
 wx_dialg.obj \
 wx_event.obj \
 wx_form.obj \
 wx_help.obj \
 wx_frame.obj \
 wx_gdi.obj \
 wx_hash.obj \
 wx_ipc.obj \
 wx_item.obj \
 wx_list.obj \
 wx_main.obj \
 wx_obj.obj \
 wx_panel.obj \
 wx_text.obj \
 wx_timer.obj \
 wx_utils.obj \
 wx_win.obj

#		*Explicit Rules*
..\lib\wx.lib: wx.cfg $(LIB_dependencies)
  - del ..\lib\wx.lib
  $(TLIB) $< /C/P64 @&&|
-+..\lib\wx_canvs.obj &
-+..\lib\wx_dc.obj &
-+..\lib\wx_dialg.obj &
-+..\lib\wx_event.obj &
-+..\lib\wx_form.obj &
-+..\lib\wx_help.obj &
-+..\lib\wx_frame.obj &
-+..\lib\wx_gdi.obj &
-+..\lib\wx_hash.obj &
-+..\lib\wx_ipc.obj &
-+..\lib\wx_item.obj &
-+..\lib\wx_list.obj &
-+..\lib\wx_main.obj &
-+..\lib\wx_obj.obj &
-+..\lib\wx_panel.obj &
-+..\lib\wx_text.obj &
-+..\lib\wx_timer.obj &
-+..\lib\wx_utils.obj &
-+..\lib\wx_win.obj,$*.lst
|


#		*Individual File Dependencies*
wx_canvs.obj: wx.cfg wx_canvs.cc 
	$(CC) -c wx_canvs.cc

wx_dc.obj: wx.cfg wx_dc.cc 
	$(CC) -c wx_dc.cc

wx_dialg.obj: wx.cfg wx_dialg.cc 
	$(CC) -c wx_dialg.cc

wx_event.obj: wx.cfg wx_event.cc 
	$(CC) -c wx_event.cc

wx_form.obj: wx.cfg wx_form.cc 
	$(CC) -c wx_form.cc

wx_help.obj: wx.cfg wx_help.cc
	$(CC) -c wx_help.cc

wx_frame.obj: wx.cfg wx_frame.cc 
	$(CC) -c wx_frame.cc

wx_gdi.obj: wx.cfg wx_gdi.cc 
	$(CC) -c wx_gdi.cc

wx_hash.obj: wx.cfg wx_hash.cc 
	$(CC) -c wx_hash.cc

wx_ipc.obj: wx.cfg wx_ipc.cc 
	$(CC) -c wx_ipc.cc

wx_item.obj: wx.cfg wx_item.cc 
	$(CC) -c wx_item.cc

wx_list.obj: wx.cfg wx_list.cc 
	$(CC) -c wx_list.cc

wx_main.obj: wx.cfg wx_main.cc 
	$(CC) -c wx_main.cc

wx_obj.obj: wx.cfg wx_obj.cc 
	$(CC) -c wx_obj.cc

wx_panel.obj: wx.cfg wx_panel.cc 
	$(CC) -c wx_panel.cc

wx_text.obj: wx.cfg wx_text.cc 
	$(CC) -c wx_text.cc

wx_timer.obj: wx.cfg wx_timer.cc 
	$(CC) -c wx_timer.cc

wx_utils.obj: wx.cfg wx_utils.cc 
	$(CC) -c wx_utils.cc

wx_win.obj: wx.cfg wx_win.cc 
	$(CC) -c wx_win.cc

#		*Compiler Configuration File*
wx.cfg: makefile.bcc    
  copy &&|
-ml!
-3
-w+
-O
-Oe
-Z
-k-
-d
-WD
-n$(WXLIB)
-I$(INCLUDEPATH)
-L$(LIBPATH)
-Dwx_msw
-P.CC
| wx.cfg



