/*
 * A contribution from ks@fi.tut.cs.karikukko
 *
 * - popup menus for canvases
 * - menu buttons for panels
 *
 * (XView only)
 *
 */

#include <xview/panel.h>

typedef void (*call_back_function)(Menu_item menu_item);

class wxPopupMenu: public wxMenu {
  char *label_str;
  void (*menu_callback) (Menu_item menu_item);
  void xv_call_back(Menu menu, Menu_item menu_item) {
    cerr << "xv_call_back\n";
    this->menu_callback(menu_item);
  };
public:
  wxPopupMenu(char *Tit=NULL,wxFunction func=NULL) : wxMenu(Tit,func) {
    label_str = Tit;
  };
  virtual void SetPinnable(wxFrame *Frame) {
    xv_set((Menu)this->handle, MENU_GEN_PIN_WINDOW, Frame->handle, 
	   label_str,
	   NULL);
  };
  virtual void SetLabel(char *lbl) {
    label_str = lbl;
    xv_set((Menu)this->handle, MENU_TITLE_ITEM, label_str, NULL);
  };
    
  void Show(wxCanvas *window, wxEvent *event,
		    call_back_function call_back)
    {
    wxEvent ev;
    Callback((wxFunction)call_back);
	   
    xv_set((Menu)this->handle,
	   MENU_NOTIFY_PROC, wxPopupMenu::xv_call_back,
	   NULL);
    menu_show((Menu)this->handle,
	      (Xv_opaque)window->handle,
	      event->event_handle, NULL);
	   

  };
};

class wxMenuButton : public wxButton {
 public:
  wxMenuButton (wxPanel *parent, wxFunction func, char *label, wxPopupMenu *menu,
		int x = -1, int y = -1, int width = -1, int height = -1) :
		  wxButton(parent, func, label, x, y, width, height) {
		    (void)xv_set((Xv_opaque)handle,
				 PANEL_ITEM_MENU, (Menu)menu->handle,
				 NULL);
		  };
};

