/*
 * File:     wx_canvs.h
 * Purpose:  wxCanvas subwindow declarations
 *
 *                       wxWindows 1.40
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                       Date: 18-4-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef wx_canvsh
#define wx_canvsh

#include <iostream.h>
#include "common.h"
#include "wx_frame.h"
#include "wx_gdi.h"

#ifdef wx_xview
#include <xview/canvas.h>
#include <xview/scrollbar.h>
#include <xview/xv_xrect.h>
#endif

// Canvas subwindow for drawing on
class wxCanvas: public wxWindow
{
 public:
  wxDC *wx_dc;    // The canvas's real context
  wxDC *context;  // Switchable context, normally = wx_dc
#ifdef wx_motif
  Widget scrolledWindow;
  void PreResize(void);
  Bool hScroll;
  Bool vScroll;
  int  hExtent;   // Actual extent of virtual scrolled canvas
  int  vExtent;
  Widget hScrollBar;
  Widget vScrollBar;
  Bool allowRepainting;
  Bool hScrollingEnabled;
  Bool vScrollingEnabled;
  // The next 4 values need to be stored because Xt refuses to
  // return the correct values. (I may be wrong here actually...)
  int canvasWidth;
  int canvasHeight;
  int canvasX;
  int canvasY;
  Pixmap backingPixmap;
  int pixmapWidth;
  int pixmapHeight;
  int pixmapOffsetX;
  int pixmapOffsetY;
  // Need to store state of buttons (whether they're still down)
  Bool button1Pressed;
  Bool button2Pressed;
  Bool button3Pressed;
  void Refresh(void);
#endif
#ifdef wx_xview
  int DRAG_MAX;
  int drag_count;
  int repaint_countdown;
  Xv_xrectlist *xrects;
#endif
#ifdef wx_msw
  Bool clipping;
  int clip_x1;
  int clip_y1;
  int clip_x2;
  int clip_y2;
#endif
  Bool is_retained;
  int horiz_units;
  int vert_units;

  wxCanvas(wxFrame *frame, int x=-1, int y=-1, int width=-1, int height=-1,
           int style = wxRETAINED);
  virtual ~wxCanvas(void);

  void SetSize(int x, int y, int width, int height);
  void SetClientSize(int width, int height);
  void GetSize(int *width, int *height);
  void GetClientSize(int *width, int *height);
  void GetPosition(int *x, int *y);

  // Number of pixels per user unit (0 or -1 for no scrollbar)
  // Length of virtual canvas in user units
  // Length of page in user units
  virtual void SetScrollbars(int horizontal, int vertical,
                             int x_length, int y_length,
                             int x_page, int y_page);

  // Scroll the canvas
  virtual void Scroll(int x_pos, int y_pos);

#ifdef wx_xview
// Every time a callback happens, these are set to point to the right values
// for drawing calls to work
  Xv_Window paint_window;
  Scrollbar horiz_scroll;
  Scrollbar vert_scroll;
#endif
#ifdef wx_x
  Display *display;
  Window xwindow;
#endif
  virtual void DrawLine(float x1, float y1, float x2, float y2);
  virtual void DrawPoint(float x, float y);
  virtual void DrawLines(int n, wxPoint points[], float xoffset = 0, float yoffset = 0);
  virtual void DrawLines(wxList *list, float xoffset = 0, float yoffset = 0);
  virtual void DrawPolygon(int n, wxPoint points[], float xoffset = 0, float yoffset = 0);
  virtual void DrawPolygon(wxList *list, float xoffset = 0, float yoffset = 0);
  virtual void DrawRectangle(float x, float y, float width, float height);
  virtual void DrawRoundedRectangle(float x, float y, float width, float height, float radius = 20);
  virtual void DrawEllipse(float x, float y, float width, float height);

  // Splines
  // 3-point spline
  virtual void DrawSpline(float x1, float y1, float x2, float y2, float x3, float y3);
  // Any number of control points - a list of pointers to wxPoints
  virtual void DrawSpline(wxList *points);

  virtual void Clear(void);
  virtual void ViewStart(int *x, int *y);
  virtual void SetFont(wxFont *font);
  virtual void SetPen(wxPen *pen);
  virtual void SetBrush(wxBrush *brush);
  virtual void SetLogicalFunction(int function);
  virtual void SetBackground(wxBrush *brush);
  virtual void SetTextForeground(wxColour *colour);
  virtual void SetTextBackground(wxColour *colour);
  virtual void SetClippingRegion(float x, float y, float width, float height);
  virtual void DestroyClippingRegion(void);
  virtual void DrawText(char *text, float x, float y);

  // Actual size in pixels when scrolling is taken into account
  virtual void GetVirtualSize(int *x, int *y);
  virtual int GetTextFamily(void);
  virtual int GetTextStyle(void);
  virtual int GetTextWeight(void);
  virtual float GetTextHeight(void);
  virtual float GetTextWidth(void);
  virtual void GetTextExtent(char *string, float *x, float *y);

  // Gets 'context' member
  virtual wxDC *GetDC(void);

  // Use this to set the canvas's 'context' member to
  // a user-supplied dc
  void SetContext(wxDC *dc);
  // Reset 'context' back to the canvas' context
  void ResetContext(void);

  // Enable/disable Windows 3.1 scrolling in either direction.
  // If TRUE, wxWindows scrolls the canvas and only a bit of
  // the canvas is invalidated; no Clear() is necessary.
  // If FALSE, the whole canvas is invalidated and a Clear() is
  // necessary. Disable for when the scroll increment is used
  // to actually scroll a non-constant distance
  void EnableScrolling(Bool x_scrolling, Bool y_scrolling);

#ifdef wx_msw
  void PreDelete(HDC dc);
#endif

  Bool IsRetained(void) { return is_retained; }

  // Fix for too many XView repaints - call this with n if you know there are too many
  // repaints, and canvas will be drawn after 0 is reached
  // Doesn't actually work unfortunately...
  void SetCountdown(int count);
};

#endif // wc_canvsh
