/*
 * File:     wx_gdi.h
 * Purpose:  Declaration of various graphics objects - fonts, pens, icons etc.
 *
 *                       wxWindows 1.40
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                       Date: 18-4-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */


#ifndef wx_gdih
#define wx_gdih

#ifdef wx_motif
#include <Xm/Xm.h>
#endif

#ifdef wx_xview
#include <xview/font.h>
#include <xview/icon.h>
#include <xview/cursor.h>
#endif

#ifdef wx_msw
#include <windows.h>
#endif

// Standard cursors
#define wxCURSOR_ARROW           1
#define wxCURSOR_BULLSEYE        2
#define wxCURSOR_CHAR            3
#define wxCURSOR_CROSS           4
#define wxCURSOR_HAND            5
#define wxCURSOR_IBEAM           6
#define wxCURSOR_LEFT_BUTTON     7
#define wxCURSOR_MAGNIFIER       8
#define wxCURSOR_MIDDLE_BUTTON   9
#define wxCURSOR_NO_ENTRY       10
#define wxCURSOR_PAINT_BRUSH    11
#define wxCURSOR_PENCIL         12
#define wxCURSOR_POINT_LEFT     13
#define wxCURSOR_POINT_RIGHT    14
#define wxCURSOR_QUESTION_ARROW 15
#define wxCURSOR_RIGHT_BUTTON   16
#define wxCURSOR_SIZENESW       17
#define wxCURSOR_SIZENS         18
#define wxCURSOR_SIZENWSE       19
#define wxCURSOR_SIZEWE         20
#define wxCURSOR_SIZING         21
#define wxCURSOR_SPRAYCAN       22
#define wxCURSOR_WAIT           23
#define wxCURSOR_WATCH          24

// Font
class wxFont: public wxObject
{
 public:
  Bool temporary;   // If TRUE, the pointer to the actual font
                    // is temporary and SHOULD NOT BE DELETED by
                    // destructor
  int point_size;
  int family;
  int style;
  int weight;
#ifdef wx_motif
  XFontStruct *xFont;
#endif
#ifdef wx_xview
  Xv_Font x_font;
#endif
#ifdef wx_msw
  HFONT cfont;
#endif
  wxFont(void);
  wxFont(int PointSize, int Family, int Style, int Weight);
  ~wxFont(void);

  int GetPointSize(void);
};

// Colour
class wxColour: public wxObject
{
 public:
  char red;
  char blue;
  char green;

  wxColour(char r, char b, char g);
  wxColour(char *col);

  virtual void Set(char r, char b, char g);
  virtual void Get(char *r, char *b, char *g);

  virtual char Red(void);
  virtual char Green(void);
  virtual char Blue(void);
};

// Point
class wxPoint: public wxObject
{
 public:
  float x;
  float y;
  wxPoint(void);
  wxPoint(float the_x, float the_y);
};

// Pen
class wxPen: public wxObject
{
 public:
  int width;
  int style;
  wxColour *colour;
#ifdef wx_msw
  HPEN cpen;
#endif

  wxPen(void);
  wxPen(int width);
  wxPen(wxColour& col, int width, int style);
  wxPen(char *col, int width, int style);
  ~wxPen(void);

  virtual void SetColour(wxColour& col);
  virtual void SetColour(char *col);
  virtual void SetColour(char r, char g, char b);

  virtual void SetWidth(int width);
  virtual void SetStyle(int style);

  virtual wxColour &GetColour(void);
  virtual int GetWidth(void);
  virtual int GetStyle(void);
};

#ifdef wx_msw
int wx2msPenStyle(int wx_style);
#endif

// Brush
class wxBrush: public wxObject
{
 public:
  int style;
  wxColour *colour;
#ifdef wx_msw
  HBRUSH cbrush;
#endif

  wxBrush(void);
  wxBrush(wxColour& col, int style);
  wxBrush(char *col, int style);
  ~wxBrush(void);

  virtual void SetColour(wxColour& col);
  virtual void SetColour(char *col);
  virtual void SetColour(char r, char g, char b);

  virtual void SetStyle(int style);
  virtual wxColour &GetColour(void);
  virtual int GetStyle(void);
};

// Icon
class wxIcon: public wxObject
{
 public:
#ifdef wx_motif
  int iconWidth;
  int iconHeight;
  Pixmap x_pixmap;
#endif
#ifdef wx_xview
  Server_image x_image;
  Icon x_icon;
#endif
#ifdef wx_msw
  HICON ms_icon;
#endif
  wxIcon(short bits[], int width, int height);
  wxIcon(char *name);
  ~wxIcon(void);
};

// Cursor
class wxCursor: public wxObject
{
 public:
#ifdef wx_motif
  Cursor x_cursor;
  Bool use_raw_x_cursor;
#endif
#ifdef wx_xview
  Xv_Cursor x_cursor;
  Bool use_raw_x_cursor;
#endif
#ifdef wx_msw
  HCURSOR ms_cursor;
#endif
  wxCursor(short bits[], int width, int height);
  wxCursor(char *name);
  wxCursor(int cursor_type);
  ~wxCursor(void);
};

// Bitmap
class wxBitmap: public wxObject
{
 public:
  int width;
  int height;
  int no_bits;
  int no_planes;
#ifdef wx_x
  Pixmap x_pixmap;
#endif
#ifdef wx_xview
  Server_image x_image;
#endif
#ifdef wx_msw
  HBITMAP ms_bitmap;
#endif
  wxBitmap(short bits[], int width, int height, int no_bits = 1);
  wxBitmap(char *name);
  ~wxBitmap(void);

  inline int GetWidth(void) { return width; }
  inline int GetHeight(void) { return height; }
};

// Management of pens, brushes and fonts
class wxPenList: public wxList
{
 public:
  wxPenList(void)
    { }
  ~wxPenList(void);
  void AddPen(wxPen *pen);
  void RemovePen(wxPen *pen);
  wxPen *FindOrCreatePen(wxColour *colour, int width, int style);
  wxPen *FindOrCreatePen(char *colour, int width, int style);
};

class wxBrushList: public wxList
{
 public:
  wxBrushList(void)
    { }
  ~wxBrushList(void);
  void AddBrush(wxBrush *brush);
  void RemoveBrush(wxBrush *brush);
  wxBrush *FindOrCreateBrush(wxColour *colour, int style);
  wxBrush *FindOrCreateBrush(char *colour, int style);
};

class wxColourDatabase: public wxList
{
 public:
  wxColourDatabase(int type);
  wxColour *FindColour(char *colour);
  char *FindName(wxColour& colour);
  void Initialize(void);
};

class wxGDIList: public wxList
{
 public:
   wxGDIList(void);
  ~wxGDIList(void);
};

// Lists of GDI objects
extern wxPenList   *wxThePenList;
extern wxBrushList *wxTheBrushList;
extern wxGDIList   *wxTheIconList;
extern wxGDIList   *wxTheFontList;
extern wxGDIList   *wxTheBitmapList;

// Stock objects
extern wxFont *wxNORMAL_FONT;
extern wxFont *wxSMALL_FONT;
extern wxFont *wxITALIC_FONT;
extern wxFont *wxSWISS_FONT;
extern wxPen *wxRED_PEN;
extern wxPen *wxCYAN_PEN;
extern wxPen *wxGREEN_PEN;
extern wxPen *wxBLACK_PEN;
extern wxPen *wxTRANSPARENT_PEN;
extern wxPen *wxBLACK_DASHED_PEN;

extern wxBrush *wxBLUE_BRUSH;
extern wxBrush *wxGREEN_BRUSH;
extern wxBrush *wxWHITE_BRUSH;
extern wxBrush *wxBLACK_BRUSH;
extern wxBrush *wxGREY_BRUSH;
extern wxBrush *wxMEDIUM_GREY_BRUSH;
extern wxBrush *wxLIGHT_GREY_BRUSH;
extern wxBrush *wxTRANSPARENT_BRUSH;
extern wxBrush *wxCYAN_BRUSH;
extern wxBrush *wxRED_BRUSH;

extern wxColour *wxBLACK;
extern wxColour *wxWHITE;
extern wxColour *wxRED;
extern wxColour *wxBLUE;
extern wxColour *wxGREEN;
extern wxColour *wxCYAN;
extern wxColour *wxLIGHT_GREY;

// Stock cursors types
extern wxCursor *wxSTANDARD_CURSOR;
extern wxCursor *wxHOURGLASS_CURSOR;
extern wxCursor *wxCROSS_CURSOR;

extern wxColourDatabase *wxTheColourDatabase;
extern void wxInitializeStockObjects(void);

extern Bool wxColourDisplay(void);
extern void wxDisplaySize(int *width, int *height);

extern void wxSetCursor(wxCursor *cursor);

#ifdef wx_x
// X-specific font matching mechanism
class XFontInfo: public wxObject
{
 public:
  int family;
  int style;
  int weight;
  int point_size; // Points in XView, 10ths of a point in Motif
#ifdef wx_xview
  Xv_Font font;
#endif
#ifdef wx_motif
  XFontStruct *font;
#endif
  XFontInfo(int the_family, int the_style, int the_weight, int the_point_size,
#ifdef wx_xview
            Xv_Font the_font);
#endif
#ifdef wx_motif
            XFontStruct *the_font);
#endif
};

class XFontPool: public wxList
{
  XFontInfo *cache;
 public:
  XFontPool(void);
  void AddFont(int family, int style, int weight, int point_size,
#ifdef wx_xview
               Xv_Font font);
#endif
#ifdef wx_motif
               XFontStruct *font);
#endif
#ifdef wx_xview
  Xv_Font
#endif
#ifdef wx_motif
  XFontStruct *
#endif
    FindFont(int family, int style, int weight, int point_size);

#ifdef wx_xview
  Xv_Font
#endif
#ifdef wx_motif
  XFontStruct *
#endif
    FindOrCreateFont(int family, int style, int weight, int point_size, int point_size_to_store, int xres, int yres);

#ifdef wx_xview
  Xv_Font FindNearestFont(int family, int style, int weight, int point_size, int xres, int yres);
#endif
#ifdef wx_motif
  XFontStruct *FindNearestFont(int family, int style, int weight, int point_size, int xres, int yres);
#endif
};

extern XFontPool *wxFontPool;
#endif

#endif // wx_gdih
