/*
 * File:     wx_help.h
 * Purpose:  API for invoking wxHelp
 *
 *                       wxWindows 1.40
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                       Date: 18-4-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef wx_helph
#define wx_helph

#include <stdio.h>
#include <wx.h>
#include "wx_hash.h"

class wxHelpInstance;
class wxHelpConnection: public wxConnection
{
 public:
  wxHelpInstance *helpInstance;
  wxHelpConnection(wxHelpInstance *instance) { helpInstance = instance; }
  Bool OnDisconnect(void);
};

// An application can have one or more instances of wxHelp,
// represented by an object of this class.
// Nothing happens on initial creation; the application
// must call a member function to display help.
// If the instance of wxHelp is already active, that instance
// will be used for subsequent help.

class wxHelpInstance: wxClient
{
 public:
  char *helpFile;
  int  helpServer;
  char *helpHost;
  Bool helpRunning;
  wxHelpConnection *helpConnection;
  wxHelpInstance(void)
    { helpFile = NULL; helpServer = -1; helpHost = NULL;
      helpRunning = FALSE; helpConnection = NULL; }
  ~wxHelpInstance(void)
    { if (helpFile) delete helpFile; 
      if (helpHost) delete helpHost;
    }

  // Must call this to set the filename and server name
  Bool Initialize(char *file, int server = -1);
  // If file is NULL, reloads file given  in Initialize
  Bool LoadFile(char *file = NULL);
  Bool DisplayContents(void);
  Bool DisplaySection(int sectionNo);
  Bool DisplayBlock(long blockNo);
  Bool KeywordSearch(char *k);

  Bool Quit(void);
  virtual void OnQuit(void);

  // Private
  Bool Run(void);

  wxConnection *OnMakeConnection(void)
    { return new wxHelpConnection(this); 
    }
};


#endif // wx_helph
