/*
 * File:     wx_ipc.h
 * Purpose:  Interprocess communication implementation. Uses DDE under
 *           Windows, sockets to implement DDE subset under UNIX
 *
 *                       wxWindows 1.40
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                       Date: 18-4-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef wx_ipch
#define wx_ipch

#include "common.h"
#include "wx_frame.h"
#include "wx_utils.h"

#ifdef wx_msw
#include <ddeml.h>
#endif

// Message codes
#define wxEXECUTE        1
#define wxREQUEST        2
#define wxPOKE           3
#define wxADVISE_START   4
#define wxADVISE_REQUEST 5
#define wxADVISE         6
#define wxADVISE_STOP    7
#define wxREQUEST_REPLY  8
#define wxFAIL           9
#define wxCONNECT        10
#define wxDISCONNECT     11

// Error codes
#define wxGENERAL          2
#define wxBAD_SERVICE_NAME 3

// Clipboard formats - only ASCII text so far
#ifdef wx_msw
#define wxCF_TEXT CF_TEXT
#endif

#ifdef wx_x
#define wxCF_TEXT 1
#endif

/*
 * Mini-DDE implementation

   Most transactions involve a topic name and an item name (choose these
   as befits your application).

   A client can:

   - ask the server to execute commands (data) associated with a topic
   - request data from server by topic and item
   - poke data into the server
   - ask the server to start an advice loop on topic/item
   - ask the server to stop an advice loop

   A server can:

   - respond to execute, request, poke and advice start/stop
   - send advise data to client

   Note that this limits the server in the ways it can send data to the
   client, i.e. it can't send unsolicited information.
 *
 */

// Always call before starting IPC
void wxIPCInitialize(void);

class wxIPCObject;

class wxServer;
class wxClient;
class wxConnection: public wxObject
{
 public:
  char *buf_ptr;
  char *topic_name;
  int buf_size;
  wxServer *server;
  wxClient *client;
#ifdef wx_motif
  unsigned long xtInputId;
#endif
#ifdef wx_x
  int input_fd;
  int output_fd;
#endif
#ifdef wx_msw
  HCONV hConv;
  char *sending_data;
  int data_size;
  int data_type;
#endif
  wxConnection(char *buffer, int size);
  wxConnection(void);
  ~wxConnection(void);

  // Callbacks to SERVER - override at will
  virtual Bool OnExecute(char *topic, char *data, int size, int format);
  virtual char *OnRequest(char *topic, char *item, int *size, int format);
  virtual Bool OnPoke(char *topic, char *item, char *data, int size, int format);
  virtual Bool OnStartAdvise(char *topic, char *item);
  virtual Bool OnStopAdvise(char *topic, char *item);

  // Callbacks to CLIENT - override at will
  virtual Bool OnAdvise(char *topic, char *item, char *data, int size, int format);

  // Callbacks to BOTH

  // Default behaviour is to delete connection and return TRUE
  virtual Bool OnDisconnect(void);

  // Calls that CLIENT can make
  virtual Bool Execute(char *data, int size = -1, int format = wxCF_TEXT);
  virtual char *Request(char *item, int *size = NULL, int format = wxCF_TEXT);
  virtual Bool Poke(char *item, char *data, int size = -1, int format = wxCF_TEXT);
  virtual Bool StartAdvise(char *item);
  virtual Bool StopAdvise(char *item);

  // Calls that SERVER can make
  virtual Bool Advise(char *item, char *data, int size = -1, int format = wxCF_TEXT);

  // Calls that both can make
  Bool Disconnect(void);
  void Notify(Bool notify);  // Internal use only
};

class wxIPCObject: public wxObject
{
 public:
  int lastError;
  char *service_name; // Server only
  wxList connections;
  wxIPCObject(void);
  ~wxIPCObject(void);

#ifdef wx_msw
  // Find/delete wxConnection corresponding to the HCONV
  wxConnection *FindConnection(HCONV conv);
  Bool DeleteConnection(HCONV conv);
#endif
};

class wxServer: public wxIPCObject
{
 public:

#ifdef wx_x
  int server_socket;
#endif
  wxServer(void);
  ~wxServer(void);
  Bool Create(char *server_name); // Returns FALSE if can't create server (e.g. port
                                  // number is already in use)
  virtual wxConnection *OnAcceptConnection(char *topic);
};

class wxClient: public wxIPCObject
{
 public:
#ifdef wx_x
  int client_socket;
#endif
  wxClient(void);
  ~wxClient(void);
  Bool ValidHost(char *host);
  virtual wxConnection *MakeConnection(char *host, char *server, char *topic);
                                                // Call this to make a connection.
                                                // Returns NULL if cannot.
  virtual wxConnection *OnMakeConnection(void); // Tailor this to return own connection.
};

class wxChild: public wxObject
{
 public:
  int the_pid;
  wxChild(void);
  Bool Create(char *command, char *argv[]);
  virtual wxConnection *OnSpawn(int pid);
  virtual void OnDeath(void);
};

#endif // wx_ipc.h
